/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class CookieParser {
    public static boolean cookiesContain(String[] requiredCookies, String cookies) {
        if (cookies == null) {
            return false;
        }
        boolean[] cookieFound = new boolean[requiredCookies.length];
        String[] names = CookieParser.getCookiesNames(cookies);
        for (int j = 0; j < names.length; ++j) {
            String cookieName = names[j];
            for (int i = 0; i < requiredCookies.length; ++i) {
                if (!requiredCookies[i].equals(cookieName)) continue;
                cookieFound[i] = true;
            }
        }
        for (int i = 0; i < cookieFound.length; ++i) {
            if (cookieFound[i]) continue;
            return false;
        }
        return true;
    }

    public static String[] getCookiesNames(String cookies) {
        if (cookies == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(cookies, "; ");
        ArrayList<String> names = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String cookie = st.nextToken();
            int separator = cookie.indexOf("=");
            if (separator <= -1) continue;
            names.add(cookie.substring(0, separator));
        }
        String[] result = names.toArray(new String[names.size()]);
        return result;
    }
}

