/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.metasearch.impl.DateParser;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateParserClassic
extends DateParser {
    static boolean DEBUG = false;
    TimeZone timeZone;
    DateFormat ddMMMyyyyFormat;
    DateFormat ddMMMyyFormat;
    DateFormat MMddyyyyFormat;
    DateFormat userDateFormat;
    boolean auto;

    public DateParserClassic() {
        this("GMT", true, null);
    }

    public DateParserClassic(String timeZone, boolean auto, String dateFormat) {
        this.timeZone = TimeZone.getTimeZone(timeZone);
        this.auto = auto;
        if (!auto && dateFormat != null) {
            this.userDateFormat = new SimpleDateFormat(dateFormat);
            this.userDateFormat.setTimeZone(this.timeZone);
        }
        this.ddMMMyyyyFormat = new SimpleDateFormat("dd MMM yyyy");
        this.ddMMMyyyyFormat.setTimeZone(this.timeZone);
        this.ddMMMyyFormat = new SimpleDateFormat("dd MMM yy");
        this.ddMMMyyFormat.setTimeZone(this.timeZone);
        this.MMddyyyyFormat = new SimpleDateFormat("MM-dd yyyy");
        this.MMddyyyyFormat.setTimeZone(this.timeZone);
    }

    public Date parseDate(String date) {
        Date result = null;
        if (this.auto) {
            result = this.parseDateInternal(date);
        } else if (this.userDateFormat != null) {
            try {
                result = this.userDateFormat.parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (DEBUG) {
            System.out.println(date + " > " + result.toString());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date parseDateInternal(String s) {
        GregorianCalendar calendar;
        GregorianCalendar calendar2;
        StringTokenizer st;
        block44: {
            block43: {
                String thirdCharacter;
                block42: {
                    block45: {
                        block46: {
                            if (s == null) {
                                return null;
                            }
                            if ((s = s.toLowerCase().trim()).startsWith("today ") || s.startsWith("y-day ")) {
                                try {
                                    GregorianCalendar calendar3 = new GregorianCalendar();
                                    ((Calendar)calendar3).setTimeZone(this.timeZone);
                                    String time = s.substring(6);
                                    StringTokenizer st2 = new StringTokenizer(time, ":");
                                    int hours = Integer.parseInt(st2.nextToken());
                                    int minutes = Integer.parseInt(st2.nextToken());
                                    calendar3.set(11, hours);
                                    calendar3.set(12, minutes);
                                    if (s.startsWith("y-day ")) {
                                        ((Calendar)calendar3).add(5, -1);
                                    }
                                    return calendar3.getTime();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    return null;
                                }
                            }
                            if (s.length() <= 3) break block43;
                            thirdCharacter = s.substring(2, 3);
                            if (!thirdCharacter.equals("-")) break block45;
                            if (s.length() <= 9) break block46;
                            String ninthCharacter = s.substring(8, 9);
                            if (ninthCharacter.equals(":")) {
                                try {
                                    int month = Integer.parseInt(s.substring(0, 2));
                                    int day = Integer.parseInt(s.substring(3, 5));
                                    int hours = Integer.parseInt(s.substring(6, 8));
                                    int minutes = Integer.parseInt(s.substring(9, 11));
                                    GregorianCalendar calendar4 = new GregorianCalendar();
                                    ((Calendar)calendar4).setTimeZone(this.timeZone);
                                    calendar4.set(2, month - 1);
                                    calendar4.set(5, day);
                                    calendar4.set(11, hours);
                                    calendar4.set(12, minutes);
                                    return calendar4.getTime();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break block42;
                            } else {
                                try {
                                    return this.MMddyyyyFormat.parse(s);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    break block42;
                                }
                            }
                        }
                        try {
                            int month = Integer.parseInt(s.substring(0, 2));
                            int day = Integer.parseInt(s.substring(3, 5));
                            GregorianCalendar calendar5 = new GregorianCalendar();
                            ((Calendar)calendar5).setTimeZone(this.timeZone);
                            calendar5.set(2, month);
                            calendar5.set(5, day);
                            return calendar5.getTime();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block42;
                    }
                    if (s.length() == 9 && s.indexOf(" ") != -1) {
                        try {
                            return this.ddMMMyyFormat.parse(s);
                        }
                        catch (Exception e) {
                            if (!DEBUG) break block42;
                            e.printStackTrace();
                        }
                    }
                }
                if (thirdCharacter.equals(" ")) {
                    try {
                        return this.ddMMMyyyyFormat.parse(s);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block43;
                        e.printStackTrace();
                    }
                }
            }
            if ((s.endsWith(" ago") || s.indexOf("month") != -1 || s.indexOf("hour") != -1 || s.indexOf("day") != -1 || s.indexOf("week") != -1 || s.indexOf("year") != -1) && (st = new StringTokenizer(s = s.replaceAll(" ago", ""), " ")).countTokens() >= 2) {
                try {
                    calendar2 = new GregorianCalendar();
                    while (true) {
                        if (!st.hasMoreTokens()) {
                            return calendar2.getTime();
                        }
                        float value = Float.parseFloat(st.nextToken());
                        String unit = st.nextToken();
                        ((Calendar)calendar2).setTimeZone(this.timeZone);
                        if (unit.startsWith("min")) {
                            ((Calendar)calendar2).add(12, -((int)value));
                        }
                        if (unit.startsWith("hour")) {
                            ((Calendar)calendar2).add(11, -((int)value));
                        }
                        if (unit.startsWith("day")) {
                            ((Calendar)calendar2).add(5, -((int)value));
                        }
                        if (unit.startsWith("week")) {
                            ((Calendar)calendar2).add(3, -((int)value));
                        }
                        if (unit.startsWith("month")) {
                            ((Calendar)calendar2).add(2, -((int)value));
                        }
                        if (!unit.startsWith("year")) continue;
                        ((Calendar)calendar2).add(1, -((int)value));
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block44;
                    e.printStackTrace();
                }
            }
        }
        if (s.equals("today")) {
            calendar = new GregorianCalendar();
            ((Calendar)calendar).setTimeZone(this.timeZone);
            return calendar.getTime();
        }
        if (s.equals("yesterday")) {
            calendar = new GregorianCalendar();
            ((Calendar)calendar).setTimeZone(this.timeZone);
            ((Calendar)calendar).add(5, -1);
            return calendar.getTime();
        }
        try {
            st = new StringTokenizer(s, " ");
            calendar2 = new GregorianCalendar();
            ((Calendar)calendar2).setTimeZone(this.timeZone);
            while (true) {
                if (!st.hasMoreTokens()) {
                    return calendar2.getTime();
                }
                String element = st.nextToken();
                int field = -1;
                int end_offset = -1;
                if (element.endsWith("h")) {
                    field = 11;
                    end_offset = 1;
                }
                if (element.endsWith("d")) {
                    field = 5;
                    end_offset = 1;
                }
                if (element.endsWith("w")) {
                    field = 3;
                    end_offset = 1;
                }
                if (element.endsWith("m")) {
                    field = 2;
                    end_offset = 1;
                }
                if (element.endsWith("mon")) {
                    field = 2;
                    end_offset = 3;
                }
                if (element.endsWith("y")) {
                    field = 1;
                    end_offset = 1;
                }
                if (field == -1 || end_offset == -1) continue;
                int value = (int)Float.parseFloat(element.substring(0, element.length() - end_offset));
                ((Calendar)calendar2).add(field, -value);
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static void main(String[] args) {
        DEBUG = true;
        DateParserClassic dateParser = new DateParserClassic();
        dateParser.parseDate("Today 05:34");
        dateParser.parseDate("Y-Day 21:55");
        dateParser.parseDate("07-25 2006");
        dateParser.parseDate("02-01 02:53");
        dateParser.parseDate("03 Mar 2006");
        dateParser.parseDate("0 minute ago");
        dateParser.parseDate("3 hours ago");
        dateParser.parseDate("2 days ago");
        dateParser.parseDate("10 months ago");
        dateParser.parseDate("45 mins ago");
        dateParser.parseDate("Today");
        dateParser.parseDate("Yesterday");
        dateParser.parseDate("16.9w");
        dateParser.parseDate("22.6h");
        dateParser.parseDate("1.7d");
        dateParser.parseDate("2d 7h");
        dateParser.parseDate("1w");
        dateParser.parseDate("1w 4d");
        dateParser.parseDate("1mon 1w");
    }
}

