/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;

public class PlatformTorrentMessenger {
    public static String LISTENER_ID = "torrent";
    public static String OP_STREAMCOMPLETE = "stream-complete";

    public static void streamComplete(TOTorrent torrent, long waitTime, int maxSeekAheadSecs, int numRebuffers, int numHardRebuffers) {
        String hash = null;
        try {
            hash = torrent.getHashWrapper().toBase32String();
        }
        catch (TOTorrentException e) {
            // empty catch block
        }
        if (hash == null) {
            return;
        }
        HashMap<String, Object> mapParameters = new HashMap<String, Object>();
        mapParameters.put("torrent-hash", hash);
        mapParameters.put("wait-time", new Long(waitTime));
        mapParameters.put("max-seek", new Long(maxSeekAheadSecs));
        mapParameters.put("num-rebuffers", new Long(numRebuffers));
        mapParameters.put("num-hard-rebuffers", new Long(numHardRebuffers));
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_STREAMCOMPLETE, mapParameters, 3000L);
        message.setContentNetworkID(PlatformTorrentUtils.getContentNetworkID(torrent));
        PlatformMessenger.queueMessage(message, null);
    }

    public static void streamComplete(TOTorrent torrent, Map info) {
        String hash = null;
        try {
            hash = torrent.getHashWrapper().toBase32String();
        }
        catch (TOTorrentException e) {
            // empty catch block
        }
        if (hash == null) {
            return;
        }
        HashMap<String, String> mapParameters = new HashMap<String, String>(info);
        mapParameters.put("torrent-hash", hash);
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_STREAMCOMPLETE, mapParameters, 3000L);
        message.setContentNetworkID(PlatformTorrentUtils.getContentNetworkID(torrent));
        PlatformMessenger.queueMessage(message, null);
    }
}

