/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LWSDiskManager;
import com.aelitis.azureus.core.lws.LWSDownload;
import com.aelitis.azureus.core.lws.LWSPeerManagerAdapter;
import com.aelitis.azureus.core.lws.LWSTorrent;
import com.aelitis.azureus.core.lws.LightWeightSeedAdapter;
import com.aelitis.azureus.core.lws.LightWeightSeedManager;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistrationAdapter;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URL;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class LightWeightSeed
extends LogRelation
implements PeerManagerRegistrationAdapter {
    private static final byte ACT_NONE = 0;
    private static final byte ACT_HAS_PEERS = 2;
    private static final byte ACT_HAS_POTENTIAL_PEERS = 3;
    private static final byte ACT_INCOMING = 4;
    private static final byte ACT_NO_PM = 5;
    private static final byte ACT_TIMING_OUT = 6;
    private static final byte ACT_TRACKER_ANNOUNCE = 7;
    private static final byte ACT_TRACKER_SCRAPE = 8;
    private static final int DEACTIVATION_TIMEOUT = 300000;
    private static final int DEACTIVATION_WITH_POTENTIAL_TIMEOUT = 900000;
    private LightWeightSeedManager manager;
    private LightWeightSeedAdapter adapter;
    private String name;
    private HashWrapper hash;
    private URL announce_url;
    private File data_location;
    private PeerManagerRegistration peer_manager_registration;
    private PEPeerManager peer_manager;
    private LWSDiskManager disk_manager;
    private LWSDownload pseudo_download;
    private LWSTorrent torrent_facade;
    private TRTrackerAnnouncer announcer;
    private TOTorrent actual_torrent;
    private boolean is_running;
    private long last_activity_time;
    private int activation_state = 0;

    protected LightWeightSeed(LightWeightSeedManager _manager, String _name, HashWrapper _hash, URL _announce_url, File _data_location, LightWeightSeedAdapter _adapter) {
        this.manager = _manager;
        this.name = _name;
        this.hash = _hash;
        this.announce_url = _announce_url;
        this.data_location = _data_location;
        this.adapter = _adapter;
    }

    protected String getName() {
        return this.name + "/" + ByteFormatter.encodeString(this.hash.getBytes());
    }

    protected Torrent getTorrent() {
        return new TorrentImpl(this.getTOTorrent(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TOTorrent getTOTorrent(boolean actual) {
        if (actual) {
            LightWeightSeed lightWeightSeed = this;
            synchronized (lightWeightSeed) {
                if (this.actual_torrent == null) {
                    try {
                        this.actual_torrent = this.adapter.getTorrent(this.hash.getBytes(), this.announce_url, this.data_location);
                    }
                    catch (Throwable e) {
                        this.log("Failed to get torrent", e);
                    }
                    if (this.actual_torrent == null) {
                        throw new RuntimeException("Torrent not available");
                    }
                }
                return this.actual_torrent;
            }
        }
        return this.torrent_facade;
    }

    public HashWrapper getHash() {
        return this.hash;
    }

    public URL getAnnounceURL() {
        return this.announce_url;
    }

    public File getDataLocation() {
        return this.data_location;
    }

    protected long getSize() {
        return this.data_location.length();
    }

    public boolean isPeerSourceEnabled(String peer_source) {
        return true;
    }

    public boolean manualRoute(NetworkConnection connection) {
        return false;
    }

    public byte[][] getSecrets() {
        return new byte[][]{this.hash.getBytes()};
    }

    public boolean activateRequest(InetSocketAddress remote_address) {
        this.ensureActive("Incoming[" + remote_address.getAddress().getHostAddress() + "]", (byte)4);
        return true;
    }

    public void deactivateRequest(InetSocketAddress remote_address) {
    }

    public String getDescription() {
        return "LWS: " + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void start() {
        this.log("Start");
        if (this.is_running) {
            this.log("Start of '" + this.getString() + "' failed - already running");
            return;
        }
        if (this.peer_manager_registration != null) {
            this.log("Start of '" + this.getString() + "' failed - router already registered");
            return;
        }
        if (this.pseudo_download != null) {
            this.log("Start of '" + this.getString() + "' failed - pseudo download already registered");
            return;
        }
        if (this.disk_manager != null) {
            this.log("Start of '" + this.getString() + "' failed - disk manager already started");
            return;
        }
        if (this.peer_manager != null) {
            this.log("Start of '" + this.getString() + "' failed - peer manager already started");
            return;
        }
        try {
            try {
                if (this.torrent_facade == null) {
                    this.torrent_facade = new LWSTorrent(this);
                }
                this.peer_manager_registration = PeerManager.getSingleton().registerLegacyManager(this.hash, this);
                this.announcer = this.createAnnouncer();
                this.pseudo_download = new LWSDownload(this, this.announcer);
                this.manager.addToDHTTracker(this.pseudo_download);
                this.is_running = true;
                this.last_activity_time = SystemTime.getMonotonousTime();
            }
            catch (Throwable e) {
                this.log("Start of '" + this.getString() + "' failed", e);
                Object var3_2 = null;
                if (this.is_running) {
                    this.log("Started " + this.getString());
                } else {
                    this.stop();
                }
            }
            Object var3_1 = null;
            if (this.is_running) {
                this.log("Started " + this.getString());
            } else {
                this.stop();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.is_running) {
                this.log("Started " + this.getString());
            } else {
                this.stop();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void stop() {
        this.log("Stop");
        try {
            if (this.disk_manager != null) {
                this.disk_manager.stop(false);
                this.disk_manager = null;
            }
            if (this.peer_manager != null) {
                this.peer_manager.stopAll();
                this.peer_manager = null;
            }
            if (this.pseudo_download != null) {
                this.manager.removeFromDHTTracker(this.pseudo_download);
                this.pseudo_download = null;
            }
            if (this.announcer != null) {
                this.announcer.stop(false);
                this.announcer.destroy();
                this.announcer = null;
            }
            if (this.peer_manager_registration != null) {
                this.peer_manager_registration.unregister();
                this.peer_manager_registration = null;
            }
            Object var2_1 = null;
            this.is_running = false;
            this.activation_state = 0;
            this.log("Stopped " + this.getString());
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.is_running = false;
            this.activation_state = 0;
            this.log("Stopped " + this.getString());
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void activate(String reason_str, byte activation_reason) {
        this.log("Activate: " + activation_reason + "/" + reason_str);
        if (this.activation_state != 0) {
            return;
        }
        try {
            block9: {
                try {
                    this.disk_manager = new LWSDiskManager(this, this.data_location);
                    this.disk_manager.start();
                    if (this.disk_manager.getState() != 4) {
                        this.log("Start of '" + this.getString() + "' failed, disk manager failed = " + this.disk_manager.getErrorMessage());
                        break block9;
                    }
                    this.peer_manager = PEPeerManagerFactory.create(this.announcer.getPeerId(), new LWSPeerManagerAdapter(this, this.peer_manager_registration), this.disk_manager);
                    this.peer_manager.addListener(new PEPeerManagerListener(){

                        public void peerAdded(PEPeerManager manager, PEPeer peer) {
                            LightWeightSeed.this.last_activity_time = SystemTime.getMonotonousTime();
                        }

                        public void peerRemoved(PEPeerManager manager, PEPeer peer) {
                            LightWeightSeed.this.last_activity_time = SystemTime.getMonotonousTime();
                        }

                        public void peerDiscovered(PEPeerManager manager, PeerItem peer, PEPeer finder) {
                        }

                        public void pieceAdded(PEPeerManager manager, PEPiece peice, PEPeer for_peer) {
                        }

                        public void pieceRemoved(PEPeerManager manager, PEPiece peice) {
                        }

                        public void peerSentBadData(PEPeerManager manager, PEPeer peer, int pieceNumber) {
                        }

                        public void destroyed() {
                        }
                    });
                    this.peer_manager.start();
                    this.announcer.update(true);
                    this.activation_state = activation_reason;
                    this.last_activity_time = SystemTime.getMonotonousTime();
                }
                catch (Throwable e) {
                    this.log("Activation of '" + this.getString() + "' failed", e);
                    Object var5_4 = null;
                    if (this.activation_state == 0) {
                        this.deactivate();
                    }
                }
            }
            Object var5_3 = null;
            if (this.activation_state == 0) {
                this.deactivate();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.activation_state == 0) {
                this.deactivate();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deactivate() {
        this.log("Deactivate");
        try {
            if (this.disk_manager != null) {
                this.disk_manager.stop(false);
                this.disk_manager = null;
            }
            if (this.peer_manager != null) {
                this.peer_manager.stopAll();
                this.peer_manager = null;
            }
            Object var2_1 = null;
            this.activation_state = 0;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.activation_state = 0;
            throw throwable;
        }
    }

    protected synchronized TRTrackerAnnouncer createAnnouncer() throws TRTrackerAnnouncerException {
        TRTrackerAnnouncer result = TRTrackerAnnouncerFactory.create((TOTorrent)this.torrent_facade, true);
        result.addListener(new TRTrackerAnnouncerListener(){

            public void receivedTrackerResponse(TRTrackerAnnouncerResponse response) {
                TRTrackerAnnouncerResponsePeer[] peers = response.getPeers();
                if (peers != null && peers.length > 0) {
                    LightWeightSeed.this.ensureActive("Tracker[" + peers[0].getAddress() + "]", (byte)7);
                } else if (response.getScrapeIncompleteCount() > 0) {
                    LightWeightSeed.this.ensureActive("Tracker[scrape]", (byte)8);
                }
                PEPeerManager pm = LightWeightSeed.this.peer_manager;
                if (pm != null) {
                    pm.processTrackerResponse(response);
                }
            }

            public void urlChanged(TRTrackerAnnouncer announcer, URL old_url, URL new_url, boolean explicit) {
            }

            public void urlRefresh() {
            }
        });
        result.setAnnounceDataProvider(new TRTrackerAnnouncerDataProvider(){

            public String getName() {
                return LightWeightSeed.this.getName();
            }

            public long getTotalSent() {
                return 0L;
            }

            public long getTotalReceived() {
                return 0L;
            }

            public long getFailedHashCheck() {
                return 0L;
            }

            public long getRemaining() {
                return 0L;
            }

            public String getExtensions() {
                return null;
            }

            public int getMaxNewConnectionsAllowed() {
                PEPeerManager pm = LightWeightSeed.this.peer_manager;
                if (pm == null) {
                    return 8;
                }
                return PeerUtils.numNewConnectionsAllowed(pm.getPeerIdentityDataID(), 0);
            }

            public int getPendingConnectionCount() {
                PEPeerManager pm = LightWeightSeed.this.peer_manager;
                if (pm == null) {
                    return 0;
                }
                return pm.getPendingPeerCount();
            }

            public int getConnectedConnectionCount() {
                PEPeerManager pm = LightWeightSeed.this.peer_manager;
                if (pm == null) {
                    return 0;
                }
                return pm.getNbPeers() + pm.getNbSeeds();
            }

            public int getUploadSpeedKBSec(boolean estimate) {
                return 0;
            }

            public int getCryptoLevel() {
                return 0;
            }

            public boolean isPeerSourceEnabled(String peer_source) {
                return true;
            }

            public void setPeerSources(String[] sources) {
            }
        });
        return result;
    }

    protected synchronized void ensureActive(String reason, byte a_reason) {
        if (this.is_running && this.activation_state == 0) {
            this.activate(reason, a_reason);
        }
    }

    protected synchronized void checkDeactivation() {
        if (this.activation_state == 0) {
            return;
        }
        if (this.peer_manager == null) {
            this.activation_state = 5;
            return;
        }
        if (this.peer_manager.getNbPeers() > 0) {
            this.activation_state = 2;
            return;
        }
        long now = SystemTime.getMonotonousTime();
        long millis_since_last_act = now - this.last_activity_time;
        if (this.peer_manager.hasPotentialConnections() && millis_since_last_act < 900000L) {
            this.activation_state = 3;
            return;
        }
        if (millis_since_last_act >= 300000L) {
            this.deactivate();
        } else {
            this.activation_state = 6;
        }
    }

    public void enqueueReadRequest(PEPeer peer, DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        LWSDiskManager dm = this.disk_manager;
        if (dm == null) {
            listener.readFailed(request2, new Throwable("download is stopped"));
        } else {
            dm.enqueueReadRequest(request2, listener);
        }
    }

    public void remove() {
        this.manager.remove(this);
    }

    public String getRelationText() {
        return "LWS: '" + this.getName() + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[0];
    }

    public LogRelation getRelation() {
        return this;
    }

    protected String getString() {
        return this.getName();
    }

    protected void log(String str) {
        Logger.log(new LogEvent(this, LogIDs.CORE, str));
    }

    protected void log(String str, Throwable e) {
        Logger.log(new LogEvent((Object)this, LogIDs.CORE, str, e));
    }
}

