/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.drivedetector.impl;

import com.aelitis.azureus.core.drivedetector.DriveDetectedInfo;
import com.aelitis.azureus.core.drivedetector.DriveDetectedListener;
import com.aelitis.azureus.core.drivedetector.DriveDetector;
import com.aelitis.azureus.core.drivedetector.impl.DriveDetectedInfoImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class DriveDetectorImpl
implements DriveDetector,
AEDiagnosticsEvidenceGenerator {
    private AEMonitor2 mon_driveDetector = new AEMonitor2("driveDetector");
    private CopyOnWriteList<DriveDetectedListener> listListeners = new CopyOnWriteList(1);
    private Map<File, Map> mapDrives = new HashMap<File, Map>(1);

    public DriveDetectorImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriveDetectedInfo[] getDetectedDriveInfo() {
        this.mon_driveDetector.enter();
        try {
            int i = 0;
            DriveDetectedInfo[] ddi = new DriveDetectedInfo[this.mapDrives.size()];
            for (File key : this.mapDrives.keySet()) {
                ddi[i++] = new DriveDetectedInfoImpl(key, this.mapDrives.get(key));
            }
            DriveDetectedInfo[] driveDetectedInfoArray = ddi;
            Object var6_5 = null;
            this.mon_driveDetector.exit();
            return driveDetectedInfoArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mon_driveDetector.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DriveDetectedListener l) {
        this.mon_driveDetector.enter();
        try {
            if (this.listListeners.contains(l)) {
                Object var6_2 = null;
                this.mon_driveDetector.exit();
                return;
            }
            this.listListeners.add(l);
            for (File key : this.mapDrives.keySet()) {
                try {
                    l.driveDetected(new DriveDetectedInfoImpl(key, this.mapDrives.get(key)));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.mon_driveDetector.exit();
            throw throwable;
        }
        Object var6_3 = null;
        this.mon_driveDetector.exit();
    }

    public void removeListener(DriveDetectedListener l) {
        this.listListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void driveDetected(File location, Map info) {
        location = this.normaliseFile(location);
        this.mon_driveDetector.enter();
        try {
            if (this.mapDrives.containsKey(location)) {
                Object var4_3 = null;
                this.mon_driveDetector.exit();
                return;
            }
            info.put("File", location);
            this.mapDrives.put(location, info);
            Object var4_4 = null;
            this.mon_driveDetector.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.mon_driveDetector.exit();
            throw throwable;
        }
        for (DriveDetectedListener l : this.listListeners) {
            try {
                l.driveDetected(new DriveDetectedInfoImpl(location, info));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void driveRemoved(File location) {
        Map map;
        location = this.normaliseFile(location);
        this.mon_driveDetector.enter();
        try {
            map = this.mapDrives.remove(location);
            if (map == null) {
                Object var4_3 = null;
                this.mon_driveDetector.exit();
                return;
            }
            Object var4_4 = null;
            this.mon_driveDetector.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.mon_driveDetector.exit();
            throw throwable;
        }
        for (DriveDetectedListener l : this.listListeners) {
            try {
                l.driveRemoved(new DriveDetectedInfoImpl(location, map));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected File normaliseFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Throwable e) {
            Debug.out(e);
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        Map<File, Map> map = this.mapDrives;
        synchronized (map) {
            writer.println("DriveDetector: " + this.mapDrives.size() + " drives");
            for (File file : this.mapDrives.keySet()) {
                Object var12_11;
                try {
                    try {
                        Object var10_10;
                        writer.indent();
                        writer.println(file.getPath());
                        try {
                            writer.indent();
                            Map driveInfo = this.mapDrives.get(file);
                            for (Object key : driveInfo.keySet()) {
                                Object val = driveInfo.get(key);
                                writer.println(key + ": " + val);
                            }
                            var10_10 = null;
                            writer.exdent();
                        }
                        catch (Throwable throwable) {
                            var10_10 = null;
                            writer.exdent();
                            throw throwable;
                        }
                        var12_11 = null;
                        writer.exdent();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        var12_11 = null;
                        writer.exdent();
                    }
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    writer.exdent();
                    throw throwable;
                }
            }
        }
    }
}

