/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.QTFastStartRAF;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerFileInfoDelegate
implements DiskManagerFileInfo {
    private DiskManagerFileInfo delegate;
    private byte[] hash;

    public DiskManagerFileInfoDelegate(DiskManagerFileInfo _delegate) throws DownloadException {
        this.delegate = _delegate;
        if (this.delegate.getDownload() == null) {
            throw new DownloadException("Not supported");
        }
        byte[] delegate_hash = this.delegate.getDownloadHash();
        this.hash = (byte[])delegate_hash.clone();
        this.hash[0] = (byte)(this.hash[0] ^ 1);
    }

    public void setPriority(boolean b) {
        this.delegate.setPriority(b);
    }

    public int getNumericPriorty() {
        return this.delegate.getNumericPriorty();
    }

    public void setNumericPriority(int priority) {
        this.delegate.setNumericPriority(priority);
    }

    public void setSkipped(boolean b) {
        this.delegate.setSkipped(b);
    }

    public void setDeleted(boolean b) {
        this.delegate.setDeleted(b);
    }

    public void setLink(File link_destination) {
        this.delegate.setLink(link_destination);
    }

    public File getLink() {
        return this.delegate.getLink();
    }

    public int getAccessMode() {
        return this.delegate.getAccessMode();
    }

    public long getDownloaded() {
        return this.delegate.getDownloaded();
    }

    public long getLength() {
        return this.delegate.getLength();
    }

    public File getFile() {
        return this.delegate.getFile();
    }

    public File getFile(boolean follow_link) {
        return this.delegate.getFile(follow_link);
    }

    public int getIndex() {
        return this.delegate.getIndex();
    }

    public int getFirstPieceNumber() {
        return this.delegate.getFirstPieceNumber();
    }

    public long getPieceSize() {
        return this.delegate.getPieceSize();
    }

    public int getNumPieces() {
        return this.delegate.getNumPieces();
    }

    public boolean isPriority() {
        return this.delegate.isPriority();
    }

    public boolean isSkipped() {
        return this.delegate.isSkipped();
    }

    public boolean isDeleted() {
        return this.delegate.isDeleted();
    }

    public byte[] getDownloadHash() {
        return this.hash;
    }

    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    public DiskManagerChannel createChannel() throws DownloadException {
        return new channel();
    }

    private class channel
    implements DiskManagerChannel {
        private DiskManagerChannel delegate_channel;
        private volatile boolean channel_destroyed;
        private volatile long channel_position;

        private channel() throws DownloadException {
            this.delegate_channel = DiskManagerFileInfoDelegate.this.delegate.createChannel();
        }

        public DiskManagerRequest createRequest() {
            return new request();
        }

        public DiskManagerFileInfo getFile() {
            return DiskManagerFileInfoDelegate.this;
        }

        public long getPosition() {
            return this.delegate_channel.getPosition();
        }

        public boolean isDestroyed() {
            return this.delegate_channel.isDestroyed();
        }

        public void destroy() {
            this.delegate_channel.destroy();
        }

        private QTFastStartRAF.FileAccessor getAccessor(final int max_req_size, final String user_agent) {
            return new QTFastStartRAF.FileAccessor(){
                private long seek_position;
                private DiskManagerRequest current_request;
                private volatile boolean closed;

                public String getName() {
                    try {
                        return DiskManagerFileInfoDelegate.this.delegate.getDownload().getName() + "/" + DiskManagerFileInfoDelegate.this.delegate.getFile().getName();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        return DiskManagerFileInfoDelegate.this.delegate.getFile().getAbsolutePath();
                    }
                }

                public long getFilePointer() throws IOException {
                    return this.seek_position;
                }

                public void seek(long pos) throws IOException {
                    this.seek_position = pos;
                }

                public void skipBytes(int num) throws IOException {
                    this.seek_position += (long)num;
                }

                public long length() throws IOException {
                    return DiskManagerFileInfoDelegate.this.getLength();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int read(final byte[] buffer, final int pos, final int len) throws IOException {
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.closed) {
                            throw new IOException("closed");
                        }
                        this.current_request = channel.this.delegate_channel.createRequest();
                    }
                    this.current_request.setType(1);
                    this.current_request.setOffset(this.seek_position);
                    this.current_request.setLength(len);
                    this.current_request.setMaximumReadChunkSize(max_req_size);
                    if (user_agent != null) {
                        this.current_request.setUserAgent(user_agent);
                    }
                    final AESemaphore sem = new AESemaphore("waiter");
                    final Throwable[] error = new Throwable[]{null};
                    this.current_request.addListener(new DiskManagerListener(){
                        private int write_pos;
                        private int rem;
                        {
                            this.write_pos = pos;
                            this.rem = len;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void eventOccurred(DiskManagerEvent event2) {
                            int type = event2.getType();
                            if (type == 1) {
                                PooledByteBuffer p_buffer = event2.getBuffer();
                                try {
                                    ByteBuffer bb = p_buffer.toByteBuffer();
                                    bb.position(0);
                                    int read = bb.remaining();
                                    bb.get(buffer, this.write_pos, read);
                                    this.write_pos += read;
                                    this.rem -= read;
                                    if (this.rem == 0) {
                                        sem.release();
                                    }
                                    Object var7_6 = null;
                                    p_buffer.returnToPool();
                                }
                                catch (Throwable throwable) {
                                    Object var7_7 = null;
                                    p_buffer.returnToPool();
                                    throw throwable;
                                }
                            } else if (type == 2) {
                                error[0] = event2.getFailure();
                                sem.release();
                            }
                        }
                    });
                    this.current_request.run();
                    do {
                        if (!sem.reserve(1000L)) continue;
                        if (error[0] != null) {
                            throw new IOException(Debug.getNestedExceptionMessage(error[0]));
                        }
                        this.seek_position += (long)len;
                        return len;
                    } while (!this.closed);
                    throw new IOException("Closed");
                }

                public int readInt() throws IOException {
                    byte[] readBuffer = new byte[4];
                    this.readFully(readBuffer);
                    return (readBuffer[0] << 24) + ((readBuffer[1] & 0xFF) << 16) + ((readBuffer[2] & 0xFF) << 8) + ((readBuffer[3] & 0xFF) << 0);
                }

                public long readLong() throws IOException {
                    byte[] readBuffer = new byte[8];
                    this.readFully(readBuffer);
                    return ((long)readBuffer[0] << 56) + ((long)(readBuffer[1] & 0xFF) << 48) + ((long)(readBuffer[2] & 0xFF) << 40) + ((long)(readBuffer[3] & 0xFF) << 32) + ((long)(readBuffer[4] & 0xFF) << 24) + (long)((readBuffer[5] & 0xFF) << 16) + (long)((readBuffer[6] & 0xFF) << 8) + (long)((readBuffer[7] & 0xFF) << 0);
                }

                public void readFully(byte[] buffer) throws IOException {
                    this.read(buffer, 0, buffer.length);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.closed = true;
                        if (this.current_request != null) {
                            this.current_request.cancel();
                        }
                    }
                }
            };
        }

        protected class request
        implements DiskManagerRequest {
            private DiskManagerRequest delegate_request;
            private volatile boolean using_delegate;
            private long offset;
            private long length;
            private volatile long position;
            private String user_agent;
            private int max_read_chunk = 131072;
            private volatile boolean cancelled;
            private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

            private request() {
                this.delegate_request = channel.this.delegate_channel.createRequest();
            }

            public void setType(int type) {
                if (type != 1) {
                    throw new RuntimeException("Not supported");
                }
                this.delegate_request.setType(type);
            }

            public void setOffset(long _offset) {
                this.offset = _offset;
                this.delegate_request.setOffset(this.offset);
            }

            public void setLength(long _length) {
                if (_length < 0L) {
                    throw new RuntimeException("Illegal argument");
                }
                this.length = _length;
                this.delegate_request.setLength(this.length);
            }

            public void setMaximumReadChunkSize(int size) {
                this.max_read_chunk = size;
                this.delegate_request.setMaximumReadChunkSize(size);
            }

            public void setUserAgent(String agent) {
                this.user_agent = agent;
                this.delegate_request.setUserAgent(agent);
            }

            public long getAvailableBytes() {
                if (this.using_delegate) {
                    return this.delegate_request.getAvailableBytes();
                }
                return this.getRemaining();
            }

            public long getRemaining() {
                if (this.using_delegate) {
                    return this.delegate_request.getRemaining();
                }
                return this.offset + this.length - this.position;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                boolean for_stream;
                boolean bl = for_stream = this.user_agent != null;
                if (for_stream) {
                    File file = DiskManagerFileInfoDelegate.this.delegate.getFile();
                    String name = file.getName();
                    int dot_pos = name.lastIndexOf(46);
                    String ext = dot_pos < 0 ? "" : name.substring(dot_pos + 1);
                    for_stream = QTFastStartRAF.isSupportedExtension(ext);
                }
                if (for_stream) {
                    QTFastStartRAF raf = null;
                    raf = new QTFastStartRAF(channel.this.getAccessor(this.max_read_chunk, this.user_agent), true);
                    raf.seek(this.offset);
                    byte[] buffer = new byte[this.max_read_chunk];
                    long rem = this.length;
                    long pos = this.offset;
                    while (rem > 0L) {
                        if (this.cancelled) {
                            throw new Exception("Cancelled");
                        }
                        if (channel.this.channel_destroyed) {
                            throw new Exception("Destroyed");
                        }
                        int chunk = (int)Math.min(rem, (long)this.max_read_chunk);
                        int len = raf.read(buffer, 0, chunk);
                        this.sendEvent(new event(new PooledByteBufferImpl(buffer, 0, len), pos, len));
                        rem -= (long)len;
                        pos += (long)len;
                        this.position += (long)len;
                    }
                    Object var11_11 = null;
                    if (raf == null) return;
                    try {
                        raf.close();
                        return;
                    }
                    catch (Throwable e2) {
                        Debug.out(e2);
                    }
                    return;
                    {
                        catch (Throwable e) {
                            this.sendEvent(new event(e));
                            Object var11_12 = null;
                            if (raf == null) return;
                            try {
                                raf.close();
                                return;
                            }
                            catch (Throwable e2) {
                                Debug.out(e2);
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (raf == null) throw throwable;
                        try {
                            raf.close();
                            throw throwable;
                        }
                        catch (Throwable e2) {
                            Debug.out(e2);
                        }
                        throw throwable;
                    }
                }
                this.using_delegate = true;
                this.delegate_request.addListener(new DiskManagerListener(){

                    public void eventOccurred(DiskManagerEvent event2) {
                        request.this.sendEvent(event2);
                    }
                });
                this.delegate_request.run();
            }

            public void cancel() {
                this.cancelled = true;
                this.delegate_request.cancel();
            }

            protected void sendEvent(DiskManagerEvent ev) {
                for (DiskManagerListener l : this.listeners) {
                    l.eventOccurred(ev);
                }
            }

            public void addListener(DiskManagerListener listener) {
                this.listeners.add(listener);
            }

            public void removeListener(DiskManagerListener listener) {
                this.listeners.remove(listener);
            }

            protected class event
            implements DiskManagerEvent {
                private int event_type;
                private Throwable error;
                private PooledByteBuffer buffer;
                private long event_offset;
                private int event_length;

                protected event(Throwable _error) {
                    this.event_type = 2;
                    this.error = _error;
                }

                protected event(PooledByteBuffer _buffer, long _offset, int _length) {
                    this.event_type = 1;
                    this.buffer = _buffer;
                    this.event_offset = _offset;
                    this.event_length = _length;
                    channel.this.channel_position = _offset + (long)_length - 1L;
                }

                public int getType() {
                    return this.event_type;
                }

                public DiskManagerRequest getRequest() {
                    return request.this;
                }

                public long getOffset() {
                    return this.event_offset;
                }

                public int getLength() {
                    return this.event_length;
                }

                public PooledByteBuffer getBuffer() {
                    return this.buffer;
                }

                public Throwable getFailure() {
                    return this.error;
                }
            }
        }
    }
}

