/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl.packethandler;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerException;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerFactory;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketReceiver;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPRequestHandler;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerRequest;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTUDPPacketHandler {
    private DHTUDPPacketHandlerFactory factory;
    private int network;
    private PRUDPPacketHandler packet_handler;
    private DHTUDPRequestHandler request_handler;
    private DHTUDPPacketHandlerStats stats;
    private boolean test_network_alive = true;
    private int BLOOM_FILTER_SIZE = 10000;
    private static final int BLOOM_ROTATION_PERIOD = 180000;
    private BloomFilter bloom1;
    private BloomFilter bloom2;
    private long last_bloom_rotation_time;

    protected DHTUDPPacketHandler(DHTUDPPacketHandlerFactory _factory, int _network, PRUDPPacketHandler _packet_handler, DHTUDPRequestHandler _request_handler) {
        this.factory = _factory;
        this.network = _network;
        this.packet_handler = _packet_handler;
        this.request_handler = _request_handler;
        this.bloom1 = BloomFilterFactory.createAddOnly(this.BLOOM_FILTER_SIZE);
        this.bloom2 = BloomFilterFactory.createAddOnly(this.BLOOM_FILTER_SIZE);
        this.stats = new DHTUDPPacketHandlerStats(this.packet_handler);
    }

    public void testNetworkAlive(boolean alive) {
        this.test_network_alive = alive;
    }

    protected DHTUDPRequestHandler getRequestHandler() {
        return this.request_handler;
    }

    protected PRUDPPacketHandler getPacketHandler() {
        return this.packet_handler;
    }

    protected int getNetwork() {
        return this.network;
    }

    protected void updateBloom(InetSocketAddress destination_address) {
        long diff = SystemTime.getCurrentTime() - this.last_bloom_rotation_time;
        if (diff < 0L || diff > 180000L) {
            this.bloom1 = this.bloom2;
            this.bloom2 = BloomFilterFactory.createAddOnly(this.BLOOM_FILTER_SIZE);
            this.last_bloom_rotation_time = SystemTime.getCurrentTime();
        }
        byte[] address_bytes = destination_address.getAddress().getAddress();
        this.bloom1.add(address_bytes);
        this.bloom2.add(address_bytes);
    }

    public void sendAndReceive(DHTUDPPacketRequest request2, InetSocketAddress destination_address, final DHTUDPPacketReceiver receiver, long timeout, int priority) throws DHTUDPPacketHandlerException {
        destination_address = AddressUtils.adjustDHTAddress(destination_address, true);
        try {
            request2.setNetwork(this.network);
            if (this.test_network_alive) {
                this.updateBloom(destination_address);
                this.packet_handler.sendAndReceive(request2, destination_address, new PRUDPPacketReceiver(){

                    public void packetReceived(PRUDPPacketHandlerRequest request2, PRUDPPacket packet, InetSocketAddress from_address) {
                        DHTUDPPacketReply reply = (DHTUDPPacketReply)packet;
                        DHTUDPPacketHandler.this.stats.packetReceived(reply.getSerialisedSize());
                        if (reply.getNetwork() == DHTUDPPacketHandler.this.network) {
                            receiver.packetReceived(reply, from_address, request2.getElapsedTime());
                        } else {
                            Debug.out("Non-matching network reply received");
                            receiver.error(new DHTUDPPacketHandlerException(new Exception("Non-matching network reply received")));
                        }
                    }

                    public void error(PRUDPPacketHandlerException e) {
                        receiver.error(new DHTUDPPacketHandlerException(e));
                    }
                }, timeout, priority);
            } else {
                receiver.error(new DHTUDPPacketHandlerException(new Exception("Test network disabled")));
            }
        }
        catch (PRUDPPacketHandlerException e) {
            throw new DHTUDPPacketHandlerException(e);
        }
        finally {
            this.stats.packetSent(request2.getSerialisedSize());
        }
    }

    public void send(DHTUDPPacketRequest request2, InetSocketAddress destination_address) throws DHTUDPPacketHandlerException {
        destination_address = AddressUtils.adjustDHTAddress(destination_address, true);
        this.updateBloom(destination_address);
        try {
            request2.setNetwork(this.network);
            if (this.test_network_alive) {
                this.packet_handler.send(request2, destination_address);
            }
        }
        catch (PRUDPPacketHandlerException e) {
            throw new DHTUDPPacketHandlerException(e);
        }
        finally {
            this.stats.packetSent(request2.getSerialisedSize());
        }
    }

    public void send(DHTUDPPacketReply reply, InetSocketAddress destination_address) throws DHTUDPPacketHandlerException {
        destination_address = AddressUtils.adjustDHTAddress(destination_address, true);
        try {
            reply.setNetwork(this.network);
            if (this.test_network_alive) {
                this.packet_handler.send(reply, destination_address);
            }
        }
        catch (PRUDPPacketHandlerException e) {
            throw new DHTUDPPacketHandlerException(e);
        }
        finally {
            this.stats.packetSent(reply.getSerialisedSize());
        }
    }

    protected void receive(DHTUDPPacketRequest request2) {
        if (this.test_network_alive) {
            boolean alien;
            request2.setAddress(AddressUtils.adjustDHTAddress(request2.getAddress(), false));
            byte[] bloom_key = request2.getAddress().getAddress().getAddress();
            boolean bl = alien = !this.bloom1.contains(bloom_key);
            if (alien) {
                this.bloom1.add(bloom_key);
                this.bloom2.add(bloom_key);
            }
            this.stats.packetReceived(request2.getSerialisedSize());
            this.request_handler.process(request2, alien);
        }
    }

    public void setDelays(int send_delay, int receive_delay, int queued_request_timeout) {
        this.packet_handler.setDelays(send_delay, receive_delay, queued_request_timeout);
    }

    public void destroy() {
        this.factory.destroy(this);
    }

    public DHTUDPPacketHandlerStats getStats() {
        return this.stats;
    }
}

