/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl.tests;

import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.VivaldiPosition;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl.HeightCoordinatesImpl;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl.VivaldiPositionImpl;
import java.util.ArrayList;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.ui.swt.views.stats.VivaldiPanel;

public class VivaldiVisualTest {
    private static final int MAX_HEIGHT = 20;
    private static final int ELEMENTS_X = 20;
    private static final int ELEMENTS_Y = 20;
    private static final int DISTANCE = 50;
    private static final int MAX_ITERATIONS = 10000;
    private static final int NB_CONTACTS = 5;

    public VivaldiVisualTest() {
        final Display display = new Display();
        Shell shell = new Shell(display);
        final VivaldiPanel panel = new VivaldiPanel(shell);
        shell.setLayout(new FillLayout());
        shell.setSize(800, 800);
        shell.setText("Vivaldi Simulator");
        shell.open();
        Thread runner = new Thread("Viviladi Simulator"){

            public void run() {
                VivaldiPosition[][] positions = new VivaldiPosition[20][20];
                final ArrayList<VivaldiPosition> lPos = new ArrayList<VivaldiPosition>(400);
                HeightCoordinatesImpl[][] realCoordinates = new HeightCoordinatesImpl[20][20];
                for (int i = 0; i < 20; ++i) {
                    for (int j = 0; j < 20; ++j) {
                        realCoordinates[i][j] = new HeightCoordinatesImpl(i * 50 - 500, j * 50 - 500, 20.0f);
                        if (i >= 10) {
                            // empty if block
                        }
                        positions[i][j] = new VivaldiPositionImpl(new HeightCoordinatesImpl(1000 + 50 * i, 1000 + 50 * j, 20.0f));
                        lPos.add(positions[i][j]);
                    }
                }
                for (int iter = 0; iter < 10000; ++iter) {
                    if (iter % 100 == 0) {
                        System.out.println(iter);
                    }
                    if (display.isDisposed()) {
                        return;
                    }
                    display.syncExec(new Runnable(){

                        public void run() {
                            panel.refresh(lPos);
                        }
                    });
                    for (int i = 0; i < 20; ++i) {
                        for (int j = 0; j < 20; ++j) {
                            VivaldiPosition position = positions[i][j];
                            for (int k = 0; k < 5; ++k) {
                                int i1 = (int)(Math.random() * 20.0);
                                int j1 = (int)(Math.random() * 20.0);
                                if (i1 == i && j1 == j) continue;
                                VivaldiPosition position1 = positions[i1][j1];
                                float rtt = realCoordinates[i1][j1].distance(realCoordinates[i][j]);
                                position.update(rtt, position1.getCoordinates(), position1.getErrorEstimate());
                            }
                        }
                    }
                }
            }
        };
        runner.setDaemon(true);
        runner.start();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static void main(String[] args) {
        new VivaldiVisualTest();
    }
}

