/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl;

import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.Coordinates;

public class HeightCoordinatesImpl
implements Coordinates {
    protected float x;
    protected float y;
    protected float h;

    public HeightCoordinatesImpl(float x, float y, float h) {
        this.x = x;
        this.y = y;
        this.h = h;
    }

    public HeightCoordinatesImpl(HeightCoordinatesImpl copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.h = copy.h;
    }

    public Coordinates add(Coordinates other) {
        HeightCoordinatesImpl o = (HeightCoordinatesImpl)other;
        return new HeightCoordinatesImpl(this.x + o.x, this.y + o.y, Math.abs(this.h + o.h));
    }

    public Coordinates sub(Coordinates other) {
        HeightCoordinatesImpl o = (HeightCoordinatesImpl)other;
        return new HeightCoordinatesImpl(this.x - o.x, this.y - o.y, Math.abs(this.h + o.h));
    }

    public Coordinates scale(float scale) {
        return new HeightCoordinatesImpl(scale * this.x, scale * this.y, scale * this.h);
    }

    public float measure() {
        return (float)(Math.sqrt(this.x * this.x + this.y * this.y) + (double)this.h);
    }

    public boolean atOrigin() {
        return this.x == 0.0f && this.y == 0.0f;
    }

    public boolean isValid() {
        return this.valid(this.x) && this.valid(this.y) && this.valid(this.h) && Math.abs(this.x) <= 30000.0f && Math.abs(this.y) <= 30000.0f && Math.abs(this.h) <= 30000.0f;
    }

    private boolean valid(float f) {
        return !Float.isInfinite(f) && !Float.isNaN(f);
    }

    public float distance(Coordinates other) {
        return this.sub(other).measure();
    }

    public Coordinates unity() {
        float measure = this.measure();
        if (measure == 0.0f) {
            float x = (float)Math.random();
            float y = (float)Math.random();
            float h = (float)Math.random();
            return new HeightCoordinatesImpl(x, y, h).unity();
        }
        return this.scale(1.0f / measure);
    }

    public double[] getCoordinates() {
        return new double[]{this.x, this.y};
    }

    public String toString() {
        return (int)this.x + "," + (int)this.y + "," + (int)this.h;
    }

    public float getH() {
        return this.h;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof HeightCoordinatesImpl) {
            HeightCoordinatesImpl other = (HeightCoordinatesImpl)arg0;
            return other.x == this.x && other.y == this.y && other.h == this.h;
        }
        return false;
    }
}

