/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceOfflineDownload;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloader;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloaderListener;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloaderManager;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.util.DownloadUtils;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.services.UPnPOfflineDownloader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceOfflineDownloaderImpl
extends DeviceUPnPImpl
implements DeviceOfflineDownloader {
    public static final int UPDATE_MILLIS = 30000;
    public static final int UPDATE_TICKS = 6;
    public static final int UPDATE_SPACE_MILLIS = 180000;
    public static final int UPDATE_SPACE_TICKS = 36;
    public static final String client_id = ByteFormatter.encodeString(CryptoManagerFactory.getSingleton().getSecureID());
    private static final Object ERROR_KEY_OD = new Object();
    private volatile UPnPOfflineDownloader service;
    private volatile String service_ip;
    private volatile String manufacturer;
    private long start_time = SystemTime.getMonotonousTime();
    private volatile boolean update_space_outstanding = true;
    private volatile long space_on_device = -1L;
    private volatile boolean closing;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    final FrequencyLimitedDispatcher freq_lim_updater = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            DeviceOfflineDownloaderImpl.this.updateDownloads();
        }
    }, 5000);
    private boolean start_of_day = true;
    private int consec_errors = 0;
    private int consec_success = 0;
    private Map<String, OfflineDownload> offline_downloads = new HashMap<String, OfflineDownload>();
    private Map<String, TransferableDownload> transferable = new LinkedHashMap<String, TransferableDownload>();
    private TransferableDownload current_transfer;
    private boolean is_transferring;
    private CopyOnWriteList<DeviceOfflineDownloaderListener> listeners = new CopyOnWriteList();

    protected DeviceOfflineDownloaderImpl(DeviceManagerImpl _manager, UPnPDevice _device, UPnPOfflineDownloader _service) {
        super(_manager, _device, 5);
        this.setService(_service);
    }

    protected DeviceOfflineDownloaderImpl(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
        this.manufacturer = this.getPersistentStringProperty("od_manufacturer", "?");
    }

    @Override
    protected boolean updateFrom(DeviceImpl _other, boolean _is_alive) {
        if (!super.updateFrom(_other, _is_alive)) {
            return false;
        }
        if (!(_other instanceof DeviceOfflineDownloaderImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceOfflineDownloaderImpl other = (DeviceOfflineDownloaderImpl)_other;
        if (this.service == null && other.service != null) {
            this.setService(other.service);
            this.updateDownloads();
        }
        return true;
    }

    protected void setService(UPnPOfflineDownloader _service) {
        this.service = _service;
        UPnPRootDevice root = this.service.getGenericService().getDevice().getRootDevice();
        this.service_ip = root.getLocation().getHost();
        try {
            this.service_ip = InetAddress.getByName(this.service_ip).getHostAddress();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        Map cache = root.getDiscoveryCache();
        if (cache != null) {
            this.setPersistentMapProperty("od_upnp_cache", cache);
        }
        this.manufacturer = root.getDevice().getManufacturer();
        this.setPersistentStringProperty("od_manufacturer", this.manufacturer);
        this.updateDownloads();
    }

    @Override
    protected void UPnPInitialised() {
        Map cache;
        super.UPnPInitialised();
        if (this.service == null && (cache = this.getPersistentMapProperty("od_upnp_cache", null)) != null) {
            this.getUPnPDeviceManager().injectDiscoveryCache(cache);
        }
    }

    @Override
    protected void updateStatus(int tick_count) {
        super.updateStatus(tick_count);
        this.update_space_outstanding |= tick_count % 36 == 0;
        if (tick_count % 6 == 0) {
            this.updateDownloads();
        }
    }

    protected void checkConfig() {
        this.freq_lim_updater.dispatch();
    }

    protected void updateDownloads() {
        this.dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                if (DeviceOfflineDownloaderImpl.this.dispatcher.getQueueSize() == 0) {
                    DeviceOfflineDownloaderImpl.this.updateDownloadsSupport();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDownloadsSupport() {
        Throwable e112;
        Map<String, OfflineDownload> map;
        ArrayList<OfflineDownload> cha_ods2;
        ArrayList<OfflineDownload> del_ods2;
        ArrayList<OfflineDownload> new_ods2;
        boolean warn_if_dead;
        AzureusCore core = this.getManager().getAzureusCore();
        if (core == null || this.closing) {
            return;
        }
        boolean bl = warn_if_dead = SystemTime.getMonotonousTime() - this.start_time > 180000L;
        if (!this.isAlive() || this.service == null) {
            if (warn_if_dead) {
                this.setError(ERROR_KEY_OD, MessageText.getString("device.od.error.notfound"));
            }
            return;
        }
        String error_status = null;
        boolean force_status = false;
        HashMap<String, DownloadManager> new_offline_downloads = new HashMap<String, DownloadManager>();
        HashMap<String, TransferableDownload> new_transferables = new HashMap<String, TransferableDownload>();
        try {
            block100: {
                ArrayList downloads;
                DeviceManagerImpl manager;
                DeviceOfflineDownloaderManager dodm;
                if (this.update_space_outstanding) {
                    try {
                        this.space_on_device = this.service.getFreeSpace(client_id);
                        this.update_space_outstanding = false;
                    }
                    catch (Throwable e2) {
                        error_status = MessageText.getString("device.od.error.opfailexcep", new String[]{"GetFreeSpace", Debug.getNestedExceptionMessage(e2)});
                        this.log("Failed to get free space", e2);
                    }
                }
                if (this.space_on_device == 0L) {
                    error_status = MessageText.getString("device.od.error.nospace");
                    force_status = true;
                }
                Map old_cache = this.getPersistentMapProperty("od_state_cache", new HashMap());
                HashMap<String, byte[]> new_cache = new HashMap<String, byte[]>();
                GlobalManager gm = core.getGlobalManager();
                if (this.start_of_day) {
                    this.start_of_day = false;
                    Map xfer_cache = this.getPersistentMapProperty("od_xfer_cache", new HashMap());
                    if (xfer_cache.size() > 0) {
                        List initial_downloads = gm.getDownloadManagers();
                        for (DownloadManager download : initial_downloads) {
                            TOTorrent torrent;
                            if (!download.isForceStart() || (torrent = download.getTorrent()) == null) continue;
                            try {
                                byte[] hash = torrent.getHash();
                                String hash_str = ByteFormatter.encodeString(hash);
                                Map m = (Map)xfer_cache.get(hash_str);
                                if (m == null || !m.containsKey("f")) continue;
                                this.log(download, "Resetting force-start");
                                download.setForceStart(false);
                            }
                            catch (Throwable e3) {
                                Debug.printStackTrace(e3);
                            }
                        }
                    }
                    gm.addListener(new GlobalManagerAdapter(){

                        public void downloadManagerAdded(DownloadManager dm) {
                            DeviceOfflineDownloaderImpl.this.freq_lim_updater.dispatch();
                        }

                        public void downloadManagerRemoved(DownloadManager dm) {
                            DeviceOfflineDownloaderImpl.this.freq_lim_updater.dispatch();
                        }
                    }, false);
                }
                if ((dodm = (manager = this.getManager()).getOfflineDownlaoderManager()).isOfflineDownloadingEnabled() && this.isEnabled()) {
                    List initial_downloads = gm.getDownloadManagers();
                    ArrayList<DownloadManager> relevant_downloads = new ArrayList<DownloadManager>(initial_downloads.size());
                    for (DownloadManager download : initial_downloads) {
                        int state = download.getState();
                        if (state == 60 || state == 70 && !download.isPaused() || download.isDownloadComplete(false)) continue;
                        relevant_downloads.add(download);
                    }
                    downloads = new ArrayList(relevant_downloads.size());
                    if (dodm.getOfflineDownloadingIsAuto()) {
                        boolean include_private = dodm.getOfflineDownloadingIncludePrivate();
                        if (include_private) {
                            downloads.addAll(relevant_downloads);
                        } else {
                            for (DownloadManager download : relevant_downloads) {
                                TOTorrent torrent = download.getTorrent();
                                if (TorrentUtils.isReallyPrivate(torrent)) continue;
                                downloads.add(download);
                            }
                        }
                    } else {
                        for (DownloadManager download : relevant_downloads) {
                            if (!dodm.isManualDownload(PluginCoreUtils.wrap(download))) continue;
                            downloads.add(download);
                        }
                    }
                } else {
                    downloads = new ArrayList();
                }
                HashMap<DownloadManager, byte[]> download_map = new HashMap<DownloadManager, byte[]>();
                for (DownloadManager download : downloads) {
                    TOTorrent torrent = download.getTorrent();
                    if (torrent == null) continue;
                    try {
                        byte[] hash = torrent.getHash();
                        String hash_str = ByteFormatter.encodeString(hash);
                        DiskManager disk = download.getDiskManager();
                        if (disk == null) {
                            byte[] existing = (byte[])old_cache.get(hash_str);
                            if (existing != null) {
                                new_cache.put(hash_str, existing);
                                download_map.put(download, existing);
                                continue;
                            }
                            DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
                            byte[] needed = new byte[(torrent.getNumberOfPieces() + 7) / 8];
                            int hits = 0;
                            for (DiskManagerFileInfo file : files) {
                                if (file.isSkipped()) continue;
                                int first_piece = file.getFirstPieceNumber();
                                int last_piece = first_piece + file.getNbPieces() - 1;
                                int needed_pos = first_piece / 8;
                                int current_byte = 0;
                                for (int pos = first_piece; pos <= last_piece; ++pos) {
                                    current_byte <<= 1;
                                    ++current_byte;
                                    ++hits;
                                    if (pos % 8 != 7) continue;
                                    int n = needed_pos++;
                                    needed[n] = (byte)(needed[n] | (byte)current_byte);
                                    current_byte = 0;
                                }
                                if (current_byte == 0) continue;
                                int n = needed_pos++;
                                needed[n] = (byte)(needed[n] | (byte)(current_byte << 8 - last_piece % 8));
                            }
                            if (hits <= 0) continue;
                            new_cache.put(hash_str, needed);
                            download_map.put(download, needed);
                            continue;
                        }
                        DiskManagerPiece[] pieces = disk.getPieces();
                        byte[] needed = new byte[(pieces.length + 7) / 8];
                        int needed_pos = 0;
                        int current_byte = 0;
                        int pos = 0;
                        int hits = 0;
                        for (DiskManagerPiece piece : pieces) {
                            current_byte <<= 1;
                            if (piece.isNeeded() && !piece.isDone()) {
                                ++current_byte;
                                ++hits;
                            }
                            if (pos % 8 == 7) {
                                needed[needed_pos++] = (byte)current_byte;
                                current_byte = 0;
                            }
                            ++pos;
                        }
                        if (pos % 8 != 0) {
                            needed[needed_pos++] = (byte)(current_byte << 8 - pos % 8);
                        }
                        if (hits <= 0) continue;
                        new_cache.put(hash_str, needed);
                        download_map.put(download, needed);
                    }
                    catch (Throwable e4) {
                        Debug.out(e4);
                    }
                }
                this.setPersistentMapProperty("od_state_cache", new_cache);
                ArrayList entries = new ArrayList(download_map.entrySet());
                Collections.sort(entries, new Comparator<Map.Entry<DownloadManager, byte[]>>(){

                    @Override
                    public int compare(Map.Entry<DownloadManager, byte[]> o1, Map.Entry<DownloadManager, byte[]> o2) {
                        return o1.getKey().getPosition() - o2.getKey().getPosition();
                    }
                });
                String download_hashes = "";
                Iterator it = entries.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    DownloadManager download = (DownloadManager)entry.getKey();
                    try {
                        String hash = ByteFormatter.encodeString(download.getTorrent().getHash());
                        download_hashes = download_hashes + (download_hashes.length() == 0 ? "" : ",") + hash;
                        new_offline_downloads.put(hash, download);
                    }
                    catch (Throwable e5) {
                        this.log(download, "Failed to get download hash", e5);
                        it.remove();
                    }
                }
                try {
                    int num_bits;
                    String[] set_dl_results = this.service.setDownloads(client_id, download_hashes);
                    String set_dl_result = set_dl_results[0].trim();
                    String set_dl_status = set_dl_results[1];
                    if (!set_dl_status.equals("OK")) {
                        error_status = MessageText.getString("device.od.error.opfailstatus", new String[]{"SetDownloads", set_dl_status});
                        throw new Exception("Failing result returned: " + set_dl_status);
                    }
                    String[] bits = Constants.PAT_SPLIT_COMMA.split(set_dl_result);
                    int n = num_bits = set_dl_result.length() == 0 ? 0 : bits.length;
                    if (num_bits != entries.size()) {
                        this.log("SetDownloads returned an invalid number of results (hashes=" + new_offline_downloads.size() + ",result=" + set_dl_result + ")");
                        break block100;
                    }
                    it = entries.iterator();
                    int pos = 0;
                    while (it.hasNext()) {
                        Map.Entry entry = (Map.Entry)it.next();
                        DownloadManager download = (DownloadManager)entry.getKey();
                        try {
                            int i;
                            TOTorrent torrent = download.getTorrent();
                            String hash_str = ByteFormatter.encodeString(torrent.getHash());
                            int status = Integer.parseInt(bits[pos++]);
                            boolean do_update = false;
                            if (status == 0) {
                                do_update = true;
                            } else if (status == 1) {
                                try {
                                    String ext;
                                    if (PlatformTorrentUtils.isContent(torrent, true) && (ext = DownloadUtils.getTrackerExtensions(PluginCoreUtils.wrap(download))) != null && ext.length() > 0) {
                                        try {
                                            TOTorrentAnnounceURLSet[] sets;
                                            if (ext.startsWith("&")) {
                                                ext = ext.substring(1);
                                            }
                                            torrent = TOTorrentFactory.deserialiseFromMap(torrent.serialiseToMap());
                                            torrent.setAnnounceURL(this.appendToURL(torrent.getAnnounceURL(), ext));
                                            for (TOTorrentAnnounceURLSet set : sets = torrent.getAnnounceURLGroup().getAnnounceURLSets()) {
                                                URL[] urls = set.getAnnounceURLs();
                                                for (i = 0; i < urls.length; ++i) {
                                                    urls[i] = this.appendToURL(urls[i], ext);
                                                }
                                            }
                                            torrent.getAnnounceURLGroup().setAnnounceURLSets(sets);
                                        }
                                        catch (Throwable e6) {
                                            this.log("Torrent modification failed", e6);
                                        }
                                    }
                                    String add_result = this.addTorrent(hash_str, ByteFormatter.encodeStringFully(BEncoder.encode(torrent.serialiseToMap())));
                                    this.log(download, "AddDownload succeeded");
                                    if (!add_result.equals("OK")) {
                                        error_status = MessageText.getString("device.od.error.opfailstatus", new String[]{"AddDownload", add_result});
                                        throw new Exception("Failed to add download: " + add_result);
                                    }
                                    do_update = true;
                                }
                                catch (Throwable e7) {
                                    error_status = MessageText.getString("device.od.error.opfailexcep", new String[]{"AddDownload", Debug.getNestedExceptionMessage(e7)});
                                    this.log(download, "Failed to add download", e7);
                                }
                            } else {
                                error_status = MessageText.getString("device.od.error.opfailstatus", new String[]{"SetDownloads", String.valueOf(status)});
                                this.log(download, "SetDownloads: error status returned - " + status);
                            }
                            if (!do_update) continue;
                            try {
                                byte[] required_map = (byte[])entry.getValue();
                                String required_bitfield = ByteFormatter.encodeStringFully(required_map);
                                String[] update_results = this.service.updateDownload(client_id, hash_str, required_bitfield);
                                String have_bitfield = update_results[0];
                                String update_status = update_results[1];
                                if (!update_status.equals("OK")) {
                                    error_status = MessageText.getString("device.od.error.opfailstatus", new String[]{"UpdateDownload", update_status});
                                    throw new Exception("UpdateDownload: Failing result returned: " + update_status);
                                }
                                int useful_piece_count = 0;
                                if (have_bitfield.length() > 0) {
                                    byte[] have_map = ByteFormatter.decodeString(have_bitfield);
                                    if (have_map.length != required_map.length) {
                                        throw new Exception("UpdateDownload: Returned bitmap length invalid");
                                    }
                                    for (i = 0; i < required_map.length; ++i) {
                                        int x = required_map[i] & have_map[i] & 0xFF;
                                        if (x == 0) continue;
                                        for (int j = 0; j < 8; ++j) {
                                            if ((x & 1) != 0) {
                                                ++useful_piece_count;
                                            }
                                            x >>= 1;
                                        }
                                    }
                                    if (useful_piece_count > 0) {
                                        long piece_size = torrent.getPieceLength();
                                        new_transferables.put(hash_str, new TransferableDownload(download, hash_str, have_map, (long)useful_piece_count * piece_size));
                                    }
                                }
                                if (useful_piece_count <= 0) continue;
                                this.log(download, "They have " + useful_piece_count + " pieces that we don't");
                            }
                            catch (Throwable e8) {
                                error_status = MessageText.getString("device.od.error.opfailexcep", new String[]{"UpdateDownload", Debug.getNestedExceptionMessage(e8)});
                                this.log(download, "UpdateDownload failed", e8);
                            }
                        }
                        catch (Throwable e9) {
                            this.log(download, "Processing failed", e9);
                        }
                    }
                }
                catch (Throwable e10) {
                    error_status = MessageText.getString("device.od.error.opfailexcep", new String[]{"SetDownloads", Debug.getNestedExceptionMessage(e10)});
                    this.log("SetDownloads failed", e10);
                }
            }
            Object var40_82 = null;
            this.updateTransferable(new_transferables);
            new_ods2 = new ArrayList<OfflineDownload>();
            del_ods2 = new ArrayList<OfflineDownload>();
            cha_ods2 = new ArrayList<OfflineDownload>();
            map = this.offline_downloads;
        }
        catch (Throwable throwable) {
            Throwable e112;
            Object var40_83 = null;
            this.updateTransferable(new_transferables);
            ArrayList<OfflineDownload> new_ods2 = new ArrayList<OfflineDownload>();
            ArrayList<OfflineDownload> del_ods2 = new ArrayList<OfflineDownload>();
            ArrayList<OfflineDownload> cha_ods2 = new ArrayList<OfflineDownload>();
            Map<String, OfflineDownload> map2 = this.offline_downloads;
            synchronized (map2) {
                String key;
                for (Map.Entry<Object, Object> entry : new_offline_downloads.entrySet()) {
                    key = (String)entry.getKey();
                    if (this.offline_downloads.containsKey(key)) continue;
                    OfflineDownload new_od = new OfflineDownload((DownloadManager)entry.getValue());
                    this.offline_downloads.put(key, new_od);
                    new_ods2.add(new_od);
                }
                Iterator<Map.Entry<String, OfflineDownload>> it = this.offline_downloads.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> entry;
                    entry = it.next();
                    key = (String)entry.getKey();
                    OfflineDownload od = (OfflineDownload)entry.getValue();
                    if (new_offline_downloads.containsKey(key)) {
                        TransferableDownload existing_td;
                        TransferableDownload new_td = this.transferable.get(key);
                        if (new_td == (existing_td = od.getTransferable())) continue;
                        if (!new_ods2.contains(od)) {
                            cha_ods2.add(od);
                        }
                        od.setTransferable(new_td);
                        continue;
                    }
                    it.remove();
                    del_ods2.add(od);
                }
            }
            for (OfflineDownload od : new_ods2) {
                for (DeviceOfflineDownloaderListener listener : this.listeners) {
                    try {
                        listener.downloadAdded(od);
                    }
                    catch (Throwable e112) {
                        Debug.out(e112);
                    }
                }
            }
            for (OfflineDownload od : cha_ods2) {
                for (DeviceOfflineDownloaderListener listener : this.listeners) {
                    try {
                        listener.downloadChanged(od);
                    }
                    catch (Throwable e112) {
                        Debug.out(e112);
                    }
                }
            }
            for (OfflineDownload od : del_ods2) {
                for (DeviceOfflineDownloaderListener listener : this.listeners) {
                    try {
                        listener.downloadRemoved(od);
                    }
                    catch (Throwable e112) {
                        Debug.out(e112);
                    }
                }
            }
            this.updateError(error_status, force_status);
            throw throwable;
        }
        synchronized (map) {
            String key;
            for (Map.Entry<Object, Object> entry : new_offline_downloads.entrySet()) {
                key = (String)entry.getKey();
                if (this.offline_downloads.containsKey(key)) continue;
                OfflineDownload new_od = new OfflineDownload((DownloadManager)entry.getValue());
                this.offline_downloads.put(key, new_od);
                new_ods2.add(new_od);
            }
            Iterator<Map.Entry<String, OfflineDownload>> it = this.offline_downloads.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry;
                entry = it.next();
                key = (String)entry.getKey();
                OfflineDownload od = (OfflineDownload)entry.getValue();
                if (new_offline_downloads.containsKey(key)) {
                    TransferableDownload existing_td;
                    TransferableDownload new_td = this.transferable.get(key);
                    if (new_td == (existing_td = od.getTransferable())) continue;
                    if (!new_ods2.contains(od)) {
                        cha_ods2.add(od);
                    }
                    od.setTransferable(new_td);
                    continue;
                }
                it.remove();
                del_ods2.add(od);
            }
        }
        for (OfflineDownload od : new_ods2) {
            for (DeviceOfflineDownloaderListener listener : this.listeners) {
                try {
                    listener.downloadAdded(od);
                }
                catch (Throwable e112) {
                    Debug.out(e112);
                }
            }
        }
        for (OfflineDownload od : cha_ods2) {
            for (DeviceOfflineDownloaderListener listener : this.listeners) {
                try {
                    listener.downloadChanged(od);
                }
                catch (Throwable e112) {
                    Debug.out(e112);
                }
            }
        }
        for (OfflineDownload od : del_ods2) {
            for (DeviceOfflineDownloaderListener listener : this.listeners) {
                try {
                    listener.downloadRemoved(od);
                }
                catch (Throwable e112) {
                    Debug.out(e112);
                }
            }
        }
        {
        }
        this.updateError(error_status, force_status);
    }

    private String addTorrent(String hash_str, String torrent_data) throws UPnPException {
        int chunk_size = 40960;
        int length = torrent_data.length();
        if (length < chunk_size) {
            return this.service.addDownload(client_id, hash_str, torrent_data);
        }
        String status = "";
        int rem = length;
        for (int i = 0; i < length; i += chunk_size) {
            int size = Math.min(rem, chunk_size);
            status = this.service.addDownloadChunked(client_id, hash_str, torrent_data.substring(i, i + size), i, length);
            rem -= size;
        }
        return status;
    }

    protected void updateError(String str, boolean force) {
        if (str == null) {
            this.setError(ERROR_KEY_OD, null);
            this.consec_errors = 0;
            ++this.consec_success;
        } else {
            try {
                if (!this.service.getGenericService().isConnectable()) {
                    str = MessageText.getString("device.od.error.notfound");
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            ++this.consec_errors;
            this.consec_success = 0;
            if (this.consec_errors > 2 || force) {
                this.setError(ERROR_KEY_OD, str);
            }
        }
    }

    protected URL appendToURL(URL url, String ext) throws MalformedURLException {
        String url_str = url.toExternalForm();
        url_str = url_str.indexOf(63) == -1 ? url_str + "?" + ext : url_str + "&" + ext;
        return new URL(url_str);
    }

    protected void updateTransferable(Map<String, TransferableDownload> map) {
        long now;
        long runtime;
        Iterator<Map.Entry<String, TransferableDownload>> it = this.transferable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, TransferableDownload> entry = it.next();
            if (map.containsKey(entry.getKey())) continue;
            TransferableDownload existing = entry.getValue();
            if (existing == this.current_transfer) {
                this.current_transfer.deactivate();
                this.current_transfer = null;
            }
            it.remove();
        }
        for (TransferableDownload td : map.values()) {
            String hash = td.getHash();
            if (this.transferable.containsKey(hash)) continue;
            this.transferable.put(hash, td);
        }
        if (this.transferable.size() == 0) {
            if (this.is_transferring) {
                this.is_transferring = false;
                this.setBusy(false);
            }
            return;
        }
        if (!this.is_transferring) {
            this.is_transferring = true;
            this.setBusy(true);
        }
        if (this.current_transfer != null && this.transferable.size() > 0 && (runtime = (now = SystemTime.getMonotonousTime()) - this.current_transfer.getStartTime()) >= 30000L) {
            boolean rotate = false;
            PEPeerManager pm = this.current_transfer.getDownload().getPeerManager();
            if (pm == null) {
                rotate = true;
            } else if (runtime > 180000L) {
                List<PEPeer> peers = pm.getPeers(this.service_ip);
                if (peers.size() == 0) {
                    rotate = true;
                } else {
                    PEPeer peer = peers.get(0);
                    if (peer.getStats().getDataReceiveRate() < 1024L) {
                        rotate = true;
                    }
                }
            }
            if (rotate) {
                this.current_transfer.deactivate();
                this.current_transfer = null;
            }
        }
        if (this.current_transfer == null) {
            Iterator<TransferableDownload> it2 = this.transferable.values().iterator();
            this.current_transfer = it2.next();
            it2.remove();
            this.transferable.put(this.current_transfer.getHash(), this.current_transfer);
        }
        if (this.current_transfer != null) {
            if (!this.current_transfer.isActive()) {
                this.current_transfer.activate();
            }
            if (this.current_transfer.isForced()) {
                HashMap xfer_cache = new HashMap();
                HashMap<String, Long> m = new HashMap<String, Long>();
                m.put("f", new Long(1L));
                xfer_cache.put(this.current_transfer.getHash(), m);
                this.setPersistentMapProperty("od_xfer_cache", xfer_cache);
            }
            DownloadManager download = this.current_transfer.getDownload();
            int data_port = this.current_transfer.getDataPort();
            if (data_port <= 0) {
                try {
                    String[] start_results = this.service.startDownload(client_id, this.current_transfer.getHash());
                    String start_status = start_results[1];
                    if (!start_status.equals("OK")) {
                        throw new Exception("Failing result returned: " + start_status);
                    }
                    data_port = Integer.parseInt(start_results[0]);
                    this.log(download, "StartDownload succeeded - data port=" + data_port);
                }
                catch (Throwable e) {
                    this.log(download, "StartDownload failed", e);
                }
            }
            if (data_port > 0) {
                this.current_transfer.setDataPort(data_port);
            }
            final TransferableDownload transfer = this.current_transfer;
            this.dispatcher.dispatch(new AERunnable(){
                private final int[] count = new int[]{0};

                public void runSupport() {
                    this.count[0] = this.count[0] + 1;
                    if (DeviceOfflineDownloaderImpl.this.current_transfer != transfer || !transfer.isActive()) {
                        return;
                    }
                    PEPeerManager pm = transfer.getDownload().getPeerManager();
                    if (pm == null) {
                        return;
                    }
                    List<PEPeer> peers = pm.getPeers(DeviceOfflineDownloaderImpl.this.service_ip);
                    if (peers.size() > 0) {
                        return;
                    }
                    LightHashMap user_data = new LightHashMap();
                    user_data.put(Peer.PR_PRIORITY_CONNECTION, new Boolean(true));
                    pm.addPeer(DeviceOfflineDownloaderImpl.this.service_ip, transfer.getDataPort(), 0, false, user_data);
                    if (this.count[0] < 3) {
                        final 5 target = this;
                        SimpleTimer.addEvent("OD:retry", SystemTime.getCurrentTime() + 5000L, new TimerEventPerformer(){

                            public void perform(TimerEvent event2) {
                                DeviceOfflineDownloaderImpl.this.dispatcher.dispatch(target);
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    protected void close() {
        super.close();
        final AESemaphore sem = new AESemaphore("DOD:closer");
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    DeviceOfflineDownloaderImpl.this.closing = true;
                    if (DeviceOfflineDownloaderImpl.this.service != null) {
                        try {
                            DeviceOfflineDownloaderImpl.this.service.activate(client_id);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    Object var3_2 = null;
                    sem.release();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    sem.release();
                    throw throwable;
                }
            }
        });
        sem.reserve(250L);
    }

    @Override
    public boolean isEnabled() {
        return this.getPersistentBooleanProperty("od_enabled", false);
    }

    @Override
    public void setEnabled(boolean b) {
        this.setPersistentBooleanProperty("od_enabled", b);
        if (b) {
            this.freq_lim_updater.dispatch();
        }
    }

    @Override
    public boolean isAlive() {
        if (super.isAlive()) {
            return this.service.getGenericService().isConnectable();
        }
        return false;
    }

    @Override
    public boolean hasShownFTUX() {
        return this.getPersistentBooleanProperty("od_shown_ftux", false);
    }

    @Override
    public void setShownFTUX() {
        this.setPersistentBooleanProperty("od_shown_ftux", true);
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public long getSpaceAvailable(boolean force) throws DeviceManagerException {
        if (this.space_on_device >= 0L && !force) {
            return this.space_on_device;
        }
        if (this.service == null) {
            throw new DeviceManagerException("Device is not online");
        }
        try {
            this.space_on_device = this.service.getFreeSpace(client_id);
            this.update_space_outstanding = false;
            return this.space_on_device;
        }
        catch (Throwable e) {
            throw new DeviceManagerException("Failed to read available space", e);
        }
    }

    @Override
    public int getTransferingCount() {
        return this.transferable.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceOfflineDownload[] getDownloads() {
        Map<String, OfflineDownload> map = this.offline_downloads;
        synchronized (map) {
            return this.offline_downloads.values().toArray(new DeviceOfflineDownload[this.offline_downloads.size()]);
        }
    }

    @Override
    public void addListener(DeviceOfflineDownloaderListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DeviceOfflineDownloaderListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void getDisplayProperties(List<String[]> dp) {
        super.getDisplayProperties(dp);
        String space_str = "";
        if (this.space_on_device >= 0L) {
            space_str = DisplayFormatters.formatByteCountToKiBEtc(this.space_on_device);
        }
        this.addDP(dp, "azbuddy.enabled", this.isEnabled());
        this.addDP(dp, "device.od.space", space_str);
    }

    protected void log(DownloadManager download, String str) {
        this.log(download.getDisplayName() + ": " + str);
    }

    protected void log(DownloadManager download, String str, Throwable e) {
        this.log(download.getDisplayName() + ": " + str, e);
    }

    @Override
    protected void log(String str) {
        super.log("OfflineDownloader: " + str);
    }

    @Override
    protected void log(String str, Throwable e) {
        super.log("OfflineDownloader: " + str, e);
    }

    protected class OfflineDownload
    implements DeviceOfflineDownload {
        private DownloadManager core_download;
        private Download download;
        private TransferableDownload transferable;

        protected OfflineDownload(DownloadManager _core_download) {
            this.core_download = _core_download;
            this.download = PluginCoreUtils.wrap(this.core_download);
        }

        public Download getDownload() {
            return this.download;
        }

        public boolean isTransfering() {
            return this.transferable != null;
        }

        public long getCurrentTransferSize() {
            TransferableDownload t = this.transferable;
            if (t == null) {
                return 0L;
            }
            return t.getCurrentTransferSize();
        }

        public long getRemaining() {
            TransferableDownload t = this.transferable;
            if (t == null) {
                return 0L;
            }
            return t.getRemaining();
        }

        protected void setTransferable(TransferableDownload td) {
            this.transferable = td;
        }

        protected TransferableDownload getTransferable() {
            return this.transferable;
        }
    }

    protected class TransferableDownload {
        private DownloadManager download;
        private String hash_str;
        private byte[] have_map;
        private boolean active;
        private long start_time;
        private boolean forced;
        private int data_port;
        private long transfer_size;
        private volatile long last_calc;
        private volatile long last_calc_time;

        protected TransferableDownload(DownloadManager _download, String _hash_str, byte[] _have_map, long _transfer_size_estimate) {
            this.download = _download;
            this.hash_str = _hash_str;
            this.have_map = _have_map;
            this.last_calc = this.transfer_size = _transfer_size_estimate;
        }

        protected long calcDiff() {
            long now = SystemTime.getMonotonousTime();
            if (now - this.last_calc_time < 2000L) {
                return this.last_calc;
            }
            DiskManager disk = this.download.getDiskManager();
            if (disk == null) {
                return this.last_calc;
            }
            DiskManagerPiece[] pieces = disk.getPieces();
            int pos = 0;
            int current = 0;
            long remaining = 0L;
            for (int i = 0; i < pieces.length; ++i) {
                if (i % 8 == 0) {
                    current = this.have_map[pos++] & 0xFF;
                }
                if ((current & 0x80) != 0) {
                    DiskManagerPiece piece = pieces[i];
                    boolean[] written = piece.getWritten();
                    if (written == null) {
                        if (!piece.isDone()) {
                            remaining += (long)piece.getLength();
                        }
                    } else {
                        for (int j = 0; j < written.length; ++j) {
                            if (written[j]) continue;
                            remaining += (long)piece.getBlockSize(j);
                        }
                    }
                }
                current <<= 1;
            }
            this.last_calc = remaining;
            this.last_calc_time = now;
            return this.last_calc;
        }

        protected long getCurrentTransferSize() {
            return this.transfer_size;
        }

        protected long getRemaining() {
            return this.calcDiff();
        }

        protected long getStartTime() {
            return this.start_time;
        }

        protected boolean isForced() {
            return this.forced;
        }

        protected boolean isActive() {
            return this.active;
        }

        protected int getDataPort() {
            return this.data_port;
        }

        protected void setDataPort(int dp) {
            this.data_port = dp;
        }

        protected void activate() {
            this.active = true;
            this.start_time = SystemTime.getMonotonousTime();
            if (this.download.isForceStart()) {
                DeviceOfflineDownloaderImpl.this.log(this.download, "Activating for transfer");
            } else {
                DeviceOfflineDownloaderImpl.this.log(this.download, "Activating for transfer; setting force-start");
                this.forced = true;
                this.download.setForceStart(true);
            }
        }

        protected void deactivate() {
            this.active = false;
            if (this.forced) {
                DeviceOfflineDownloaderImpl.this.log(this.download, "Deactivating for transfer; resetting force-start");
                this.download.setForceStart(false);
            } else {
                DeviceOfflineDownloaderImpl.this.log(this.download, "Deactivating for transfer");
            }
            this.data_port = 0;
        }

        protected DownloadManager getDownload() {
            return this.download;
        }

        protected String getHash() {
            return this.hash_str;
        }

        protected byte[] getHaveMap() {
            return this.have_map;
        }
    }
}

