/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.cnetwork.impl;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkException;
import com.aelitis.azureus.core.cnetwork.ContentNetworkListener;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManager;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkImpl;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkVuze;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkVuzeGeneric;
import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationManager;
import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.config.PlatformContentNetworkMessenger;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class ContentNetworkManagerImpl
implements ContentNetworkManager,
AEDiagnosticsEvidenceGenerator {
    private static final boolean LOAD_ALL_NETWORKS = true;
    private static final String CONFIG_FILE = "cnetworks.config";
    private static ContentNetworkManagerImpl singleton = new ContentNetworkManagerImpl();
    private List<ContentNetworkImpl> networks = new ArrayList<ContentNetworkImpl>();
    private CopyOnWriteList<ContentNetworkListener> listeners = new CopyOnWriteList();

    public static void preInitialise() {
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            public void process(VuzeFile[] files, int expected_types) {
                for (int i = 0; i < files.length; ++i) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    for (int j = 0; j < comps.length; ++j) {
                        VuzeFileComponent comp2 = comps[j];
                        if (comp2.getType() != 128) continue;
                        try {
                            ((ContentNetworkManagerImpl)ContentNetworkManagerImpl.getSingleton()).importNetwork(comp2.getContent());
                            comp2.setProcessed();
                            continue;
                        }
                        catch (Throwable e) {
                            ContentNetworkManagerImpl.log("Failed to import from vuze file", e);
                            Debug.out(e);
                        }
                    }
                }
            }
        });
    }

    public static ContentNetworkManager getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentNetworkManagerImpl() {
        this.loadConfig();
        this.addNetwork(new ContentNetworkVuze(this));
        AEDiagnostics.addEvidenceGenerator(this);
        CustomizationManager cust_man = CustomizationManagerFactory.getSingleton();
        Customization cust = cust_man.getActiveCustomization();
        if (cust != null) {
            boolean new_version;
            String cust_name = COConfigurationManager.getStringParameter("cnetworks.custom.name", "");
            String cust_version = COConfigurationManager.getStringParameter("cnetworks.custom.version", "0");
            boolean new_name = !cust_name.equals(cust.getName());
            boolean bl = new_version = Constants.compareVersions(cust_version, cust.getVersion()) < 0;
            if (new_name || new_version) {
                try {
                    InputStream[] streams = cust.getResources("cnetworks");
                    for (int i = 0; i < streams.length; ++i) {
                        Throwable e3;
                        Object var17_17;
                        InputStream is = streams[i];
                        try {
                            VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(is);
                            if (vf != null) {
                                VuzeFileComponent[] comps = vf.getComponents();
                                for (int j = 0; j < comps.length; ++j) {
                                    VuzeFileComponent comp2 = comps[j];
                                    int type = comp2.getType();
                                    if (type != 128) continue;
                                    try {
                                        ContentNetworkImpl imported = this.importNetwork(comp2.getContent());
                                        imported.setPersistentProperty("is_cust", true);
                                        comp2.setProcessed();
                                        continue;
                                    }
                                    catch (Throwable e2) {
                                        ContentNetworkManagerImpl.log("Failed to import customisation network", e2);
                                    }
                                }
                            }
                            var17_17 = null;
                        }
                        catch (Throwable throwable) {
                            var17_17 = null;
                            try {
                                is.close();
                            }
                            catch (Throwable e3) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (Throwable e3) {}
                    }
                    Object var20_20 = null;
                }
                catch (Throwable throwable) {
                    Object var20_21 = null;
                    COConfigurationManager.setParameter("cnetworks.custom.name", cust.getName());
                    COConfigurationManager.setParameter("cnetworks.custom.version", cust.getVersion());
                    throw throwable;
                }
                COConfigurationManager.setParameter("cnetworks.custom.name", cust.getName());
                COConfigurationManager.setParameter("cnetworks.custom.version", cust.getVersion());
                {
                }
            }
        }
        SimpleTimer.addPeriodicEvent("MetaSearchRefresh", 82800000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                ContentNetworkManagerImpl.this.checkForUpdates();
            }
        });
        if (this.networks.size() <= 1) {
            // empty if block
        }
        new AEThread2("CNetwork:init", true){

            public void run() {
                ContentNetworkManagerImpl.this.checkForUpdates();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForUpdates() {
        ContentNetworkManagerImpl contentNetworkManagerImpl = this;
        synchronized (contentNetworkManagerImpl) {
            if (this.networks.size() < 2) {
                // empty if block
            }
        }
        PlatformContentNetworkMessenger.listNetworksAync(new PlatformContentNetworkMessenger.listNetworksListener(){

            @Override
            public void networkListReturned(List<PlatformContentNetworkMessenger.contentNetworkDetails> cnets) {
                try {
                    String str = "";
                    for (PlatformContentNetworkMessenger.contentNetworkDetails details : cnets) {
                        ContentNetworkImpl new_net;
                        str = str + (str.length() == 0 ? "" : ", ") + details.getString();
                        ContentNetworkImpl existing = ContentNetworkManagerImpl.this.getContentNetwork(details.getID());
                        if (existing != null) {
                            new_net = ContentNetworkManagerImpl.this.createNetwork(details);
                            ContentNetworkManagerImpl.this.addNetwork(new_net);
                            continue;
                        }
                        new_net = ContentNetworkManagerImpl.this.createNetwork(details);
                        ContentNetworkManagerImpl.this.addNetwork(new_net);
                    }
                    ContentNetworkManagerImpl.log("Latest networks: " + str);
                }
                catch (Throwable e) {
                    ContentNetworkManagerImpl.log("Failed to load network list", e);
                }
            }
        }, 11110);
    }

    protected ContentNetworkImpl importNetwork(Map content) throws IOException {
        ContentNetworkImpl network = ContentNetworkImpl.importFromBEncodedMapStatic(this, content);
        return this.addNetwork(network);
    }

    public void addContentNetwork(final long id) throws ContentNetworkException {
        try {
            PlatformContentNetworkMessenger.listNetworksAync(new PlatformContentNetworkMessenger.listNetworksListener(){

                @Override
                public void networkListReturned(List<PlatformContentNetworkMessenger.contentNetworkDetails> cnets) {
                    if (cnets == null) {
                        PlatformMessengerException e = new PlatformMessengerException("No networks returned");
                        for (ContentNetworkListener l : ContentNetworkManagerImpl.this.listeners) {
                            l.networkAddFailed(id, e);
                        }
                        return;
                    }
                    for (PlatformContentNetworkMessenger.contentNetworkDetails details : cnets) {
                        if (details.getID() != id) continue;
                        try {
                            ContentNetworkImpl new_net = ContentNetworkManagerImpl.this.createNetwork(details);
                            ContentNetworkManagerImpl.this.addNetwork(new_net);
                        }
                        catch (ContentNetworkException e) {
                            for (ContentNetworkListener l : ContentNetworkManagerImpl.this.listeners) {
                                l.networkAddFailed(id, e);
                            }
                        }
                        return;
                    }
                    ContentNetworkException e = new ContentNetworkException("Content Network with id " + id + " not found");
                    for (ContentNetworkListener l : ContentNetworkManagerImpl.this.listeners) {
                        l.networkAddFailed(id, e);
                    }
                }
            }, 500);
        }
        catch (Throwable e) {
            ContentNetworkException e2 = new ContentNetworkException("Failed to list permitted networks", e);
            for (ContentNetworkListener l : this.listeners) {
                l.networkAddFailed(id, e2);
            }
            throw e2;
        }
    }

    public ContentNetwork getContentNetworkForURL(String url) {
        try {
            String host = new URL(url).getHost();
            for (ContentNetwork cn : this.getContentNetworks()) {
                String site = (String)cn.getProperty(1);
                if (site == null || !site.endsWith(host)) continue;
                return cn;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public ContentNetwork getStartupContentNetwork() {
        ContentNetwork[] networks;
        for (ContentNetwork network : networks = this.getContentNetworks()) {
            if (!network.isStartupNetwork()) continue;
            return network;
        }
        return this.getContentNetwork(1L);
    }

    protected ContentNetworkImpl createNetwork(PlatformContentNetworkMessenger.contentNetworkDetails details) throws ContentNetworkException {
        String site_dns;
        String main_url = details.getMainURL();
        String icon_url = details.getIconURL();
        try {
            site_dns = new URL(main_url).getHost();
        }
        catch (Throwable e) {
            ContentNetworkManagerImpl.log("Failed to get main-url host", e);
            throw new ContentNetworkException("main url invald", e);
        }
        ContentNetworkImpl existing = this.getContentNetwork(details.getID());
        Map<String, Object> pprop_defaults = null;
        Set<Integer> service_exclusions = null;
        if (existing != null) {
            pprop_defaults = existing.getPersistentPropertyDefaults();
            if (existing instanceof ContentNetworkVuzeGeneric) {
                service_exclusions = ((ContentNetworkVuzeGeneric)existing).getServiceExclusions();
            }
        }
        return new ContentNetworkVuzeGeneric(this, details.getID(), details.getVersion(), details.getName(), pprop_defaults, service_exclusions, site_dns, main_url, icon_url, null, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentNetwork[] getContentNetworks() {
        ContentNetworkManagerImpl contentNetworkManagerImpl = this;
        synchronized (contentNetworkManagerImpl) {
            return this.networks.toArray(new ContentNetworkImpl[this.networks.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentNetworkImpl getContentNetwork(long id) {
        ContentNetworkManagerImpl contentNetworkManagerImpl = this;
        synchronized (contentNetworkManagerImpl) {
            for (int i = 0; i < this.networks.size(); ++i) {
                ContentNetworkImpl network = this.networks.get(i);
                if (network.getID() != id) continue;
                return network;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentNetworkImpl addNetwork(ContentNetworkImpl network) {
        boolean replace = false;
        ContentNetworkManagerImpl contentNetworkManagerImpl = this;
        synchronized (contentNetworkManagerImpl) {
            for (ContentNetworkImpl existing_network : this.networks) {
                if (existing_network.getID() != network.getID()) continue;
                if (network.getVersion() > existing_network.getVersion()) {
                    try {
                        existing_network.updateFrom(network);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    network = existing_network;
                    replace = true;
                    break;
                }
                ContentNetworkManagerImpl.log("Network " + existing_network.getString() + " already up to date");
                return existing_network;
            }
            if (replace) {
                ContentNetworkManagerImpl.log("Updated network: " + network.getString());
            } else {
                ContentNetworkManagerImpl.log("Added network: " + network.getString());
                this.networks.add(network);
            }
            if (network.getID() != 1L) {
                this.saveConfig();
            }
        }
        Iterator<ContentNetworkListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                if (replace) {
                    it.next().networkChanged(network);
                    continue;
                }
                it.next().networkAdded(network);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNetwork(ContentNetworkImpl network) {
        ContentNetworkManagerImpl contentNetworkManagerImpl = this;
        synchronized (contentNetworkManagerImpl) {
            if (!this.networks.remove(network)) {
                return;
            }
            network.destroy();
            this.saveConfig();
        }
        ContentNetworkManagerImpl.log("Removed network: " + network.getString());
        Iterator<ContentNetworkListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().networkRemoved(network);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void loadConfig() {
        Map map;
        List list;
        if (FileUtil.resilientConfigFileExists(CONFIG_FILE) && (list = (List)(map = FileUtil.readResilientConfigFile(CONFIG_FILE)).get("networks")) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Map cnet_map = (Map)list.get(i);
                try {
                    ContentNetworkImpl cn = ContentNetworkImpl.importFromBEncodedMapStatic(this, cnet_map);
                    if (cn.getID() == 1L) continue;
                    this.networks.add(cn);
                    continue;
                }
                catch (Throwable e) {
                    ContentNetworkManagerImpl.log("Failed to load " + cnet_map, e);
                }
            }
        }
    }

    protected void saveConfig() {
        HashMap map = new HashMap();
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        map.put("networks", list);
        for (ContentNetworkImpl network : this.networks) {
            if (network.getID() == 1L) continue;
            HashMap<String, Object> cnet_map = new HashMap<String, Object>();
            try {
                network.exportToBEncodedMap(cnet_map);
                list.add(cnet_map);
            }
            catch (Throwable e) {
                ContentNetworkManagerImpl.log("Failed to save " + network.getName(), e);
            }
        }
        if (list.size() == 0) {
            FileUtil.deleteResilientConfigFile(CONFIG_FILE);
        } else {
            FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
        }
    }

    public void addListener(ContentNetworkListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ContentNetworkListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Content Networks");
        try {
            writer.indent();
            ContentNetworkManagerImpl contentNetworkManagerImpl = this;
            synchronized (contentNetworkManagerImpl) {
                for (ContentNetworkImpl network : this.networks) {
                    writer.println(network.getString());
                }
            }
            Object var7_6 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            writer.exdent();
            throw throwable;
        }
    }

    public static void log(String s, Throwable e) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("CNetworks");
        diag_logger.log(s);
        diag_logger.log(e);
    }

    public static void log(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("CNetworks");
        diag_logger.log(s);
    }
}

