/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  ggo --unamed-opts --no-handle-version --no-handle-error --file-name=cmd_cluster --func-name=cluster_cmdline_parser --arg-struct-name=cluster_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmd_cluster.h"

const char *cluster_args_info_purpose = "";

const char *cluster_args_info_usage = "Usage: \nsxadm cluster --new [options] NODE sx://[profile@]cluster\nsxadm cluster --modify [options] NODE [NODE ...] sx://[profile@]cluster\nsxadm cluster --lock sx://[profile@]cluster\nsxadm cluster --unlock sx://[profile@]cluster\nsxadm cluster --resize <+/->SIZE sx://[profile@]cluster\nsxadm cluster --replace-faulty [options] NODE [NODE ...] sx://[profile@]cluster\nsxadm cluster --list-nodes sx://[profile@]cluster\nsxadm cluster --set-mode=ro/rw sx://[profile@]cluster";

const char *cluster_args_info_versiontext = "";

const char *cluster_args_info_description = "";

const char *cluster_args_info_full_help[] = {
  "  -h, --help                  Print help and exit",
  "      --full-help             Print help, including hidden options, and exit",
  "  -V, --version               Print version and exit",
  "\n Group: MODE",
  "  -N, --new                   Create a new SX cluster with a local node",
  "  -M, --modify                Modify an existing SX cluster",
  "  -L, --lock                  Lock an SX cluster for changes",
  "  -U, --unlock                Unlock an SX cluster",
  "  -R, --resize=<+/->SIZE      Proportionally resize an existing SX cluster",
  "  -F, --replace-faulty        Replace faulty nodes in an existing SX cluster",
  "  -S, --set-faulty            Mark nodes of the cluster as faulty (without\n                                replacing them)",
  "  -I, --info                  Shows status and details of a running cluster",
  "  -G, --force-gc              Force a garbage collection cycle on all nodes",
  "  -X, --force-expire          Force GC and expiration of reservations on all\n                                nodes",
  "      --get-cluster-key       Obtain remote cluster key",
  "  -l, --list-nodes            List all nodes of the cluster and their current\n                                status",
  "  -m, --set-mode=MODE         Set cluster operating mode ('ro' or 'rw' for\n                                read-only or read-write respectively)",
  "      --upgrade               Check node versions and start cluster upgrade",
  "      --set-meta=STRING       Set cluster metadata ('key=value' entries are\n                                accepted)",
  "      --get-meta=KEY          Show cluster metadata (use ALL to show all\n                                entries)",
  "      --delete-meta=KEY       Delete cluster metadata entry",
  "\nNew cluster options:",
  "  -d, --node-dir=PATH         Path to the node directory",
  "      --port=INT              Set the cluster destination TCP port (default 443\n                                in secure mode or 80 in insecure mode)",
  "      --ssl-ca-file=PATH      SSL CA certificate file of the SX cluster (same\n                                file as in httpd configuration)",
  "  -k, --admin-key=PATH        File containing a pre-generated admin\n                                authentication token or stdin if \"-\" is given\n                                (default autogenerate token).",
  "\nCommon options:",
  "  -b, --batch-mode            Turn off interactive confirmations and assume yes\n                                for all questions",
  "  -H, --human-readable        Print human readable sizes  (default=off)",
  "  -D, --debug                 Enable debug messages  (default=off)",
  "  -c, --config-dir=PATH       Path to SX configuration directory",
  "\nCluster locking options:",
  "      --locking-node=ADDRESS  IP address of a node used to aqcuire cluster\n                                changes lock",
  "\nNODE definition is a string in the form\n<capacity>/<address>/[internal_address]/[node_uuid]\nExamples:\n\"100G/192.0.2.1\": 100 GiB node listening on address 192.0.2.1 with\nautomatically assigned uuid\n\"2T/192.0.2.2/198.51.100.1\": 2 TiB cluster using address 192.0.2.2 for public\naccess and address 198.51.100.1 for internal communication\n\"123gb/203.0.113.1//e4d2c9ea-b2b1-43c4-851d-39e86a7a377c\": 123 GiB cluster on\naddress 203.0.113.1 and uuid as specified",
    0
};

static void
init_help_array(void)
{
  cluster_args_info_help[0] = cluster_args_info_full_help[0];
  cluster_args_info_help[1] = cluster_args_info_full_help[1];
  cluster_args_info_help[2] = cluster_args_info_full_help[2];
  cluster_args_info_help[3] = cluster_args_info_full_help[3];
  cluster_args_info_help[4] = cluster_args_info_full_help[4];
  cluster_args_info_help[5] = cluster_args_info_full_help[5];
  cluster_args_info_help[6] = cluster_args_info_full_help[6];
  cluster_args_info_help[7] = cluster_args_info_full_help[7];
  cluster_args_info_help[8] = cluster_args_info_full_help[8];
  cluster_args_info_help[9] = cluster_args_info_full_help[9];
  cluster_args_info_help[10] = cluster_args_info_full_help[10];
  cluster_args_info_help[11] = cluster_args_info_full_help[11];
  cluster_args_info_help[12] = cluster_args_info_full_help[12];
  cluster_args_info_help[13] = cluster_args_info_full_help[13];
  cluster_args_info_help[14] = cluster_args_info_full_help[15];
  cluster_args_info_help[15] = cluster_args_info_full_help[16];
  cluster_args_info_help[16] = cluster_args_info_full_help[17];
  cluster_args_info_help[17] = cluster_args_info_full_help[18];
  cluster_args_info_help[18] = cluster_args_info_full_help[19];
  cluster_args_info_help[19] = cluster_args_info_full_help[20];
  cluster_args_info_help[20] = cluster_args_info_full_help[21];
  cluster_args_info_help[21] = cluster_args_info_full_help[22];
  cluster_args_info_help[22] = cluster_args_info_full_help[23];
  cluster_args_info_help[23] = cluster_args_info_full_help[24];
  cluster_args_info_help[24] = cluster_args_info_full_help[26];
  cluster_args_info_help[25] = cluster_args_info_full_help[27];
  cluster_args_info_help[26] = cluster_args_info_full_help[28];
  cluster_args_info_help[27] = cluster_args_info_full_help[29];
  cluster_args_info_help[28] = cluster_args_info_full_help[31];
  cluster_args_info_help[29] = cluster_args_info_full_help[33];
  cluster_args_info_help[30] = 0; 
  
}

const char *cluster_args_info_help[31];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
} cluster_cmdline_parser_arg_type;

static
void clear_given (struct cluster_args_info *args_info);
static
void clear_args (struct cluster_args_info *args_info);

static int
cluster_cmdline_parser_internal (int argc, char **argv, struct cluster_args_info *args_info,
                        struct cluster_cmdline_parser_params *params, const char *additional_error);

static int
cluster_cmdline_parser_required2 (struct cluster_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct cluster_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->new_given = 0 ;
  args_info->modify_given = 0 ;
  args_info->lock_given = 0 ;
  args_info->unlock_given = 0 ;
  args_info->resize_given = 0 ;
  args_info->replace_faulty_given = 0 ;
  args_info->set_faulty_given = 0 ;
  args_info->info_given = 0 ;
  args_info->force_gc_given = 0 ;
  args_info->force_expire_given = 0 ;
  args_info->get_cluster_key_given = 0 ;
  args_info->list_nodes_given = 0 ;
  args_info->set_mode_given = 0 ;
  args_info->upgrade_given = 0 ;
  args_info->set_meta_given = 0 ; args_info->set_meta_group = 0 ;
  args_info->get_meta_given = 0 ;
  args_info->delete_meta_given = 0 ;
  args_info->node_dir_given = 0 ;
  args_info->port_given = 0 ;
  args_info->ssl_ca_file_given = 0 ;
  args_info->admin_key_given = 0 ;
  args_info->batch_mode_given = 0 ;
  args_info->human_readable_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->config_dir_given = 0 ;
  args_info->locking_node_given = 0 ;
  args_info->MODE_group_counter = 0 ;
}

static
void clear_args (struct cluster_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->resize_arg = NULL;
  args_info->resize_orig = NULL;
  args_info->set_mode_arg = NULL;
  args_info->set_mode_orig = NULL;
  args_info->set_meta_arg = NULL;
  args_info->set_meta_orig = NULL;
  args_info->get_meta_arg = NULL;
  args_info->get_meta_orig = NULL;
  args_info->delete_meta_arg = NULL;
  args_info->delete_meta_orig = NULL;
  args_info->node_dir_arg = NULL;
  args_info->node_dir_orig = NULL;
  args_info->port_orig = NULL;
  args_info->ssl_ca_file_arg = NULL;
  args_info->ssl_ca_file_orig = NULL;
  args_info->admin_key_arg = NULL;
  args_info->admin_key_orig = NULL;
  args_info->human_readable_flag = 0;
  args_info->debug_flag = 0;
  args_info->config_dir_arg = NULL;
  args_info->config_dir_orig = NULL;
  args_info->locking_node_arg = NULL;
  args_info->locking_node_orig = NULL;
  
}

static
void init_args_info(struct cluster_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = cluster_args_info_full_help[0] ;
  args_info->full_help_help = cluster_args_info_full_help[1] ;
  args_info->version_help = cluster_args_info_full_help[2] ;
  args_info->new_help = cluster_args_info_full_help[4] ;
  args_info->modify_help = cluster_args_info_full_help[5] ;
  args_info->lock_help = cluster_args_info_full_help[6] ;
  args_info->unlock_help = cluster_args_info_full_help[7] ;
  args_info->resize_help = cluster_args_info_full_help[8] ;
  args_info->replace_faulty_help = cluster_args_info_full_help[9] ;
  args_info->set_faulty_help = cluster_args_info_full_help[10] ;
  args_info->info_help = cluster_args_info_full_help[11] ;
  args_info->force_gc_help = cluster_args_info_full_help[12] ;
  args_info->force_expire_help = cluster_args_info_full_help[13] ;
  args_info->get_cluster_key_help = cluster_args_info_full_help[14] ;
  args_info->list_nodes_help = cluster_args_info_full_help[15] ;
  args_info->set_mode_help = cluster_args_info_full_help[16] ;
  args_info->upgrade_help = cluster_args_info_full_help[17] ;
  args_info->set_meta_help = cluster_args_info_full_help[18] ;
  args_info->set_meta_min = 0;
  args_info->set_meta_max = 0;
  args_info->get_meta_help = cluster_args_info_full_help[19] ;
  args_info->delete_meta_help = cluster_args_info_full_help[20] ;
  args_info->node_dir_help = cluster_args_info_full_help[22] ;
  args_info->port_help = cluster_args_info_full_help[23] ;
  args_info->ssl_ca_file_help = cluster_args_info_full_help[24] ;
  args_info->admin_key_help = cluster_args_info_full_help[25] ;
  args_info->batch_mode_help = cluster_args_info_full_help[27] ;
  args_info->human_readable_help = cluster_args_info_full_help[28] ;
  args_info->debug_help = cluster_args_info_full_help[29] ;
  args_info->config_dir_help = cluster_args_info_full_help[30] ;
  args_info->locking_node_help = cluster_args_info_full_help[32] ;
  
}

void
cluster_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CLUSTER_CMDLINE_PARSER_PACKAGE_NAME) ? CLUSTER_CMDLINE_PARSER_PACKAGE_NAME : CLUSTER_CMDLINE_PARSER_PACKAGE),
     CLUSTER_CMDLINE_PARSER_VERSION);

  if (strlen(cluster_args_info_versiontext) > 0)
    printf("\n%s\n", cluster_args_info_versiontext);
}

static void print_help_common(void) {
  cluster_cmdline_parser_print_version ();

  if (strlen(cluster_args_info_purpose) > 0)
    printf("\n%s\n", cluster_args_info_purpose);

  if (strlen(cluster_args_info_usage) > 0)
    printf("\n%s\n", cluster_args_info_usage);

  printf("\n");

  if (strlen(cluster_args_info_description) > 0)
    printf("%s\n\n", cluster_args_info_description);
}

void
cluster_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (cluster_args_info_help[i])
    printf("%s\n", cluster_args_info_help[i++]);
}

void
cluster_cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (cluster_args_info_full_help[i])
    printf("%s\n", cluster_args_info_full_help[i++]);
}

void
cluster_cmdline_parser_init (struct cluster_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cluster_cmdline_parser_params_init(struct cluster_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cluster_cmdline_parser_params *
cluster_cmdline_parser_params_create(void)
{
  struct cluster_cmdline_parser_params *params = 
    (struct cluster_cmdline_parser_params *)malloc(sizeof(struct cluster_cmdline_parser_params));
  cluster_cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cluster_cmdline_parser_release (struct cluster_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->resize_arg));
  free_string_field (&(args_info->resize_orig));
  free_string_field (&(args_info->set_mode_arg));
  free_string_field (&(args_info->set_mode_orig));
  free_multiple_string_field (args_info->set_meta_given, &(args_info->set_meta_arg), &(args_info->set_meta_orig));
  free_string_field (&(args_info->get_meta_arg));
  free_string_field (&(args_info->get_meta_orig));
  free_string_field (&(args_info->delete_meta_arg));
  free_string_field (&(args_info->delete_meta_orig));
  free_string_field (&(args_info->node_dir_arg));
  free_string_field (&(args_info->node_dir_orig));
  free_string_field (&(args_info->port_orig));
  free_string_field (&(args_info->ssl_ca_file_arg));
  free_string_field (&(args_info->ssl_ca_file_orig));
  free_string_field (&(args_info->admin_key_arg));
  free_string_field (&(args_info->admin_key_orig));
  free_string_field (&(args_info->config_dir_arg));
  free_string_field (&(args_info->config_dir_orig));
  free_string_field (&(args_info->locking_node_arg));
  free_string_field (&(args_info->locking_node_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cluster_cmdline_parser_dump(FILE *outfile, struct cluster_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CLUSTER_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->new_given)
    write_into_file(outfile, "new", 0, 0 );
  if (args_info->modify_given)
    write_into_file(outfile, "modify", 0, 0 );
  if (args_info->lock_given)
    write_into_file(outfile, "lock", 0, 0 );
  if (args_info->unlock_given)
    write_into_file(outfile, "unlock", 0, 0 );
  if (args_info->resize_given)
    write_into_file(outfile, "resize", args_info->resize_orig, 0);
  if (args_info->replace_faulty_given)
    write_into_file(outfile, "replace-faulty", 0, 0 );
  if (args_info->set_faulty_given)
    write_into_file(outfile, "set-faulty", 0, 0 );
  if (args_info->info_given)
    write_into_file(outfile, "info", 0, 0 );
  if (args_info->force_gc_given)
    write_into_file(outfile, "force-gc", 0, 0 );
  if (args_info->force_expire_given)
    write_into_file(outfile, "force-expire", 0, 0 );
  if (args_info->get_cluster_key_given)
    write_into_file(outfile, "get-cluster-key", 0, 0 );
  if (args_info->list_nodes_given)
    write_into_file(outfile, "list-nodes", 0, 0 );
  if (args_info->set_mode_given)
    write_into_file(outfile, "set-mode", args_info->set_mode_orig, 0);
  if (args_info->upgrade_given)
    write_into_file(outfile, "upgrade", 0, 0 );
  write_multiple_into_file(outfile, args_info->set_meta_given, "set-meta", args_info->set_meta_orig, 0);
  if (args_info->get_meta_given)
    write_into_file(outfile, "get-meta", args_info->get_meta_orig, 0);
  if (args_info->delete_meta_given)
    write_into_file(outfile, "delete-meta", args_info->delete_meta_orig, 0);
  if (args_info->node_dir_given)
    write_into_file(outfile, "node-dir", args_info->node_dir_orig, 0);
  if (args_info->port_given)
    write_into_file(outfile, "port", args_info->port_orig, 0);
  if (args_info->ssl_ca_file_given)
    write_into_file(outfile, "ssl-ca-file", args_info->ssl_ca_file_orig, 0);
  if (args_info->admin_key_given)
    write_into_file(outfile, "admin-key", args_info->admin_key_orig, 0);
  if (args_info->batch_mode_given)
    write_into_file(outfile, "batch-mode", 0, 0 );
  if (args_info->human_readable_given)
    write_into_file(outfile, "human-readable", 0, 0 );
  if (args_info->debug_given)
    write_into_file(outfile, "debug", 0, 0 );
  if (args_info->config_dir_given)
    write_into_file(outfile, "config-dir", args_info->config_dir_orig, 0);
  if (args_info->locking_node_given)
    write_into_file(outfile, "locking-node", args_info->locking_node_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cluster_cmdline_parser_file_save(const char *filename, struct cluster_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CLUSTER_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cluster_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cluster_cmdline_parser_free (struct cluster_args_info *args_info)
{
  cluster_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
static void
reset_group_MODE(struct cluster_args_info *args_info)
{
  if (! args_info->MODE_group_counter)
    return;
  
  args_info->new_given = 0 ;
  args_info->modify_given = 0 ;
  args_info->lock_given = 0 ;
  args_info->unlock_given = 0 ;
  args_info->resize_given = 0 ;
  free_string_field (&(args_info->resize_arg));
  free_string_field (&(args_info->resize_orig));
  args_info->replace_faulty_given = 0 ;
  args_info->set_faulty_given = 0 ;
  args_info->info_given = 0 ;
  args_info->force_gc_given = 0 ;
  args_info->force_expire_given = 0 ;
  args_info->get_cluster_key_given = 0 ;
  args_info->list_nodes_given = 0 ;
  args_info->set_mode_given = 0 ;
  free_string_field (&(args_info->set_mode_arg));
  free_string_field (&(args_info->set_mode_orig));
  args_info->upgrade_given = 0 ;
  args_info->set_meta_given = 0 ; args_info->set_meta_group = 0 ;
  free_multiple_string_field (args_info->set_meta_given, &(args_info->set_meta_arg), &(args_info->set_meta_orig));
  args_info->get_meta_given = 0 ;
  free_string_field (&(args_info->get_meta_arg));
  free_string_field (&(args_info->get_meta_orig));
  args_info->delete_meta_given = 0 ;
  free_string_field (&(args_info->delete_meta_arg));
  free_string_field (&(args_info->delete_meta_orig));

  args_info->MODE_group_counter = 0;
}

int
cluster_cmdline_parser (int argc, char **argv, struct cluster_args_info *args_info)
{
  return cluster_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cluster_cmdline_parser_ext (int argc, char **argv, struct cluster_args_info *args_info,
                   struct cluster_cmdline_parser_params *params)
{
  int result;
  result = cluster_cmdline_parser_internal (argc, argv, args_info, params, 0);

  return result;
}

int
cluster_cmdline_parser2 (int argc, char **argv, struct cluster_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cluster_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cluster_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  return result;
}

int
cluster_cmdline_parser_required (struct cluster_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cluster_cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  return result;
}

int
cluster_cmdline_parser_required2 (struct cluster_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->set_meta_given, args_info->set_meta_min, args_info->set_meta_max, "'--set-meta'"))
     error_occurred = 1;
  
  if (args_info->MODE_group_counter == 0)
    {
      fprintf (stderr, "%s: %d options of group MODE were given. One is required%s.\n", prog_name, args_info->MODE_group_counter, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  

  /* checks for dependences among options */
  if (args_info->new_given && ! args_info->node_dir_given)
    {
      fprintf (stderr, "%s: '--new' ('-N') option depends on option 'node-dir'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->node_dir_given && ! args_info->new_given)
    {
      fprintf (stderr, "%s: '--node-dir' ('-d') option depends on option 'new'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->port_given && ! args_info->new_given)
    {
      fprintf (stderr, "%s: '--port' option depends on option 'new'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->ssl_ca_file_given && ! args_info->new_given)
    {
      fprintf (stderr, "%s: '--ssl-ca-file' option depends on option 'new'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->admin_key_given && ! args_info->new_given)
    {
      fprintf (stderr, "%s: '--admin-key' ('-k') option depends on option 'new'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->locking_node_given && ! args_info->lock_given)
    {
      fprintf (stderr, "%s: '--locking-node' option depends on option 'lock'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cluster_cmdline_parser_params.check_ambiguity
 * @param override @see cluster_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cluster_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cluster_cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cluster_cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cluster_cmdline_parser_internal (
  int argc, char **argv, struct cluster_args_info *args_info,
                        struct cluster_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * set_meta_list = NULL;
  int error_occurred = 0;
  struct cluster_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cluster_cmdline_parser_init (args_info);

  cluster_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "new",	0, NULL, 'N' },
        { "modify",	0, NULL, 'M' },
        { "lock",	0, NULL, 'L' },
        { "unlock",	0, NULL, 'U' },
        { "resize",	1, NULL, 'R' },
        { "replace-faulty",	0, NULL, 'F' },
        { "set-faulty",	0, NULL, 'S' },
        { "info",	0, NULL, 'I' },
        { "force-gc",	0, NULL, 'G' },
        { "force-expire",	0, NULL, 'X' },
        { "get-cluster-key",	0, NULL, 0 },
        { "list-nodes",	0, NULL, 'l' },
        { "set-mode",	1, NULL, 'm' },
        { "upgrade",	0, NULL, 0 },
        { "set-meta",	1, NULL, 0 },
        { "get-meta",	1, NULL, 0 },
        { "delete-meta",	1, NULL, 0 },
        { "node-dir",	1, NULL, 'd' },
        { "port",	1, NULL, 0 },
        { "ssl-ca-file",	1, NULL, 0 },
        { "admin-key",	1, NULL, 'k' },
        { "batch-mode",	0, NULL, 'b' },
        { "human-readable",	0, NULL, 'H' },
        { "debug",	0, NULL, 'D' },
        { "config-dir",	1, NULL, 'c' },
        { "locking-node",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVNMLUR:FSIGXlm:d:k:bHDc:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cluster_cmdline_parser_print_help ();
          cluster_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'V',
              additional_error))
            goto failure;
          cluster_cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'N':	/* Create a new SX cluster with a local node.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->new_given),
              &(local_args_info.new_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "new", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'M':	/* Modify an existing SX cluster.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->modify_given),
              &(local_args_info.modify_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "modify", 'M',
              additional_error))
            goto failure;
        
          break;
        case 'L':	/* Lock an SX cluster for changes.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->lock_given),
              &(local_args_info.lock_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "lock", 'L',
              additional_error))
            goto failure;
        
          break;
        case 'U':	/* Unlock an SX cluster.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->unlock_given),
              &(local_args_info.unlock_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "unlock", 'U',
              additional_error))
            goto failure;
        
          break;
        case 'R':	/* Proportionally resize an existing SX cluster.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( (void *)&(args_info->resize_arg), 
               &(args_info->resize_orig), &(args_info->resize_given),
              &(local_args_info.resize_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "resize", 'R',
              additional_error))
            goto failure;
        
          break;
        case 'F':	/* Replace faulty nodes in an existing SX cluster.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->replace_faulty_given),
              &(local_args_info.replace_faulty_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "replace-faulty", 'F',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* Mark nodes of the cluster as faulty (without replacing them).  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->set_faulty_given),
              &(local_args_info.set_faulty_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "set-faulty", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'I':	/* Shows status and details of a running cluster.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->info_given),
              &(local_args_info.info_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "info", 'I',
              additional_error))
            goto failure;
        
          break;
        case 'G':	/* Force a garbage collection cycle on all nodes.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->force_gc_given),
              &(local_args_info.force_gc_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "force-gc", 'G',
              additional_error))
            goto failure;
        
          break;
        case 'X':	/* Force GC and expiration of reservations on all nodes.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->force_expire_given),
              &(local_args_info.force_expire_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "force-expire", 'X',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* List all nodes of the cluster and their current status.  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->list_nodes_given),
              &(local_args_info.list_nodes_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "list-nodes", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Set cluster operating mode ('ro' or 'rw' for read-only or read-write respectively).  */
        
          if (args_info->MODE_group_counter && override)
            reset_group_MODE (args_info);
          args_info->MODE_group_counter += 1;
        
          if (update_arg( (void *)&(args_info->set_mode_arg), 
               &(args_info->set_mode_orig), &(args_info->set_mode_given),
              &(local_args_info.set_mode_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "set-mode", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* Path to the node directory.  */
        
        
          if (update_arg( (void *)&(args_info->node_dir_arg), 
               &(args_info->node_dir_orig), &(args_info->node_dir_given),
              &(local_args_info.node_dir_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "node-dir", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'k':	/* File containing a pre-generated admin authentication token or stdin if \"-\" is given (default autogenerate token)..  */
        
        
          if (update_arg( (void *)&(args_info->admin_key_arg), 
               &(args_info->admin_key_orig), &(args_info->admin_key_given),
              &(local_args_info.admin_key_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "admin-key", 'k',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* Turn off interactive confirmations and assume yes for all questions.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->batch_mode_given),
              &(local_args_info.batch_mode_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "batch-mode", 'b',
              additional_error))
            goto failure;
        
          break;
        case 'H':	/* Print human readable sizes.  */
        
        
          if (update_arg((void *)&(args_info->human_readable_flag), 0, &(args_info->human_readable_given),
              &(local_args_info.human_readable_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "human-readable", 'H',
              additional_error))
            goto failure;
        
          break;
        case 'D':	/* Enable debug messages.  */
        
        
          if (update_arg((void *)&(args_info->debug_flag), 0, &(args_info->debug_given),
              &(local_args_info.debug_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "debug", 'D',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Path to SX configuration directory.  */
        
        
          if (update_arg( (void *)&(args_info->config_dir_arg), 
               &(args_info->config_dir_orig), &(args_info->config_dir_given),
              &(local_args_info.config_dir_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "config-dir", 'c',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cluster_cmdline_parser_print_full_help ();
            cluster_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Obtain remote cluster key.  */
          if (strcmp (long_options[option_index].name, "get-cluster-key") == 0)
          {
          
            if (args_info->MODE_group_counter && override)
              reset_group_MODE (args_info);
            args_info->MODE_group_counter += 1;
          
            if (update_arg( 0 , 
                 0 , &(args_info->get_cluster_key_given),
                &(local_args_info.get_cluster_key_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "get-cluster-key", '-',
                additional_error))
              goto failure;
          
          }
          /* Check node versions and start cluster upgrade.  */
          else if (strcmp (long_options[option_index].name, "upgrade") == 0)
          {
          
            if (args_info->MODE_group_counter && override)
              reset_group_MODE (args_info);
            args_info->MODE_group_counter += 1;
          
            if (update_arg( 0 , 
                 0 , &(args_info->upgrade_given),
                &(local_args_info.upgrade_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "upgrade", '-',
                additional_error))
              goto failure;
          
          }
          /* Set cluster metadata ('key=value' entries are accepted).  */
          else if (strcmp (long_options[option_index].name, "set-meta") == 0)
          {
          
            if (update_multiple_arg_temp(&set_meta_list, 
                &(local_args_info.set_meta_given), optarg, 0, 0, ARG_STRING,
                "set-meta", '-',
                additional_error))
              goto failure;
            if (!args_info->set_meta_group)
              {
                args_info->set_meta_group = 1;
                args_info->MODE_group_counter += 1;
              }
          
          }
          /* Show cluster metadata (use ALL to show all entries).  */
          else if (strcmp (long_options[option_index].name, "get-meta") == 0)
          {
          
            if (args_info->MODE_group_counter && override)
              reset_group_MODE (args_info);
            args_info->MODE_group_counter += 1;
          
            if (update_arg( (void *)&(args_info->get_meta_arg), 
                 &(args_info->get_meta_orig), &(args_info->get_meta_given),
                &(local_args_info.get_meta_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "get-meta", '-',
                additional_error))
              goto failure;
          
          }
          /* Delete cluster metadata entry.  */
          else if (strcmp (long_options[option_index].name, "delete-meta") == 0)
          {
          
            if (args_info->MODE_group_counter && override)
              reset_group_MODE (args_info);
            args_info->MODE_group_counter += 1;
          
            if (update_arg( (void *)&(args_info->delete_meta_arg), 
                 &(args_info->delete_meta_orig), &(args_info->delete_meta_given),
                &(local_args_info.delete_meta_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "delete-meta", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the cluster destination TCP port (default 443 in secure mode or 80 in insecure mode).  */
          else if (strcmp (long_options[option_index].name, "port") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->port_arg), 
                 &(args_info->port_orig), &(args_info->port_given),
                &(local_args_info.port_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "port", '-',
                additional_error))
              goto failure;
          
          }
          /* SSL CA certificate file of the SX cluster (same file as in httpd configuration).  */
          else if (strcmp (long_options[option_index].name, "ssl-ca-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ssl_ca_file_arg), 
                 &(args_info->ssl_ca_file_orig), &(args_info->ssl_ca_file_given),
                &(local_args_info.ssl_ca_file_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "ssl-ca-file", '-',
                additional_error))
              goto failure;
          
          }
          /* IP address of a node used to aqcuire cluster changes lock.  */
          else if (strcmp (long_options[option_index].name, "locking-node") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->locking_node_arg), 
                 &(args_info->locking_node_orig), &(args_info->locking_node_given),
                &(local_args_info.locking_node_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "locking-node", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CLUSTER_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */

  if (args_info->MODE_group_counter > 1)
    {
      fprintf (stderr, "%s: %d options of group MODE were given. One is required%s.\n", argv[0], args_info->MODE_group_counter, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  

  update_multiple_arg((void *)&(args_info->set_meta_arg),
    &(args_info->set_meta_orig), args_info->set_meta_given,
    local_args_info.set_meta_given, 0,
    ARG_STRING, set_meta_list);

  args_info->set_meta_given += local_args_info.set_meta_given;
  local_args_info.set_meta_given = 0;
  
  if (check_required)
    {
      error_occurred += cluster_cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cluster_cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  free_list (set_meta_list, 1 );
  
  cluster_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
