/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.NumericTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

class ProxyDialog
extends JDialog
implements ActionListener {
    protected static final int RADIO_BUTTON_WIDTH = new JRadioButton((String)"").getPreferredSize().width + 1;
    private JRadioButton rdoConnectionDirect;
    private JRadioButton rdoConnectionProxy;
    private JTextField txtHost;
    private NumericTextField txtPort;
    private JCheckBox chkAuth;
    private JTextField txtAuthUser;
    private JTextField txtAuthPassword;
    private JLabel lblHost;
    private JLabel lblPort;
    private JLabel lblUser;
    private JLabel lblPassword;
    private JButton btnOK;
    private JButton btnCancel;
    private boolean canceled = true;
    private static final int WIDTH = 420;
    private static final int HEIGHT = 350;
    private ProxyConfig proxyConfig;

    public ProxyDialog(ProxyConfig proxyConfig) {
        super((Frame)GUIHelper.getParentWindow(), Messages.getMessages().getString("InternetConnection"), true);
        this.proxyConfig = proxyConfig;
        this.initScreen();
    }

    private void initScreen() {
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
        this.setBounds(this.getFrameBounds());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void show() {
        this.canceled = true;
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.rdoConnectionDirect || object == this.rdoConnectionProxy || object == this.chkAuth) {
            this.checkEnabled();
        } else if (object == this.btnOK) {
            if (this.checkProxySettings()) {
                this.proxyConfig.setProxySet(this.rdoConnectionProxy.isSelected());
                this.proxyConfig.setAuth(this.chkAuth.isSelected());
                this.proxyConfig.setAuthPassword(this.txtAuthPassword.getText());
                this.proxyConfig.setAuthUser(this.txtAuthUser.getText());
                this.proxyConfig.setPort(this.txtPort.getText());
                this.proxyConfig.setHost(this.txtHost.getText());
                this.canceled = false;
                this.hide();
            }
        } else if (object == this.btnCancel) {
            this.hide();
        }
    }

    private void setupControls() {
        this.btnOK = new JButton(Messages.getMessages().getString("ButtonOK"));
        this.btnCancel = new JButton(Messages.getMessages().getString("ButtonCancel"));
        this.rdoConnectionDirect = new JRadioButton(" " + Messages.getMessages().getString("DirectConnection"), !this.proxyConfig.isProxySet());
        this.rdoConnectionProxy = new JRadioButton(" " + Messages.getMessages().getString("ProxyConnection"), this.proxyConfig.isProxySet());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rdoConnectionDirect);
        buttonGroup.add(this.rdoConnectionProxy);
        this.txtHost = new JTextField(this.proxyConfig.getHost());
        this.txtPort = new NumericTextField(this.proxyConfig.getPort(), 5);
        this.chkAuth = new JCheckBox(Messages.getMessages().getString("ProxyAuthentication"), this.proxyConfig.isAuth());
        this.txtAuthUser = new JTextField(this.proxyConfig.getAuthUser(), 15);
        this.txtAuthPassword = new JPasswordField(this.proxyConfig.getAuthPassword(), 15);
        this.lblHost = new JLabel(Messages.getMessages().getString("ProxyHost") + ":");
        this.lblPort = new JLabel(Messages.getMessages().getString("ProxyPort") + ":");
        this.lblUser = new JLabel(Messages.getMessages().getString("UserName") + ":");
        this.lblPassword = new JLabel(Messages.getMessages().getString("Password") + ":");
        this.checkEnabled();
    }

    private void setupEventHandlers() {
        this.rdoConnectionDirect.addActionListener(this);
        this.rdoConnectionProxy.addActionListener(this);
        this.chkAuth.addActionListener(this);
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.txtPort.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                int n = 0;
                try {
                    n = Integer.parseInt(ProxyDialog.this.txtPort.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n < 1 || n > 65536) {
                    GUIHelper.showMessage(ProxyDialog.this.getOwner(), Messages.getMessages().getString("PortValueError"), 0);
                    ProxyDialog.this.txtPort.setText("80");
                }
            }
        });
    }

    private void setupComponent() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.addScreenContent(jPanel);
        container.add((Component)jPanel, "North");
        container.add((Component)this.createButtonBox(), "South");
    }

    protected JPanel createButtonBox() {
        Box box = ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnOK, this.btnCancel}, 0);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(box);
        box2.add(Box.createHorizontalGlue());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)box2, "Center");
        return jPanel;
    }

    private void addScreenContent(Container container) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        container.add((Component)new JLabel(Messages.getMessages().getString("DownloadError")), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        ++gridBagConstraints.gridy;
        container.add((Component)new JLabel(Messages.getMessages().getString("ConnectionParametersRequest")), gridBagConstraints);
        gridBagConstraints.insets.top = 10;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        container.add((Component)this.rdoConnectionDirect, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        container.add((Component)this.rdoConnectionProxy, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.insets.left += RADIO_BUTTON_WIDTH;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        container.add((Component)this.createProxySettingsPanel(), gridBagConstraints);
    }

    private JPanel createProxySettingsPanel() {
        JPanel jPanel = this.createBorderPanel(Messages.getMessages().getString("ProxySettings"), new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel.add((Component)this.lblHost, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.lblPort, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.chkAuth, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left += RADIO_BUTTON_WIDTH;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.lblUser, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.lblPassword, gridBagConstraints);
        gridBagConstraints.insets.left -= RADIO_BUTTON_WIDTH;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.txtHost, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.txtPort, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.txtAuthUser, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.txtAuthPassword, gridBagConstraints);
        return jPanel;
    }

    private void checkEnabled() {
        boolean bl = this.rdoConnectionProxy.isSelected();
        this.txtHost.setEnabled(bl);
        this.txtPort.setEnabled(bl);
        this.chkAuth.setEnabled(bl);
        this.lblHost.setEnabled(bl);
        this.lblPort.setEnabled(bl);
        bl = bl && this.chkAuth.isSelected();
        this.txtAuthUser.setEnabled(bl);
        this.lblUser.setEnabled(bl);
        this.txtAuthPassword.setEnabled(bl);
        this.lblPassword.setEnabled(bl);
    }

    private boolean checkProxySettings() {
        return this.rdoConnectionDirect.isSelected() || this.checkTextField(this.txtHost) && (!this.chkAuth.isSelected() || this.checkTextField(this.txtAuthUser) && this.checkTextField(this.txtAuthPassword));
    }

    private boolean checkTextField(JTextComponent jTextComponent) {
        if (jTextComponent.getText().trim().length() == 0) {
            this.showMissingMessage(jTextComponent);
            return false;
        }
        return true;
    }

    private void showMissingMessage(JComponent jComponent) {
        GUIHelper.showMessage(this.getOwner(), Messages.getMessages().getString("EnterInformation"), 2);
        jComponent.requestFocus();
    }

    private JPanel createBorderPanel(String string, LayoutManager layoutManager) {
        return this.createBorderPanel(string, layoutManager, 0);
    }

    private JPanel createBorderPanel(String string, LayoutManager layoutManager, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(n, n, n, n)));
        if (layoutManager != null) {
            jPanel.setLayout(layoutManager);
        }
        return jPanel;
    }

    public Rectangle getFrameBounds() {
        Window window = this.getOwner();
        Rectangle rectangle = window != null && window.isVisible() ? window.getBounds() : new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
        float f = 1.0f;
        if (Util.isLinux() || Util.isSolaris()) {
            f = 1.2f;
        }
        int n = (int)(f * 420.0f);
        int n2 = (int)(f * 350.0f);
        if (n < 0 || n2 < 0) {
            this.pack();
            if (n < 0) {
                n = Math.max(-n, this.getWidth());
            }
            if (n2 < 0) {
                n2 = Math.max(-n2, this.getHeight());
            }
        }
        int n3 = rectangle.width - n;
        int n4 = rectangle.height - n2;
        rectangle.x += n3 / 2;
        rectangle.width -= n3;
        rectangle.y += n4 / 2;
        rectangle.height -= n4;
        if (rectangle.x < 0) {
            rectangle.translate(-rectangle.x, 0);
        }
        if (rectangle.y < 0) {
            rectangle.translate(0, -rectangle.y);
        }
        return rectangle;
    }
}

