/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.AbstractFileSelector;
import com.install4j.runtime.util.MultiFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileSelector
extends JPanel
implements AbstractFileSelector {
    private JTextField txtFile;
    private JButton btnBrowse;
    private JFileChooser fileChooser;
    private String fileFilterName;
    private String[] filteredExtensions;
    private boolean designTime;

    public FileSelector(String string, String[] stringArray, boolean bl) {
        this.fileFilterName = string;
        this.filteredExtensions = stringArray;
        this.designTime = bl;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void setEnabled(boolean bl) {
        this.txtFile.setEnabled(bl);
        this.btnBrowse.setEnabled(bl);
    }

    public void initFile(String string) {
        this.txtFile.setText(string);
    }

    public void setSelectedFile(File file) {
        this.initFile(file.getPath());
    }

    public File getSelectedFile() {
        return new File(this.txtFile.getText().trim());
    }

    public void focusTextField() {
        this.txtFile.requestFocus();
        this.txtFile.setSelectionStart(0);
        this.txtFile.setSelectionEnd(this.txtFile.getDocument().getLength());
    }

    public JTextField getTextField() {
        return this.txtFile;
    }

    public JButton getButton() {
        return this.btnBrowse;
    }

    private void setupControls() {
        this.txtFile = new JTextField(" ");
        this.btnBrowse = new JButton(this.designTime ? "Browse ... " : Messages.getMessages().getString("ButtonBrowse"));
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtFile, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        this.add((Component)this.btnBrowse, gridBagConstraints);
    }

    private void setupEventHandlers() {
        if (this.designTime) {
            return;
        }
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSelector.this.doBrowse();
            }
        });
    }

    private void doBrowse() {
        File file;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogType(2);
            if (this.filteredExtensions != null && this.fileFilterName.trim().length() > 0) {
                this.fileChooser.addChoosableFileFilter(new MultiFileFilter(this.filteredExtensions, this.fileFilterName));
            }
        }
        File file2 = new File(this.txtFile.getText());
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!(file2.exists() && file2.isDirectory() || (file = this.fileChooser.getFileSystemView().getParentDirectory(file2)) == null || file2.equals(file))) {
            file2 = file;
        }
        if (file2.exists() && file2.isDirectory()) {
            this.fileChooser.setCurrentDirectory(file2);
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.txtFile.setText(this.fileChooser.getSelectedFile().getPath());
        }
    }
}

