/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.fileinst;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long count = 0L;
    private ProgressListener progressListener;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public CountingOutputStream(OutputStream outputStream, ProgressListener progressListener) {
        super(outputStream);
        this.progressListener = progressListener;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        ++this.count;
        if (this.progressListener != null) {
            this.progressListener.progressPerformed(1);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.count += (long)n2;
        if (this.progressListener != null) {
            this.progressListener.progressPerformed(n2);
        }
    }

    public long getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0L;
    }

    public static interface ProgressListener {
        public void progressPerformed(int var1);
    }
}

