/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.install4j.api.actions.Action;
import com.install4j.api.beans.Bean;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.actions.misc.RequireAdminAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.GotoScreenCommand;
import com.install4j.runtime.installer.controller.LanguageSelector;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;

public class Controller {
    private ScreenExecutor screenExecutor;
    private ContextImpl context;
    private List startedActions = new ArrayList();
    private List screenConfigHistory = new ArrayList();

    public Controller(ScreenExecutor screenExecutor) {
        this.context = screenExecutor.getContext();
        this.screenExecutor = screenExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        InstallerUtil.registerStarted();
        InstallerVariables.setReplaceI18nVariables(true);
        InstallerUtil.setConsole(this.screenExecutor.isConsole());
        InstallerUtil.setUnattended(this.screenExecutor.isUnattended());
        LanguageSelector.initLanguage(this.context, this.screenExecutor);
        if (!this.context.checkStart()) {
            System.exit(1);
        }
        this.context.registerScreens(true);
        List list = this.getScreenConfigs();
        if (list.size() == 0) {
            return;
        }
        ScreenBeanConfig screenBeanConfig = this.handleStartup();
        while (screenBeanConfig != null) {
            CommandSink commandSink = new CommandSink(this);
            this.execute(screenBeanConfig, commandSink);
            CommandSink commandSink2 = commandSink;
            synchronized (commandSink2) {
                while (commandSink.getCommand() == null) {
                    try {
                        commandSink.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            if ((screenBeanConfig = this.handleCommand(commandSink, screenBeanConfig)) != null) continue;
            commandSink.finished();
        }
        System.exit(0);
    }

    private ScreenBeanConfig handleStartup() {
        ScreenBeanConfig screenBeanConfig = (ScreenBeanConfig)this.getScreenConfigs().get(0);
        CommandSink commandSink = new CommandSink(this);
        commandSink.returnToController(new GoForwardCommand(1, true, true));
        return this.handleCommand(commandSink, screenBeanConfig);
    }

    private void execute(final ScreenBeanConfig screenBeanConfig, final CommandSink commandSink) {
        this.screenConfigHistory.add(screenBeanConfig);
        ArrayList arrayList = new ArrayList();
        ScreenBeanConfig screenBeanConfig2 = this.findPreviousScreenConfig(false, arrayList);
        final boolean bl = screenBeanConfig2 != null && screenBeanConfig.getBackButtonType() != 3 && (screenBeanConfig.getBackButtonType() != 2 || screenBeanConfig2.getActionConfigs().size() == 0 && arrayList.size() == 0);
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        this.context.fireInstallerEvent(new InstallerEvent(screen, this.context, EventType.SHOW_SCREEN, true));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Controller.this.screenExecutor.execute(screenBeanConfig, commandSink, bl);
            }
        });
    }

    private ScreenBeanConfig handleCommand(CommandSink commandSink, ScreenBeanConfig screenBeanConfig) {
        ControllerCommand controllerCommand = commandSink.getCommand();
        if (controllerCommand instanceof GoForwardCommand && ((GoForwardCommand)controllerCommand).isExecuteActions() || controllerCommand == ControllerCommand.FINISH) {
            commandSink.allowOverride();
            try {
                this.executeActions(screenBeanConfig, screenBeanConfig.getOrInstantiateScreen(false));
            }
            catch (UserCanceledException userCanceledException) {
                this.rollback(commandSink);
            }
            controllerCommand = commandSink.getOverriddenCommand();
        }
        Logger.getInstance().info(screenBeanConfig.getOrInstantiateScreen(false), "command: " + controllerCommand);
        if (controllerCommand instanceof GoForwardCommand) {
            GoForwardCommand goForwardCommand = (GoForwardCommand)controllerCommand;
            if (goForwardCommand.isCheckCondition()) {
                ScreenBeanConfig screenBeanConfig2 = this.findNextScreenConfig(screenBeanConfig, goForwardCommand.getNumber());
                if (screenBeanConfig2 == null) {
                    this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING, true));
                    commandSink.finished();
                    this.context.finish(0);
                }
                return screenBeanConfig2;
            }
            int n = this.getIndex(screenBeanConfig);
            return (ScreenBeanConfig)this.getScreenConfigs().get(n + goForwardCommand.getNumber());
        }
        if (controllerCommand instanceof GoBackCommand) {
            GoBackCommand goBackCommand = (GoBackCommand)controllerCommand;
            if (goBackCommand.isUseHistory()) {
                ScreenBeanConfig screenBeanConfig3 = null;
                for (int i = 0; i < goBackCommand.getNumber(); ++i) {
                    screenBeanConfig3 = this.findPreviousScreenConfig(true, null);
                }
                if (screenBeanConfig3 == null) {
                    throw new RuntimeException("Could not go back " + goBackCommand.getNumber() + " step in history from " + screenBeanConfig.getOrInstantiateScreen(true));
                }
                return screenBeanConfig3;
            }
            int n = this.getIndex(screenBeanConfig);
            return (ScreenBeanConfig)this.getScreenConfigs().get(n - goBackCommand.getNumber());
        }
        if (controllerCommand == ControllerCommand.FINISH) {
            this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING, true));
            commandSink.finished();
            this.context.finish(0);
            return null;
        }
        if (controllerCommand == ControllerCommand.CANCEL) {
            this.rollback(commandSink);
            return null;
        }
        if (controllerCommand instanceof GotoScreenCommand) {
            int n = this.getIndex(((GotoScreenCommand)controllerCommand).getScreen());
            return (ScreenBeanConfig)this.getScreenConfigs().get(n);
        }
        throw new RuntimeException("Unknown command " + controllerCommand.toString());
    }

    public void rollback(CommandSink commandSink) {
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELLING, true));
        if (this.startedActions.size() > 0) {
            ServiceHandler.resetStopState();
            this.context.setRollback();
            this.context.getProgressInterface().setDetailMessage("");
            this.context.getProgressInterface().setStatusMessage(Messages.getMessages().getString("StatusRollback"));
            for (int i = this.startedActions.size() - 1; i >= 0; --i) {
                Action action = (Action)this.startedActions.get(i);
                this.context.rollbackAction(action);
            }
            FileInstaller fileInstaller = FileInstaller.getInstance();
            if (fileInstaller.hasRollbackFiles()) {
                ServiceHandler.stopServices(this.context, true);
                fileInstaller.rollback(this.context.getProgressInterface());
            }
            if (fileInstaller.hasUnrollbackedFiles()) {
                this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED, true));
                commandSink.finished();
                this.context.finish(1);
            }
        }
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED, true));
        commandSink.finished();
        this.context.exit(1);
    }

    private void executeActions(ScreenBeanConfig screenBeanConfig, Screen screen) throws UserCanceledException {
        List list = screenBeanConfig.getActionConfigs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ActionBeanConfig actionBeanConfig = (ActionBeanConfig)iterator.next();
            Action action = actionBeanConfig.getOrInstantiateAction(false);
            if (this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            if (!actionBeanConfig.isMultiExec() && actionBeanConfig.isExecuted() || !this.context.runBooleanScript(actionBeanConfig.getConditionClassName(), action)) continue;
            if (!actionBeanConfig.isExecuted() && !(action instanceof RequireAdminAction)) {
                this.startedActions.add(action);
            }
            actionBeanConfig.setExecuted(true);
            try {
                if (!this.context.performAction(action)) {
                    this.handleFailure(actionBeanConfig, action.getClass());
                }
            }
            catch (InstallerVariables.UndefinedVariableException undefinedVariableException) {
                Logger.getInstance().error(action, "undefined variable: " + undefinedVariableException.getMessage());
                this.handleFailure(actionBeanConfig, action.getClass());
            }
            this.checkRollbackBarrier(actionBeanConfig, action);
        }
        this.checkRollbackBarrier(screenBeanConfig, screen);
    }

    private void handleFailure(ActionBeanConfig actionBeanConfig, Class clazz) throws UserCanceledException {
        boolean bl;
        this.context.setErrorOccured(true);
        boolean bl2 = bl = actionBeanConfig.getFailureStrategy() == 2;
        if (bl || actionBeanConfig.getFailureStrategy() == 1) {
            String string = actionBeanConfig.getErrorMessage().trim();
            if (string.length() > 0) {
                GUIHelper.showMessage(null, string, bl ? 0 : 2);
            }
            if (bl) {
                this.quitAndKeepLogFile();
            }
        } else {
            ResourceBundle resourceBundle = Messages.getMessages();
            String string = actionBeanConfig.getErrorMessage().trim();
            if (string.length() == 0) {
                string = MessageFormat.format(resourceBundle.getString("ErrorFunctionFailedNoCode"), clazz.getName()) + "\n";
            }
            if (GUIHelper.showOptionDialog(null, string, new String[]{resourceBundle.getString("ButtonOK"), resourceBundle.getString("ButtonCancel")}, 0) == 1) {
                this.quitAndKeepLogFile();
            }
        }
    }

    private void quitAndKeepLogFile() throws UserCanceledException {
        System.setProperty("install4j.keepLog", "true");
        throw new UserCanceledException();
    }

    private void checkRollbackBarrier(AbstractBeanConfig abstractBeanConfig, Bean bean) {
        if (abstractBeanConfig.isRollbackBarrier()) {
            this.startedActions.clear();
            FileInstaller.getInstance().setRollbackBarrier();
            Logger.getInstance().info(bean, "Rollback barrier reached");
        }
    }

    private ScreenBeanConfig findNextScreenConfig(ScreenBeanConfig screenBeanConfig, int n) {
        List list = this.getScreenConfigs();
        int n2 = list.size();
        int n3 = -1;
        if (screenBeanConfig != null) {
            n3 = this.getIndex(screenBeanConfig);
        }
        n3 += n;
        while (n3 < n2) {
            ScreenBeanConfig screenBeanConfig2 = (ScreenBeanConfig)list.get(n3);
            Screen screen = screenBeanConfig2.getOrInstantiateScreen(false);
            if (!screen.isHidden() && !screen.isHiddenForNext() && this.context.runBooleanScript(screenBeanConfig2.getConditionClassName(), screen)) {
                return screenBeanConfig2;
            }
            ++n3;
        }
        return null;
    }

    private ScreenBeanConfig findPreviousScreenConfig(boolean bl, List list) {
        ScreenBeanConfig screenBeanConfig = null;
        int n = this.screenConfigHistory.size() - 2;
        if (bl) {
            this.screenConfigHistory.remove(this.screenConfigHistory.size() - 1);
        }
        while (n >= 0) {
            Screen screen;
            screenBeanConfig = (ScreenBeanConfig)this.screenConfigHistory.get(n);
            if (bl) {
                this.screenConfigHistory.remove(n);
            }
            if (!(screen = screenBeanConfig.getOrInstantiateScreen(false)).isHidden() && this.context.runBooleanScript(screenBeanConfig.getConditionClassName(), screen)) {
                if (!screen.isHiddenForPrevious()) break;
                if (list != null) {
                    list.addAll(screenBeanConfig.getActionConfigs());
                }
            }
            --n;
        }
        return screenBeanConfig;
    }

    private int getIndex(ScreenBeanConfig screenBeanConfig) {
        ListIterator listIterator = this.getScreenConfigs().listIterator();
        while (listIterator.hasNext()) {
            ScreenBeanConfig screenBeanConfig2 = (ScreenBeanConfig)listIterator.next();
            if (screenBeanConfig2 != screenBeanConfig) continue;
            return listIterator.previousIndex();
        }
        throw new RuntimeException("not in screen sequence; " + screenBeanConfig);
    }

    private int getIndex(Screen screen) {
        ListIterator listIterator = this.getScreenConfigs().listIterator();
        while (listIterator.hasNext()) {
            ScreenBeanConfig screenBeanConfig = (ScreenBeanConfig)listIterator.next();
            if (screenBeanConfig.getOrInstantiateScreen(false) != screen) continue;
            return listIterator.previousIndex();
        }
        throw new RuntimeException("not in screen sequence; " + screen);
    }

    private List getScreenConfigs() {
        return this.context.getScreenConfigs();
    }
}

