/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.dirchooser;

import com.install4j.runtime.dirchooser.DirectoryChooser;
import com.install4j.runtime.dirchooser.LazyMutableTreeNode;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.ButtonBoxLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DirectoryChooserUI
extends BasicFileChooserUI {
    private static Queue nodeQueue;
    private DirectoryChooser chooser;
    private JTree tree;
    private JScrollPane treeScroll;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private BasicFileChooserUI.BasicFileView fileView = new CommonFileView();
    private Action approveSelectionAction = new ApproveSelectionAction();
    private boolean useNodeQueue;
    private Method isFileSystemRootMethod;
    private Method isFloppyDriveMethod;
    private Method getSystemDisplayNameMethod;
    private Method getSystemIconMethod;
    private boolean preloadChildren;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$javax$swing$filechooser$FileSystemView;

    public DirectoryChooserUI(DirectoryChooser directoryChooser) {
        super(directoryChooser);
        if (this.isAtLeastJava14()) {
            try {
                this.isFileSystemRootMethod = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = DirectoryChooserUI.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("isFileSystemRoot", class$java$io$File == null ? (class$java$io$File = DirectoryChooserUI.class$("java.io.File")) : class$java$io$File);
                this.isFloppyDriveMethod = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = DirectoryChooserUI.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("isFloppyDrive", class$java$io$File == null ? (class$java$io$File = DirectoryChooserUI.class$("java.io.File")) : class$java$io$File);
                this.getSystemDisplayNameMethod = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = DirectoryChooserUI.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("getSystemDisplayName", class$java$io$File == null ? (class$java$io$File = DirectoryChooserUI.class$("java.io.File")) : class$java$io$File);
                this.getSystemIconMethod = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = DirectoryChooserUI.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("getSystemIcon", class$java$io$File == null ? (class$java$io$File = DirectoryChooserUI.class$("java.io.File")) : class$java$io$File);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isPreloadChildren() {
        return this.preloadChildren;
    }

    public void setPreloadChildren(boolean bl) {
        this.preloadChildren = bl;
    }

    private boolean isAtLeastJava14() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.3") && !string.startsWith("1.2");
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        super.rescanCurrentDirectory(jFileChooser);
        this.findFile(this.chooser.getSelectedFile() == null ? this.chooser.getCurrentDirectory() : this.chooser.getSelectedFile(), true, true);
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        super.ensureFileIsVisible(jFileChooser, file);
        this.findFile(file, false, false);
    }

    protected String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && treePath.getLastPathComponent() instanceof FileTreeNode) {
            FileTreeNode fileTreeNode = (FileTreeNode)treePath.getLastPathComponent();
            String string = this.getFileView(this.chooser).getTypeDescription(fileTreeNode.getFile());
            if (string == null || string.length() == 0) {
                return fileTreeNode.toString();
            }
            return fileTreeNode.toString() + " - " + string;
        }
        return null;
    }

    public void installComponents(JFileChooser jFileChooser) {
        this.chooser = (DirectoryChooser)jFileChooser;
        jFileChooser.setLayout(new BorderLayout(8, 8));
        jFileChooser.setFileSelectionMode(1);
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            jFileChooser.add("North", jFileChooser.getAccessory());
        }
        this.tree = new JTree(){

            public String getToolTipText(MouseEvent mouseEvent) {
                String string = DirectoryChooserUI.this.getToolTipText(mouseEvent);
                if (string == null) {
                    return super.getToolTipText(mouseEvent);
                }
                return string;
            }
        };
        this.tree.addTreeExpansionListener(new TreeExpansion());
        this.tree.setModel(new FileSystemTreeModel(jFileChooser.getFileSystemView()));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(InstallerUtil.isWindows() && !this.isAtLeastJava14());
        this.tree.setCellRenderer(new FileSystemTreeRenderer());
        this.tree.setToolTipText("");
        this.treeScroll = new JScrollPane(this.tree);
        jFileChooser.add("Center", this.treeScroll);
        this.treeScroll.setPreferredSize(new Dimension(300, 300));
        this.approveButton = new JButton();
        this.approveButton.setAction(this.getApproveSelectionAction());
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.buttonPanel = new JPanel(new ButtonBoxLayout(6));
        this.buttonPanel.add(this.approveButton);
        this.buttonPanel.add(this.cancelButton);
        jFileChooser.add("South", this.buttonPanel);
        this.updateView();
        this.initMultiSelection();
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.remove(this.treeScroll);
        jFileChooser.remove(this.buttonPanel);
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        this.tree.addTreeSelectionListener(new SelectionListener());
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new ChangeListener();
    }

    private void updateView() {
        if (this.chooser.getApproveButtonText() != null) {
            this.approveButton.setText(this.chooser.getApproveButtonText());
            this.approveButton.setMnemonic(this.chooser.getApproveButtonMnemonic());
        } else if (0 == this.chooser.getDialogType()) {
            this.approveButton.setText(this.openButtonText);
            this.approveButton.setToolTipText(this.openButtonToolTipText);
            this.approveButton.setMnemonic(this.openButtonMnemonic);
        } else {
            this.approveButton.setText(this.saveButtonText);
            this.approveButton.setToolTipText(this.saveButtonToolTipText);
            this.approveButton.setMnemonic(this.saveButtonMnemonic);
        }
        if (this.chooser.getCancelButtonText() != null) {
            this.cancelButtonText = this.chooser.getCancelButtonText();
            this.cancelButtonMnemonic = 0;
        }
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.buttonPanel.setVisible(this.chooser.getControlButtonsAreShown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findFile(File file, boolean bl, boolean bl2) {
        File file2;
        if (file == null || !file.isDirectory()) {
            return;
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (Exception exception) {
            return;
        }
        this.useNodeQueue = false;
        try {
            ArrayList<File> arrayList = new ArrayList<File>();
            arrayList.add(file2);
            while ((file2 = this.chooser.getFileSystemView().getParentDirectory(file2)) != null) {
                arrayList.add(0, file2);
            }
            ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            arrayList2.add(defaultMutableTreeNode);
            boolean bl3 = true;
            block6: while (arrayList.size() > 0 && bl3) {
                bl3 = false;
                int n = defaultMutableTreeNode.getChildCount();
                for (int i = 0; i < n; ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    File file3 = ((FileTreeNode)defaultMutableTreeNode2).getFile();
                    if (!arrayList.get(0).equals(file3)) continue;
                    arrayList2.add(defaultMutableTreeNode2);
                    arrayList.remove(0);
                    defaultMutableTreeNode = defaultMutableTreeNode2;
                    bl3 = true;
                    continue block6;
                }
            }
            TreePath treePath = new TreePath(arrayList2.toArray());
            if (treePath.getLastPathComponent() instanceof FileTreeNode && bl2) {
                ((FileTreeNode)treePath.getLastPathComponent()).clear();
            }
            if (bl) {
                this.tree.expandPath(treePath);
                this.tree.setSelectionPath(treePath);
            }
            this.scrollToPath(treePath);
        }
        finally {
            this.useNodeQueue = this.preloadChildren;
        }
    }

    private void scrollToPath(final TreePath treePath) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Rectangle rectangle = DirectoryChooserUI.this.tree.getPathBounds(treePath);
                if (rectangle != null) {
                    rectangle.height = 100;
                    DirectoryChooserUI.this.tree.scrollRectToVisible(rectangle);
                }
            }
        });
    }

    public void focusTree() {
        this.tree.requestFocus();
    }

    private boolean getBooleanFileMethodValue(Method method, File file) {
        Boolean bl = (Boolean)this.getFileMethodValue(method, file);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private Object getFileMethodValue(Method method, File file) {
        if (method != null) {
            try {
                return method.invoke((Object)this.chooser.getFileSystemView(), file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void scrollToSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            this.scrollToPath(treePath);
        }
    }

    private void initMultiSelection() {
        if (this.chooser.isMultiSelectionEnabled()) {
            this.tree.getSelectionModel().setSelectionMode(4);
        } else {
            this.tree.getSelectionModel().setSelectionMode(1);
        }
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    private void setSelectedFiles() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            this.chooser.setSelectedFile(null);
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = treePathArray.length;
        for (int i = 0; i < n; ++i) {
            LazyMutableTreeNode lazyMutableTreeNode = (LazyMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(lazyMutableTreeNode instanceof FileTreeNode)) continue;
            File file = ((FileTreeNode)lazyMutableTreeNode).getFile();
            arrayList.add(file);
        }
        this.chooser.setSelectedFiles(arrayList.toArray(new File[0]));
    }

    private static synchronized void addToQueue(FileTreeNode fileTreeNode, JTree jTree) {
        if (nodeQueue == null || !nodeQueue.isAlive()) {
            nodeQueue = new Queue();
            nodeQueue.start();
        }
        if (fileTreeNode.canEnqueue()) {
            nodeQueue.add(fileTreeNode, jTree);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class QueueItem {
        FileTreeNode node;
        JTree tree;

        public QueueItem(FileTreeNode fileTreeNode, JTree jTree) {
            this.node = fileTreeNode;
            this.tree = jTree;
        }
    }

    private static final class Queue
    extends Thread {
        private volatile Stack nodes = new Stack();
        private final Object lock = new Object();
        private volatile boolean running = true;

        public Queue() {
            super("DirectoryChooser-BackgroundLoader");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(FileTreeNode fileTreeNode, JTree jTree) {
            if (!this.isAlive()) {
                throw new IllegalArgumentException("Queue is no longer alive");
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.running) {
                    this.nodes.addElement(new QueueItem(fileTreeNode, jTree));
                    this.lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                Object object;
                while (this.nodes.size() > 0) {
                    object = (QueueItem)this.nodes.pop();
                    final FileTreeNode fileTreeNode = ((QueueItem)object).node;
                    final JTree jTree = ((QueueItem)object).tree;
                    fileTreeNode.getChildCount();
                    Runnable runnable = new Runnable(){

                        public void run() {
                            ((DefaultTreeModel)jTree.getModel()).nodeChanged(fileTreeNode);
                            jTree.repaint();
                        }
                    };
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
                try {
                    object = this.lock;
                    synchronized (object) {
                        this.lock.wait(5000L);
                    }
                    if (this.nodes.size() != 0) continue;
                    this.running = false;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    protected class CommonFileView
    extends BasicFileChooserUI.BasicFileView {
        protected CommonFileView() {
            super(DirectoryChooserUI.this);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                icon = (Icon)DirectoryChooserUI.this.getFileMethodValue(DirectoryChooserUI.this.getSystemIconMethod, file);
            }
            if (icon == null) {
                icon = super.getIcon(file);
            }
            this.cacheIcon(file, icon);
            return icon;
        }
    }

    private class FileTreeNode
    extends LazyMutableTreeNode
    implements Comparable {
        public FileTreeNode(File file) {
            super(file);
        }

        public boolean canEnqueue() {
            return !this.isLoaded() && !this.isFloppyDrive() && !this.isFileSystemRoot();
        }

        private boolean isFileSystemRoot() {
            return DirectoryChooserUI.this.getBooleanFileMethodValue(DirectoryChooserUI.this.isFileSystemRootMethod, this.getFile());
        }

        private boolean isFloppyDrive() {
            return DirectoryChooserUI.this.getBooleanFileMethodValue(DirectoryChooserUI.this.isFloppyDriveMethod, this.getFile());
        }

        public boolean isLeaf() {
            return this.isLoaded() && super.isLeaf();
        }

        protected void loadChildren() {
            FileTreeNode[] fileTreeNodeArray = this.getChildren();
            int n = fileTreeNodeArray.length;
            for (int i = 0; i < n; ++i) {
                this.add(fileTreeNodeArray[i]);
            }
        }

        private FileTreeNode[] getChildren() {
            File[] fileArray = DirectoryChooserUI.this.chooser.getFileSystemView().getFiles(this.getFile(), DirectoryChooserUI.this.chooser.isFileHidingEnabled());
            ArrayList<FileTreeNode> arrayList = new ArrayList<FileTreeNode>();
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!fileArray[i].isDirectory()) continue;
                    arrayList.add(new FileTreeNode(fileArray[i]));
                }
            }
            Object[] objectArray = arrayList.toArray(new FileTreeNode[0]);
            Arrays.sort(objectArray);
            return objectArray;
        }

        public File getFile() {
            return (File)this.getUserObject();
        }

        public String toString() {
            String string = (String)DirectoryChooserUI.this.getFileMethodValue(DirectoryChooserUI.this.getSystemDisplayNameMethod, (File)this.getUserObject());
            if (string != null) {
                return string;
            }
            return super.toString();
        }

        public int compareTo(Object object) {
            if (!(object instanceof FileTreeNode)) {
                return 1;
            }
            return this.getFile().compareTo(((FileTreeNode)object).getFile());
        }

        public void clear() {
            super.clear();
            ((DefaultTreeModel)DirectoryChooserUI.this.tree.getModel()).nodeStructureChanged(this);
        }
    }

    private class MyComputerTreeNode
    extends LazyMutableTreeNode {
        public MyComputerTreeNode(FileSystemView fileSystemView) {
            super(fileSystemView);
        }

        protected void loadChildren() {
            FileSystemView fileSystemView = (FileSystemView)this.getUserObject();
            Object[] objectArray = fileSystemView.getRoots();
            if (objectArray != null) {
                Arrays.sort(objectArray);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.add(new FileTreeNode((File)objectArray[i]));
                }
            }
        }

        public String toString() {
            return "/";
        }
    }

    private class FileSystemTreeModel
    extends DefaultTreeModel {
        public FileSystemTreeModel(FileSystemView fileSystemView) {
            super(new DefaultMutableTreeNode());
            this.setRoot(new MyComputerTreeNode(fileSystemView));
            this.setAsksAllowsChildren(false);
        }
    }

    private class FileSystemTreeRenderer
    extends DefaultTreeCellRenderer {
        private FileSystemTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, false, n, bl4);
            if (object instanceof FileTreeNode) {
                FileTreeNode fileTreeNode = (FileTreeNode)object;
                this.setText(DirectoryChooserUI.this.getFileView(DirectoryChooserUI.this.chooser).getName(fileTreeNode.getFile()));
                if (!InstallerUtil.isMacOS() || !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
                    this.setIcon(DirectoryChooserUI.this.getFileView(DirectoryChooserUI.this.chooser).getIcon(fileTreeNode.getFile()));
                }
            }
            return this;
        }
    }

    private class TreeExpansion
    implements TreeExpansionListener {
        private TreeExpansion() {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            Object object;
            if (treeExpansionEvent.getPath() != null && (object = treeExpansionEvent.getPath().getLastPathComponent()) instanceof FileTreeNode && DirectoryChooserUI.this.useNodeQueue && ((FileTreeNode)object).isLoaded()) {
                Enumeration<TreeNode> enumeration = ((FileTreeNode)object).children();
                while (enumeration.hasMoreElements()) {
                    DirectoryChooserUI.addToQueue((FileTreeNode)enumeration.nextElement(), DirectoryChooserUI.this.tree);
                }
            }
        }
    }

    private class ApproveSelectionAction
    extends AbstractAction {
        public ApproveSelectionAction() {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryChooserUI.this.setSelectedFiles();
            DirectoryChooserUI.this.chooser.approveSelection();
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DirectoryChooserUI.this.getApproveSelectionAction().setEnabled(DirectoryChooserUI.this.tree.getSelectionCount() > 0);
            DirectoryChooserUI.this.setSelectedFiles();
        }
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("ApproveButtonTextChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                DirectoryChooserUI.this.updateView();
            }
            if ("MultiSelectionEnabledChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                DirectoryChooserUI.this.initMultiSelection();
            }
            if ("directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
                DirectoryChooserUI.this.findFile(DirectoryChooserUI.this.chooser.getCurrentDirectory(), false, false);
            }
            if ("AccessoryChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                Component component = (Component)propertyChangeEvent.getOldValue();
                Component component2 = (Component)propertyChangeEvent.getNewValue();
                if (component != null) {
                    DirectoryChooserUI.this.chooser.remove(component);
                }
                if (component2 != null) {
                    DirectoryChooserUI.this.chooser.add("North", component2);
                }
                DirectoryChooserUI.this.chooser.revalidate();
                DirectoryChooserUI.this.chooser.repaint();
            }
            if ("ControlButtonsAreShownChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                DirectoryChooserUI.this.updateView();
            }
        }
    }
}

