/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.actions.AbstractInstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferenceDeleteType;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class DeletePreferenceItemAction
extends PreferencesAction {
    private PreferenceDeleteType preferenceDeleteType = PreferenceDeleteType.USER;
    private boolean onlyIfEmpty = true;

    public PreferenceDeleteType getPreferenceDeleteType() {
        return this.preferenceDeleteType;
    }

    public void setPreferenceDeleteType(PreferenceDeleteType preferenceDeleteType) {
        this.preferenceDeleteType = preferenceDeleteType;
    }

    public boolean isOnlyIfEmpty() {
        return this.onlyIfEmpty;
    }

    public void setOnlyIfEmpty(boolean bl) {
        this.onlyIfEmpty = bl;
    }

    protected boolean execute(Context context) throws UserCanceledException {
        if (this.getKey().trim().length() == 0 && this.getPackageName().trim().length() == 0) {
            return false;
        }
        boolean bl = true;
        if (this.preferenceDeleteType == PreferenceDeleteType.USER || this.preferenceDeleteType == PreferenceDeleteType.SYSTEM_AND_USER) {
            try {
                this.deleteItem(this.getPackageNode(true));
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
                bl = false;
            }
        }
        if (this.preferenceDeleteType == PreferenceDeleteType.SYSTEM || this.preferenceDeleteType == PreferenceDeleteType.SYSTEM_AND_USER) {
            try {
                this.deleteItem(this.getPackageNode(false));
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
                bl = false;
            }
        }
        return bl;
    }

    private void deleteItem(Preferences preferences) throws BackingStoreException {
        PerformedAction performedAction;
        String string = this.getKey().trim();
        if (string.length() == 0) {
            if (this.onlyIfEmpty && (preferences.childrenNames().length > 0 || preferences.keys().length > 0)) {
                return;
            }
            performedAction = new PerformedAction(preferences);
            preferences.removeNode();
        } else {
            performedAction = new PerformedAction(preferences, string);
            preferences.remove(string);
        }
        preferences.flush();
        this.addRollbackAction(performedAction);
    }

    private static class PerformedAction
    extends AbstractInstallAction {
        private Preferences packageNode;
        private String key;
        private String oldValue;
        private byte[] exportedTree;

        public PerformedAction(Preferences preferences, String string) {
            this.packageNode = preferences;
            this.key = string;
            this.oldValue = preferences.get(string, null);
        }

        public PerformedAction(Preferences preferences) throws BackingStoreException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                preferences.exportSubtree(byteArrayOutputStream);
                this.exportedTree = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void rollback(InstallerContext installerContext) {
            if (this.packageNode != null && this.oldValue != null) {
                Preferences preferences = PreferencesAction.getPackageNode(this.packageNode.isUserNode(), this.packageNode.absolutePath());
                preferences.put(this.key, this.oldValue);
                try {
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    backingStoreException.printStackTrace();
                }
            }
            if (this.exportedTree != null) {
                try {
                    Preferences.importPreferences(new ByteArrayInputStream(this.exportedTree));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
                    invalidPreferencesFormatException.printStackTrace();
                }
            }
        }

        public boolean install(InstallerContext installerContext) throws UserCanceledException {
            throw new UnsupportedOperationException();
        }
    }
}

