/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.UserInfo;
import java.awt.Window;
import java.net.URL;
import java.util.Iterator;

public class Util {
    public static boolean isSolaris() {
        return InstallerUtil.isSolaris();
    }

    public static boolean isLinux() {
        return InstallerUtil.isLinux();
    }

    public static boolean isWindows() {
        return InstallerUtil.isWindows();
    }

    public static boolean isWindows9X() {
        return InstallerUtil.isWindows9X();
    }

    public static boolean isWindowsNT() {
        return InstallerUtil.isWindowsNT();
    }

    public static boolean isWindowsVista() {
        return InstallerUtil.isWindowsVista();
    }

    public static boolean isMacOS() {
        return InstallerUtil.isMacOS();
    }

    public static boolean isHpux() {
        return InstallerUtil.isHpux();
    }

    public static boolean isWindowsInstaller() {
        return InstallerConfig.getCurrentInstance().getType().equals("windows");
    }

    public static boolean isUnixInstaller() {
        return InstallerConfig.getCurrentInstance().getType().equals("unix");
    }

    public static boolean isMacosInstaller() {
        return InstallerConfig.getCurrentInstance().getType().equals("macos");
    }

    public static String getStandardApplicationsDirectory() {
        return InstallerUtil.getStandardApplicationsDirectory();
    }

    public static void showUrl(URL uRL) {
        GUIHelper.showURL(uRL.toExternalForm());
    }

    public static void showMessage(String string, int n) {
        GUIHelper.showMessage(null, string, n);
    }

    public static void showMessage(String string) {
        GUIHelper.showMessage(null, string, 1);
    }

    public static void showErrorMessage(String string) {
        GUIHelper.showMessage(null, string, 0);
    }

    public static void showWarningMessage(String string) {
        GUIHelper.showMessage(null, string, 2);
    }

    public static int showOptionDialog(String string, String[] stringArray, int n) throws UserCanceledException {
        return GUIHelper.showOptionDialog(null, string, stringArray, n);
    }

    public static void fatalError(Throwable throwable) {
        InstallerUtil.reportException(throwable);
        System.exit(1);
    }

    public static Window getParentWindow() {
        return GUIHelper.getParentWindow();
    }

    public static void logInfo(Object object, String string) {
        Logger.getInstance().info(object, string);
    }

    public static void logError(Object object, String string) {
        Logger.getInstance().error(object, string);
    }

    public static void dumpVariables(Context context) {
        System.err.println();
        System.err.println("Defined installer variables:");
        System.err.println("----------------------------");
        Iterator iterator = context.getVariableNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = context.getVariable(string);
            System.err.println(InstallerUtil.getVerboseVariableDefinition(string, object));
        }
        System.err.println("----------------------------");
        System.err.println();
    }

    public static boolean isAdminUser() {
        return UserInfo.isAdminUser();
    }
}

