; Start NicotinePlusOnWindows Script generated by the HM NIS Edit Script Wizard.
; modification Copy-left 2006 Vandy Omall <osiris.contact@gmail.com>
; HM NIS Edit Wizard helper defines
!define NAME "Nicotine+"
!define PNAME "nicotine+"
!define VERSION "1.2.8"
!define FORMAT "win32"
;!define TAG "Tags/${PNAME}-${VERSION}-${FORMAT}"
!define TAG "..\dist"

!define PUBLISHER "daelstorm"
!define WEBSITE "http://nicotine-plus.sf.net"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\nicotine.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings / Icons (we use our own (un)install icons)
!define MUI_ABORTWARNING
!define MUI_ICON "NicotinePlusInstall.ico"
!define MUI_UNICON "NicotinePlusUninstall.ico"

; MUI Settings / Header (we use our own custom 2xHeaders each time)
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_LEFT
!define MUI_HEADERIMAGE_BITMAP "Header_L.bmp" ;Install Header in left
!define MUI_HEADERIMAGE_UNBITMAP "Header_R.bmp" ;Uninstall Header in right

; MUI Settings / Wizard (we use our own custom wizard.bmp each time)
!define MUI_WELCOMEFINISHPAGE_BITMAP "Wizard.bmp"
!define MUI_UNWELCOMEFINISHPAGE_BITMAP "Wizard.bmp"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Choose directory
!insertmacro MUI_PAGE_DIRECTORY
; License page
!insertmacro MUI_PAGE_LICENSE "copying.rtf"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\nicotine.exe"
!define MUI_FINISHPAGE_LINK "Visit Nicotine+ Homepage"
!define MUI_FINISHPAGE_LINK_LOCATION "${WEBSITE}"
!insertmacro MUI_PAGE_FINISH
ReserveFile "${TAG}\doc\CHANGELOG"
; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Danish"
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "Finnish"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Hungarian"
!insertmacro MUI_LANGUAGE "Italian"
!insertmacro MUI_LANGUAGE "Polish"
!insertmacro MUI_LANGUAGE "Slovak"
!insertmacro MUI_LANGUAGE "Spanish"
!insertmacro MUI_LANGUAGE "PortugueseBR"
!insertmacro MUI_LANGUAGE "Swedish"
!insertmacro MUI_LANGUAGE "Lithuanian"
!insertmacro MUI_LANGUAGE "Basque"


; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${NAME} ${VERSION}"
OutFile "${PNAME}-${VERSION}-${FORMAT}.exe"
InstallDir "$PROGRAMFILES\Nicotine+"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
System::Call 'kernel32::CreateMutexA(i 0, i 0, t "myMutex") i .r1 ?e'
 Pop $R0
 
 StrCmp $R0 0 +3
   MessageBox MB_OK|MB_ICONEXCLAMATION "The installer is already running."
   Abort
!insertmacro MUI_LANGDLL_DISPLAY

FunctionEnd



Section "Client" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite on
  CreateDirectory "$SMPROGRAMS\Nicotine+"
  CreateShortCut "$SMPROGRAMS\Nicotine+\Nicotine+.lnk" "$INSTDIR\nicotine.exe"
  CreateShortCut "$DESKTOP\Nicotine+.lnk" "$INSTDIR\nicotine.exe"

  File "${TAG}\nicotine+-${VERSION}.tar.bz2"
  File "${TAG}\nicotine.exe"
  File "${TAG}\w9xpopen.exe"
  File "${TAG}\msvcr71.dll"
  File "${TAG}\library.zip"
  File "${TAG}\atk.pyd"
  File "${TAG}\bz2.pyd"
  File "${TAG}\python24.dll"
  File "${TAG}\pywintypes24.dll"
  File "${TAG}\pangocairo.pyd"
  File "${TAG}\pango.pyd"
  File "${TAG}\select.pyd"
  File "${TAG}\unicodedata.pyd"
  File "${TAG}\vorbis.pyd"
  #File "${TAG}\win32api.pyd"
  #File "${TAG}\win32gui.pyd"
  File "${TAG}\zlib.pyd"
  File "${TAG}\_bsddb.pyd"
  File "${TAG}\_cairo.pyd"
  File "${TAG}\_gobject.pyd"
  File "${TAG}\_gtk.pyd"
  File "${TAG}\_ssl.pyd"
  File "${TAG}\_socket.pyd"
  File "${TAG}\_psyco.pyd"
  File "${TAG}\_ogg.pyd"
  File "${TAG}\_win32sysloader.pyd"
  SetOverwrite on
  SetOutPath "$INSTDIR\doc"
  
  File "${TAG}\doc\NicotinePlusGuide.html"
  File "${TAG}\doc\CHANGELOG"
  
  SetOutPath "$INSTDIR\share\locale\fr\LC_MESSAGES"
  File "${TAG}\fr\LC_MESSAGES\nicotine.mo"
  
  SetOutPath "$INSTDIR\share\locale\nl\LC_MESSAGES"
  File "${TAG}\nl\LC_MESSAGES\nicotine.mo"
  
  SetOutPath "$INSTDIR\share\locale\de\LC_MESSAGES"
  File "${TAG}\de\LC_MESSAGES\nicotine.mo"
  
  SetOutPath "$INSTDIR\share\locale\sk\LC_MESSAGES"
  File "${TAG}\sk\LC_MESSAGES\nicotine.mo"

  SetOutPath "$INSTDIR\share\locale\dk\LC_MESSAGES"
  File "${TAG}\dk\LC_MESSAGES\nicotine.mo"

  SetOutPath "$INSTDIR\share\locale\sv\LC_MESSAGES"
  File "${TAG}\sv\LC_MESSAGES\nicotine.mo"

  SetOutPath "$INSTDIR\share\locale\pt_BR\LC_MESSAGES"
  File "${TAG}\pt_BR\LC_MESSAGES\nicotine.mo"

  SetOutPath "$INSTDIR\share\locale\pl\LC_MESSAGES"
  File "${TAG}\pl\LC_MESSAGES\nicotine.mo"  

  SetOutPath "$INSTDIR\share\locale\fi\LC_MESSAGES"
  File "${TAG}\fi\LC_MESSAGES\nicotine.mo"  
  
  SetOutPath "$INSTDIR\share\locale\es\LC_MESSAGES"
  File "${TAG}\es\LC_MESSAGES\nicotine.mo"  
  
  SetOutPath "$INSTDIR\share\locale\it\LC_MESSAGES"
  File "${TAG}\it\LC_MESSAGES\nicotine.mo"  
  
  SetOutPath "$INSTDIR\share\locale\eu\LC_MESSAGES"
  File "${TAG}\eu\LC_MESSAGES\nicotine.mo"  
  
  SetOutPath "$INSTDIR\share\locale\hu\LC_MESSAGES"
  File "${TAG}\hu\LC_MESSAGES\nicotine.mo"  
SectionEnd

Section "Source" SEC02
  SetOutPath "$INSTDIR"
  SetOverwrite on
  File "${TAG}\nicotine+-${VERSION}.tar.bz2"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${NAME}.url" "InternetShortcut" "URL" "${WEBSITE}"
  CreateShortCut "$SMPROGRAMS\Nicotine+\Website.lnk" "$INSTDIR\${NAME}.url"
  CreateShortCut "$SMPROGRAMS\Nicotine+\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\nicotine.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\nicotine.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${WEBSITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "Nicotine+"
 ;;  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "Nicotine+ source files"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${NAME}.url"
  
  Delete "$INSTDIR\nicotine+-${VERSION}.tar.bz2"
  Delete "$INSTDIR\nicotine.exe"
  Delete "$INSTDIR\w9xpopen.exe"
  Delete "$INSTDIR\msvcr71.dll"
  Delete "$INSTDIR\library.zip"
  Delete "$INSTDIR\atk.pyd"
  Delete "$INSTDIR\bz2.pyd"
  Delete "$INSTDIR\python24.dll"
  Delete "$INSTDIR\pywintypes24.dll"
  Delete "$INSTDIR\pangocairo.pyd"
  Delete "$INSTDIR\pango.pyd"
  Delete "$INSTDIR\select.pyd"
  Delete "$INSTDIR\unicodedata.pyd"
  Delete "$INSTDIR\vorbis.pyd"
  #Delete "$INSTDIR\win32api.pyd"
  #Delete "$INSTDIR\win32gui.pyd"
  Delete "$INSTDIR\zlib.pyd"
  Delete "$INSTDIR\_bsddb.pyd"
  Delete "$INSTDIR\_cairo.pyd"
  Delete "$INSTDIR\_gobject.pyd"
  Delete "$INSTDIR\_gtk.pyd"
  Delete "$INSTDIR\_ssl.pyd"
  Delete "$INSTDIR\_socket.pyd"
  Delete "$INSTDIR\_psyco.pyd"
  Delete "$INSTDIR\_ogg.pyd"
  Delete "$INSTDIR\_win32sysloader.pyd"
  
  Delete "$INSTDIR\doc\NicotinePlusGuide.html"
  Delete "$INSTDIR\doc\CHANGELOG"
  
  Delete "$SMPROGRAMS\Nicotine+\Uninstall.lnk"
  Delete "$SMPROGRAMS\Nicotine+\Website.lnk"
  Delete "$DESKTOP\Nicotine+.lnk"
  Delete "$SMPROGRAMS\Nicotine+\Nicotine+.lnk"

  RMDir "$SMPROGRAMS\Nicotine+"
  RMDir "$INSTDIR\doc"
  Delete "$INSTDIR\uninst.exe"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
; Start NicotinePlusOnWindows Script generated by the HM NIS Edit Script Wizard.
; modification Copy-left 2006 Vandy Omall <osiris.contact@gmail.com>