.\" Automatically generated by Pod::Man 2.25 (Pod::Simple 3.20)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.ie \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.el \{\
.    de IX
..
.\}
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "MALHEUR 1"
.TH MALHEUR 1 "2012-02-05" "malheur 0.5.3" "User Manual"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
malheur \- automatic analysis of malware behavior
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBmalheur\fR [\fB\-hrvV\fR] [\fB\-m\fR \fImaldir\fR] [\fB\-o\fR \fIoutfile\fR] \fIaction\fR \fIdataset\fR
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBmalheur\fR is a tool for the automatic analysis of malware behavior (program
behavior recorded from malicious software in a sandbox environment).  The
tool has been designed to support the regular analysis of malicious software
and the development of detection and defense measures.  \fBmalheur\fR allows
for identifying novel classes of malware with similar behavior and assigning
unknown malware to discovered classes.  It supports four basic actions for
analysis which can be applied to reports of recorded behavior:
.IP "\fIExtraction of prototypes\fR." 4
.IX Item "Extraction of prototypes."
From a given set of reports, \fBmalheur\fR identifies a subset of prototypes
representative for the full data set.  The prototypes provide a quick
overview of recorded behavior and can be used to guide manual inspection.
.IP "\fIClustering of behavior\fR." 4
.IX Item "Clustering of behavior."
\&\fBmalheur\fR automatically identifies groups (clusters) of reports containing
similar behavior.  Clustering allows for discovering novel classes of
malware and provides the basis for crafting specific detection and defense
mechanisms, such as anti-virus signatures.
.IP "\fIClassification of behavior\fR." 4
.IX Item "Classification of behavior."
Based on a set of previously clustered reports, \fBmalheur\fR is able to assign
unknown behavior to known groups of malware.  Classification enables
identifying novel and unknown variants of malware and can be used to filter
program behavior prior to manual inspection.
.IP "\fIIncremental analysis\fR." 4
.IX Item "Incremental analysis."
\&\fBmalheur\fR can be applied incrementally for analysis of large data
sets. By processing reports in chunks, the run-time as well as memory
requirements can be significantly reduced. This renders long-term
application of \fBmalheur\fR feasible, for example for daily analysis 
of incoming malware programs.
.PP
A detailed description of these techniques as well as technical 
background on analysis of malicious software is provided in the 
following articles:
.IP "\(bu" 4
\&\fIAutomatic Analysis of Malware Behavior using Machine Learning\fR.
Konrad Rieck, Philipp Trinius, Carsten Willems, and Thorsten Holz.
Journal of Computer Security (\s-1JCS\s0), 19(4) 639\-668, 2011.
.IP "\(bu" 4
\&\fIA Malware Instruction Set for Behavior-Based Analysis\fR.
Philipp Trinius, Carsten Willems, Thorsten Holz, and Konrad Rieck.
Technical report \s-1TR\-2009\-07\s0, University of Mannheim, 2009
.PP
The input of \fBmalheur\fR is a \fIdataset\fR containing reports of malware
behavior. The \fIdataset\fR is provided either as a directory or a
compressed archive containing the reports. \fBmalheur\fR supports the
following formats for compressed archives: tar.gz, zip, pax and cpio.
A \fIreport\fR is a textual document describing the recorded activity of
a malware program, where individual events are separated by delimiter
characters, such as white space or carriage return.  The events in a
report are expected to be in sequential order if n\-grams with n\ >\ 1 are extracted. If the behavior is represented using the
malware instruction set (\s-1MIST\s0) further options may be selected.
.PP
The result of an analysis is written to \fIoutfile\fR, a textual file
containing columns corresponding to particular analysis results.  By
default \fIoutfile\fR is set to \fImalheur.out\fR.
.PP
The configuration and internal state of \fBmalheur\fR are stored in the
directory \fImaldir\fR. If this directory does not exist, it is created
and the system wide configuration is copied. A detailed description of
the malheur configuration is provided in \*(L"\s-1CONFIGURATION\s0\*(R". By
default \fImaldir\fR is set to \fI~/.malheur\fR.
.SH "ACTIONS & OPTIONS"
.IX Header "ACTIONS & OPTIONS"
\&\fBmalheur\fR supported different \fIactions\fR for analysis of a
\&\fIdataset\fR.  For all actions the reports are first mapped to a
high-dimensional vector space, such that each report is represented as
a feature vector. Recorded events or n\-grams of events are reflected
in different dimensions and the dissimilarity of behavior can be
assessed geometrically by computing distances and angles.
.IP "\fBdistance\fR" 12
.IX Item "distance"
If this action is specified, \fBmalheur\fR computes a distance matrix for
\&\fIdataset\fR. The entry (i,j) of this matrix reflects the distance
(dissimilarity) of the reports i and j. The distance values lie in the
range 0 to \fIsqrt\fR\|(2). The distance matrix is written to \fIoutfile\fR.
.IP "\fBprototype\fR" 12
.IX Item "prototype"
If this action is specified, \fBmalheur\fR determines a set of
\&\fIprototypes\fR representing \fIdataset\fR. The prototypes are selected
from the contained reports, such that the distance from any report to
its nearest prototype is minimized. The prototype assignment of
\&\fIdataset\fR is written to \fIoutfile\fR.
.IP "\fBcluster\fR" 12
.IX Item "cluster"
If this action is specified, \fBmalheur\fR performs a \fIclustering\fR of
\&\fIdataset\fR. The clustering is first determined on prototypes and then
propagated to all reports. Small clusters with too few members are
merged in a \fIrejection cluster\fR. The prototypes representing accepted
clusters are stored as internal state of \fBmalheur\fR for later
classification and incremental analysis. The clustering of \fIdataset\fR
is written to \fIoutfile\fR.
.IP "\fBclassify\fR" 12
.IX Item "classify"
If this action is specified, \fBmalheur\fR performs a \fIclassification\fR
of \fIdataset\fR. Each report is either assigned to the nearest prototype
of a known cluster or rejected as unknown. This action requires that a
clustering has been performed beforehand and an internal state of
\&\fBmalheur\fR exists. The classification of \fIdataset\fR is written to
\&\fIoutfile\fR.
.IP "\fBincrement\fR" 12
.IX Item "increment"
If this action is specified, \fBmalheur\fR performs an \fIincremental
analysis\fR of the reports. The reports are first classified to known
clusters as in the action \fIclassify\fR. Reports rejected from
classification are then clustered as in the action \fIcluster\fR. The
prototypes of the accepted clusters and the rejected reports are
written to the internal state of \fBmalheur\fR for further incremental
analysis. The classification and clustering of \fIdataset\fR are written
to \fIoutfile\fR.
.IP "\fBprotodist\fR" 12
.IX Item "protodist"
If this action is specified, \fBmalheur\fR computes a distance matrix for
prototypes.  The entry (i,j) of this matrix reflects the distance
(dissimilarity) of the prototypes i and j.  The distance values lie in the
range 0 to \fIsqrt\fR\|(2).  This action requires that either a prototype
extraction, a clustering or an incremental analysis has been performed
beforehand.  The distance matrix is written to \fIoutfile\fR.
.PP
\&\fBmalheur\fR also supports the following command-line \fIoptions\fR which
are used to further control the analysis process
.IP "\fB\-m\fR \fImaldir\fR" 12
.IX Item "-m maldir"
This option specifies the malheur directory \fImaldir\fR which holds the
configuration and internal state of \fBmalheur\fR. If the directory does
not exist, it is created and the system wide configuration is copied.
.IP "\fB\-o\fR \fIoutfile\fR" 12
.IX Item "-o outfile"
This option specifies the output file \fIoutfile\fR for analysis. The
file is created during analysis and the results are stored in textual
form.
.IP "\fB\-r\fR" 12
.IX Item "-r"
This option resets the internal state of \fBmalheur\fR. Prototypes of
clusters and rejected reports from previous runs of \fBmalheur\fR are
removed.
.IP "\fB\-v\fR" 12
.IX Item "-v"
This option is used to increase the verbosity of \fBmalheur\fR during
analysis, where the verbosity level corresponds to the number 
of \*(L"\-v\*(R" options.
.IP "\fB\-h\fR" 12
.IX Item "-h"
This option prints a brief help screen.
.IP "\fB\-V\fR" 12
.IX Item "-V"
This option prints a version and copyright string.
.SH "CONFIGURATION"
.IX Header "CONFIGURATION"
The configuration file \fImalheur.cfg\fR in \fImaldir\fR determines how the
malware behavior in a data set is analysis. The configuration contains
five groups of settings which are described in the following.
.PP
All parameters of the configuration can be also specified on the
command line.  That is, if a parameter is defined in the configuration as
\&\fBxx = \*(L"yy\*(R";\fR in the group \fBzz\fR, it can be alternatively supplied as a
command-line option by \fB\-\-zz.xx \*(L"yy\*(R"\fR to \fBmalheur\fR.
.IP "\fBinput = {\fR" 4
.IX Item "input = {"
.RS 4
.PD 0
.ie n .IP "\fBformat = ""mist"";\fR" 4
.el .IP "\fBformat = ``mist'';\fR" 4
.IX Item "format = mist;"
.PD
This parameter specifies the input format. Supported values are \*(L"text\*(R"
for textual and \s-1XML\s0 reports, and \*(L"mist\*(R" for reports using the malware
instruction set (\s-1MIST\s0).
.IP "\fBmist_level = 2;\fR" 4
.IX Item "mist_level = 2;"
This parameter specifies the \s-1MIST\s0 level. If the input format is set to
\&\*(L"mist\*(R", this parameter controls the analysis level of \s-1MIST\s0
instructions, otherwise it is ignored.
.IP "\fBmist_rlen = 0;\fR" 4
.IX Item "mist_rlen = 0;"
This parameter specifies the report truncation length. If the input
format is set to \*(L"mist\*(R", this parameter controls the truncation of
\&\s-1MIST\s0 reports, otherwise it is ignored. If set to 0 the parameter is
ignored in all cases.
.IP "\fBmist_tlen = 0;\fR" 4
.IX Item "mist_tlen = 0;"
This parameter specifies the thread truncation length. If the input
format is set to \*(L"mist\*(R", this parameter controls the truncation of
\&\s-1MIST\s0 threads, otherwise it is ignored. If set to 0 the parameter is
ignored in all cases.
.RE
.RS 4
.RE
.IP "\fB};\fR" 4
.IX Item "};"
.PD 0
.IP "\fBfeatures = {\fR" 4
.IX Item "features = {"
.RS 4
.ie n .IP "\fBngram_delim = ""%0a%0d"";\fR" 4
.el .IP "\fBngram_delim = ``%0a%0d'';\fR" 4
.IX Item "ngram_delim = %0a%0d;"
.PD
This parameter defines characters for delimiting events in report
files. The characters can be either specified as regular bytes or as
hexadecimal numbers prefixed by \*(L"%\*(R". If no characters are specified,
the reports are analyzed at byte-level, as if each byte would reflect
one event.
.IP "\fBngram_len = 2;\fR" 4
.IX Item "ngram_len = 2;"
This parameter specified the length of n\-grams. If the events in the
reports are not sequential, this parameter should be set to 1. In all
other cases, it determines the length of event sequences to be mapped
to the vector space, so called n\-grams.
.ie n .IP "\fBvect_embed = ""bin"";\fR" 4
.el .IP "\fBvect_embed = ``bin'';\fR" 4
.IX Item "vect_embed = bin;"
This parameter specifies how the feature are embedded in the vector
space. Support values are \*(L"bin\*(R" for associating each dimension with a
binary value or \*(L"cnt\*(R" for associating each dimension with a count
value for the occurrences of features.
.IP "\fBlookup_table = 0;\fR" 4
.IX Item "lookup_table = 0;"
This parameter is used to enable an optional feature lookup table.
The table can be used during debugging and verbose output for tracing
dimensions in feature vectors back to events. For performance reasons
it should be disabled by default.
.IP "\fBhash_seed1 = 0xc0cac01a;\fR" 4
.IX Item "hash_seed1 = 0xc0cac01a;"
.PD 0
.IP "\fBhash_seed2 = 0xadd511fe;\fR" 4
.IX Item "hash_seed2 = 0xadd511fe;"
.PD
To enable efficient comparison of feature vectors, \fBmalheur\fR internally
represents string features as 64 bit hash values using \s-1MD5\s0.  These two
parameters allow to change the seed of the \s-1MD5\s0 hash and should be
initialized to random values, which protects from targeted collision
attacks.  The remaining risk of collisions is minimal: (a) the number of
unique features per report is limited to several thousands, and (b) in
case of a collision the respective features can not be predicted.
.RE
.RS 4
.RE
.IP "\fB};\fR" 4
.IX Item "};"
.PD 0
.IP "\fBprototypes = {\fR" 4
.IX Item "prototypes = {"
.RS 4
.IP "\fBmax_dist = 0.65;\fR" 4
.IX Item "max_dist = 0.65;"
.PD
This parameter specifies the maximum distance to a prototype. During
analysis prototypes are selected in a way such that the distance from
each report to its nearest prototype is below this value. The
parameter lies in the range 0 to \fIsqrt\fR\|(2). If set to 0 all reports are
considered as prototypes.
.IP "\fBmax_num = 0;\fR" 4
.IX Item "max_num = 0;"
This parameter defines the maximum number of prototypes. During
analysis prototypes are selected until this value is reached.  If too
many prototypes are determined, this parameter can be used to reduce
computational costs at the price of a coarser approximation.  If set
to 0 this parameter is ignored.
.RE
.RS 4
.RE
.IP "};" 4
.PD 0
.IP "\fBcluster = {\fR" 4
.IX Item "cluster = {"
.RS 4
.ie n .IP "\fBlink_mode = ""complete"";\fR" 4
.el .IP "\fBlink_mode = ``complete'';\fR" 4
.IX Item "link_mode = complete;"
.PD
This parameter specifies the clustering mode. Supported values are
\&\*(L"complete\*(R" for complete-linkage clustering, \*(L"average\*(R" for
average-linkage clustering and \*(L"single\*(R" for single-linkage clustering.
.IP "\fBmin_dist = 0.95;\fR" 4
.IX Item "min_dist = 0.95;"
This parameter defines the minimum distance between clusters.  The
clustering operates in a bottom-up manner. That is, clusters are
successfully merged until the minimum distance between the closest
pair of clusters is above this value. The parameters lies in the range
0 to \fIsqrt\fR\|(2).
.IP "\fBreject_num = 10;\fR" 4
.IX Item "reject_num = 10;"
This parameter specifies the minimum number of members in a clusters.
Small clusters containing less members than this value are rejected.
The corresponds reports are assigned to a global rejection cluster.
If set to 0, all clusters are accepted.
.IP "\fBshared_ngrams   = 0.0;\fR" 4
.IX Item "shared_ngrams   = 0.0;"
This parameter allows to extract shared n\-grams for each clusters. 
The shared n\-grams are determined by merging the members in each 
cluster and identifying all n\-grams shared by at least the given 
ratio of members.  The resulting list of shared n\-grams is appended
to \fIoutfile\fR. If set to 0.0, this feature is disabled. Note that
if shared n\-grams are enabled, a feature lookup table is 
maintained which consumes extra memory.
.RE
.RS 4
.RE
.IP "\fB};\fR" 4
.IX Item "};"
.PD 0
.IP "\fBclassify = {\fR" 4
.IX Item "classify = {"
.RS 4
.IP "\fBmax_dist = 0.68;\fR" 4
.IX Item "max_dist = 0.68;"
.PD
This parameter defines the maximum distance to prototypes during
classification. Reports that are closer to the nearest prototype than
this value are assigned to the cluster represented by prototype,
whereas reports that are farther away than this value are rejected
from classification. The parameter lies in the range 0 to \fIsqrt\fR\|(2). If
set 0 all reports are classified, irrespective of the distance to a
prototype.
.RE
.RS 4
.RE
.IP "\fB};\fR" 4
.IX Item "};"
.SH "FILES"
.IX Header "FILES"
.PD 0
.IP "\fI/etc/malheur.cfg\fR" 4
.IX Item "/etc/malheur.cfg"
.PD
The system wide configuration file of \fBmalheur\fR. See
\&\*(L"\s-1CONFIGURATION\s0\*(R" for further details.
.IP "\fI~/.malheur/malheur.cfg\fR" 4
.IX Item "~/.malheur/malheur.cfg"
Per user configuration file of \fBmalheur\fR.  See \*(L"\s-1CONFIGURATION\s0\*(R" for
further details. If this file does not exist, it is automatically
created using the system wide configuration as template.
.IP "\fI~/.malheur/prototypes.zfa\fR" 4
.IX Item "~/.malheur/prototypes.zfa"
.PD 0
.IP "\fI~/.malheur/rejected.zfa\fR" 4
.IX Item "~/.malheur/rejected.zfa"
.PD
Internal state files of \fBmalheur\fR containing compressed feature
vector array (zfa) of \fBprototypes\fR and \fBrejected reports\fR. The
feature vectors are used for classification and incremental
analysis. See \*(L"\s-1ACTIONS\s0 & \s-1OPTIONS\s0\*(R" for further details.
.SH "EXAMPLES"
.IX Header "EXAMPLES"
\&\fBDistances of program behavior.\fR The first example demonstrates how a
distance matrix is computed for the archive \fIdataset.zip\fR containing
reports of program behavior. The matrix is written to the file
\&\fIout.txt\fR.
.PP
.Vb 1
\&    malheur \-o out.txt \-v distance dataset.zip
.Ve
.PP
The distance matrix reflects the dissimilarity of behavior for each
report in the archive. The entries of the matrix range from 0 to
\&\fIsqrt\fR\|(2), where small values indicate similar behavior and larger
values deviating behavior. The matrix can be used as the basis for
several analysis and data mining techniques, such as hierarchical
clustering, nearest-neighbor classification or multi-dimensional
scaling. It is a generic starting point for research on analysis of
malware behavior.
.PP
\&\fBExtraction of prototypes.\fR Manual inspection of several behavior
reports is tedious and annoying. The second example illustrates how
prototypical reports are extracted from the dataset
\&\fIdataset.zip\fR. The prototypes are written to the file \fIout.txt\fR.
.PP
.Vb 1
\&    malheur \-o out.txt \-v prototype dataset.zip
.Ve
.PP
From all the reports of program behavior, a small subset is selected
which is representative for the full data set. The elements of this
subset are referred to as prototypes. Prior to further analysis of a
large data set, a quick inspection of prototypes enables an overview
of contained behavior and shows patterns typical for the data set.
.PP
\&\fBClustering and classification.\fR This example demonstrates how
clustering and classification are applied for analysis of two data
sets, \fIdataset1.zip\fR and \fIdataset2.zip\fR. The clustering and
classification results are written to \fIout1.txt\fR and \fIout2.txt\fR
respectively.
.PP
.Vb 2
\&    malheur \-o out1.txt \-v cluster dataset1.zip 
\&    malheur \-o out2.txt \-v classify dataset2.zip
.Ve
.PP
First, reports in the archive \fIdataset1.zip\fR are clustered into
groups of similar behavior. The groups can be used to discover novel
malware classes or identify behavioral patterns shared by several
malware instances. Each cluster is represented by a small set of
prototypical reports, such that manual inspectation can usually be
restricted to prototypes. Second, the reports in \fIdataset2.zip\fR are
assigned to the discovered groups. This classification can be used to
filter out variants of classes contained in \fIdataset1.zip\fR, such that
novel malware in \fIdataset2.zip\fR can be identified.
.PP
\&\fBIncremental analysis.\fR In the next example, Malheur is applied for
incremental analysis of a larger data set split into three archives,
namely \fIdataset1.zip\fR, \fIdataset2.zip\fR and \fIdataset3.zip\fR. Results
of this analysis are written to the files \fIout1.txt\fR, \fIout2.txt\fR and
\&\fIout3.txt\fR.
.PP
.Vb 3
\&    malheur \-o out1.txt \-v \-r increment dataset1.zip
\&    malheur \-o out2.txt \-v increment dataset2.zip
\&    malheur \-o out3.txt \-v increment dataset2.zip
.Ve
.PP
First, the archive \fIdataset1.zip\fR is processed using incremental
analysis. The extra option \fB\-r\fR is used to reset the internal state
of Malheur, such that results from previous incremental runs are
discarded. Then, the files \fIdataset2.zip\fR and \fIdataset3.zip\fR are
analyzed where for each archive first known behavior is identified
using classification and novel groups of malware are discovered using
clustering. The intermediate results for each archive are stored in
the Malheur home directory, by default \fI~/.malheur\fR. The incremental
analysis allows to process large data sets efficiently, where run-time
and memory requirements are significantly reduced in comparison to
batch analysis.
.PP
\&\fBDebugging.\fR The reports of malware behavior are embedded in a vector
space where each report is represented by a sparse feature vector. To
understand this representation and trace down problems, a lookup table
can be enabled in the features setting of \fImalheur.cfg\fR.
.PP
.Vb 1
\&    malheur \-o /dev/null \-vvv prototype dataset.zip
.Ve
.PP
The above command extracts prototypes from the provided data
set. However, it also present a lot of verbose information on the
reports and extracted prototypes. In particular, for each prototype
the corresponding feature vector is displayed. If the lookup table is
enabled, the dimensions of this vector are printed with respective
instruction n\-grams (substrings composed of n instructions).
.SH "BUGS"
.IX Header "BUGS"
The reports for analysis need to be textual documents. Although
non-printable characters may be contained in the report files, no
occurrences of the \s-1NUL\s0 character (0x00) are allowed. The behavior of
\&\fBmalheur\fR is undefined in this case.
.PP
The vectorial analysis underlying \fBmalheur\fR does not handle null
vectors, as they can not be scaled to a fixed norm. Consequently,
empty files are discarded during extraction of feature vectors.
.PP
Depending on the linked version of libarchive, \fBmalheur\fR may support
different types of archive formats. For example, zip archives of
version 2 are not generally supported by libarchive. As a fallback,
the use of tar archives is recommended.
.SH "COPYRIGHT"
.IX Header "COPYRIGHT"
Copyright (c) 2009\-2012 Konrad Rieck (konrad@mlsec.org)
University of Goettingen, Berlin Institute of Technology
.PP
This program is free software; you can redistribute it and/or modify
it under the terms of the \s-1GNU\s0 General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at
your option) any later version.  This program is distributed without
any warranty. See the \s-1GNU\s0 General Public License for more details.
