// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var GlobItem, GlobberPreset, PresetBase, constants, finfo_cache, glob_to_regexp, iced, path, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  glob_to_regexp = require('glob-to-regexp');

  path = require('path');

  constants = require('../constants');

  PresetBase = require('./preset_base');

  finfo_cache = require('../file_info_cache');

  GlobItem = (function() {
    function GlobItem(s) {
      this.negation = false;
      this.s = s;
      this.has_path = false;
      this.dirs_only = false;
      this.rxx = null;
      this.empty = false;
      this._analyze();
    }

    GlobItem.prototype._analyze = function() {
      var c, esc_state, s, _i, _len;
      s = this.s.replace(/^[\s]+/g, '').replace(/^\#.*/g, '').replace(/[\s]*$/g, '');
      if (s[0] === '!') {
        this.negation = true;
        s = s.slice(1);
      }
      if (s.slice(-1)[0] === '/') {
        this.dirs_only = true;
        s = s.slice(0, -1);
      }
      if (s.length === 0) {
        return this.empty = true;
      } else {
        esc_state = 0;
        for (_i = 0, _len = s.length; _i < _len; _i++) {
          c = s[_i];
          if ((c === '/') && (!esc_state)) {
            this.has_path = true;
            break;
          } else if ((c === '\\') && (esc_state === 0)) {
            esc_state = 1;
          } else {
            esc_state = 0;
          }
        }
        if (s[0] === '/') {
          s = s.slice(1);
        }
        return this.rxx = glob_to_regexp(s);
      }
    };

    GlobItem.prototype.does_match = function(rel_path, is_a_dir) {
      if (this.empty) {
        return false;
      } else if (this.dirs_only && !is_a_dir) {
        return false;
      } else if (this.rxx.test(rel_path)) {
        return true;
      } else if ((!this.has_path) && (this.rxx.test(path.basename(rel_path)))) {
        return true;
      }
      return false;
    };

    return GlobItem;

  })();

  GlobberPreset = (function(_super) {
    __extends(GlobberPreset, _super);

    function GlobberPreset(working_path, glob_list) {
      var g, gi, _i, _len, _ref;
      this.glob_list = glob_list;
      this.working_path = working_path;
      this.glob_items = [];
      _ref = this.glob_list;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        g = _ref[_i];
        gi = new GlobItem(g);
        if (!gi.empty) {
          this.glob_items.push(gi);
        }
      }
    }

    GlobberPreset.prototype.handle = function(root_dir, path_to_file, cb) {
      var abs_path, err, finfo, gi, is_a_dir, rel_path, res, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      res = constants.ignore_res.NONE;
      abs_path = path.resolve(root_dir, path_to_file);
      rel_path = path.relative(this.working_path, abs_path);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/codesign/src/preset/globber.iced",
            funcname: "GlobberPreset.handle"
          });
          finfo_cache(abs_path, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return finfo = arguments[1];
              };
            })(),
            lineno: 92
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _i, _len, _ref;
          if (err) {
            console.log(err);
          } else {
            is_a_dir = finfo.stat.isDirectory();
            _ref = _this.glob_items;
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              gi = _ref[_i];
              if (gi.does_match(rel_path, is_a_dir)) {
                if (gi.negation) {
                  res = constants.ignore_res.DONT_IGNORE;
                } else {
                  res = constants.ignore_res.IGNORE;
                }
              }
            }
          }
          return cb(res);
        };
      })(this));
    };

    GlobberPreset.from_file = function(f, cb) {
      var full_path, glob_list, gp, working_path, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      full_path = path.resolve(f);
      working_path = path.dirname(full_path);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/codesign/src/preset/globber.iced",
            funcname: "GlobberPreset.from_file"
          });
          PresetBase.file_to_array(f, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return glob_list = arguments[0];
              };
            })(),
            lineno: 114
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          gp = new GlobberPreset(working_path, glob_list);
          return cb(gp);
        };
      })(this));
    };

    return GlobberPreset;

  })(PresetBase);

  module.exports = GlobberPreset;

}).call(this);
