/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import ymsg.network.Session;
import ymsg.network.Util;
import ymsg.network.YahooChatLobby;
import ymsg.network.YahooChatRoom;

public class YahooChatCategory {
    private Session session;
    private String cookieLine;
    protected String name;
    protected long id;
    private int level;
    protected Vector categories;
    protected Vector privateRooms;
    protected Vector publicRooms;
    private static final String PUBLIC_TYPE = "yahoo";
    private static final String PRIVATE_TYPE = "user";
    private static final String PREFIX = "http://";
    private static final String TOP_URL = "insider.msg.yahoo.com/ycontent/?chatcat=0";
    private static final String CAT_URL = "insider.msg.yahoo.com/ycontent/?chatroom_";
    private static String localePrefix = "";
    private static Hashtable chatByNetName = new Hashtable();
    private static String inputLine;
    private static YahooChatCategory rootCategory;

    YahooChatCategory(Session session, long l, int n, String string) {
        this.session = session;
        this.id = l;
        this.level = n;
        this.name = Util.entityDecode(string);
        this.categories = new Vector();
        this.privateRooms = null;
        this.publicRooms = null;
        if (this.session != null) {
            String[] stringArray = this.session.getCookies();
            this.cookieLine = stringArray != null ? stringArray[0] + "; " + stringArray[1] : null;
        }
    }

    void add(YahooChatCategory yahooChatCategory) {
        this.categories.addElement(yahooChatCategory);
    }

    public Vector getPublicRooms() throws IOException {
        if (this.publicRooms == null) {
            this.loadRooms();
        }
        return this.publicRooms;
    }

    public Vector getPrivateRooms() throws IOException {
        if (this.privateRooms == null) {
            this.loadRooms();
        }
        return this.privateRooms;
    }

    public void refresh() throws IOException {
        this.loadRooms();
    }

    public Vector getCategories() {
        return this.categories;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    private void loadRooms() throws IOException {
        String string;
        this.publicRooms = new Vector();
        this.privateRooms = new Vector();
        YahooChatRoom yahooChatRoom = null;
        String string2 = PREFIX + localePrefix + CAT_URL;
        URLConnection uRLConnection = new URL(string2 + this.id).openConnection();
        Util.initURLConnection(uRLConnection);
        if (YahooChatCategory.rootCategory.cookieLine != null) {
            uRLConnection.setRequestProperty("Cookie", YahooChatCategory.rootCategory.cookieLine);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Util.wrapIn(uRLConnection.getInputStream())));
        inputLine = string = bufferedReader.readLine();
        string = YahooChatCategory.nextTag(bufferedReader);
        while (string != null) {
            Object object;
            Hashtable hashtable;
            if (string.startsWith("<room ")) {
                hashtable = YahooChatCategory.getAttrs(string);
                String string3 = (String)hashtable.get("type");
                long l = Long.parseLong((String)hashtable.get("id"));
                String string4 = (String)hashtable.get("name");
                object = (String)hashtable.get("topic");
                yahooChatRoom = new YahooChatRoom(l, string4, (String)object, string3.equals(PUBLIC_TYPE));
            } else if (string.startsWith("</room>")) {
                if (yahooChatRoom.isPublic()) {
                    this.publicRooms.addElement(yahooChatRoom);
                } else {
                    this.privateRooms.addElement(yahooChatRoom);
                }
            } else if (string.startsWith("<lobby ")) {
                hashtable = YahooChatCategory.getAttrs(string);
                int n = Integer.parseInt(this._getDef(hashtable, "count", "0"));
                int n2 = Integer.parseInt(this._getDef(hashtable, "users", "0"));
                int n3 = Integer.parseInt(this._getDef(hashtable, "voices", "0"));
                int n4 = Integer.parseInt(this._getDef(hashtable, "webcams", "0"));
                object = new YahooChatLobby(n, n2, n3, n4);
                yahooChatRoom.addLobby((YahooChatLobby)object);
                chatByNetName.put(((YahooChatLobby)object).getNetworkName(), object);
            }
            string = YahooChatCategory.nextTag(bufferedReader);
        }
        bufferedReader.close();
    }

    private String _getDef(Hashtable hashtable, String string, String string2) {
        if (hashtable.containsKey(string)) {
            return (String)hashtable.get(string);
        }
        return string2;
    }

    public static YahooChatCategory loadCategories() throws IOException {
        return YahooChatCategory.loadCategories(null);
    }

    public static YahooChatCategory loadCategories(Session session) throws IOException {
        String string;
        if (rootCategory != null) {
            return rootCategory;
        }
        Stack<YahooChatCategory> stack = new Stack<YahooChatCategory>();
        rootCategory = new YahooChatCategory(session, 0L, 0, "<root>");
        stack.push(rootCategory);
        String string2 = PREFIX + localePrefix + TOP_URL;
        URLConnection uRLConnection = new URL(string2).openConnection();
        Util.initURLConnection(uRLConnection);
        if (YahooChatCategory.rootCategory.cookieLine != null) {
            uRLConnection.setRequestProperty("Cookie", YahooChatCategory.rootCategory.cookieLine);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Util.wrapIn(uRLConnection.getInputStream())));
        inputLine = string = bufferedReader.readLine();
        string = YahooChatCategory.nextTag(bufferedReader);
        int n = 0;
        while (string != null) {
            Hashtable hashtable;
            if (string.startsWith("<content ")) {
                hashtable = YahooChatCategory.getAttrs(string);
                YahooChatCategory.rootCategory.id = Long.parseLong((String)hashtable.get("time"));
            } else if (string.startsWith("<category ")) {
                ++n;
                try {
                    hashtable = YahooChatCategory.getAttrs(string);
                    long l = Long.parseLong((String)hashtable.get("id"));
                    String string3 = (String)hashtable.get("name");
                    YahooChatCategory yahooChatCategory = new YahooChatCategory(session, l, n, string3);
                    YahooChatCategory yahooChatCategory2 = (YahooChatCategory)stack.peek();
                    yahooChatCategory2.add(yahooChatCategory);
                    stack.push(yahooChatCategory);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.startsWith("</category>")) {
                stack.pop();
            }
            string = YahooChatCategory.nextTag(bufferedReader);
        }
        bufferedReader.close();
        return rootCategory;
    }

    public static void setLocalePrefix(String string) {
        localePrefix = string == null ? "" : string + ".";
    }

    public static String getLocale() {
        return localePrefix.length() <= 0 ? "us" : localePrefix.substring(0, 2);
    }

    private static String nextTag(BufferedReader bufferedReader) throws IOException {
        int n;
        boolean bl;
        if (inputLine == null) {
            return null;
        }
        while (inputLine.trim().length() <= 0 || inputLine.indexOf("<") < 0) {
            inputLine = bufferedReader.readLine();
            if (inputLine != null) continue;
            return null;
        }
        inputLine = inputLine.substring(inputLine.indexOf("<"));
        do {
            bl = false;
            for (int i = 0; i < inputLine.length(); ++i) {
                if (inputLine.charAt(i) != '\"') continue;
                bl = !bl;
            }
            if (!bl) continue;
            String string = bufferedReader.readLine();
            if (string == null) {
                string = "\"";
            }
            inputLine = inputLine + string;
        } while (bl);
        StringBuffer stringBuffer = new StringBuffer();
        bl = false;
        block8: for (n = 0; n < inputLine.length(); ++n) {
            switch (inputLine.charAt(n)) {
                case '<': {
                    stringBuffer.append(bl ? "&lt;" : "<");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append(bl ? "&gt;" : ">");
                    continue block8;
                }
                case '\"': {
                    bl = !bl;
                }
                default: {
                    stringBuffer.append(inputLine.charAt(n));
                }
            }
        }
        inputLine = stringBuffer.toString();
        n = inputLine.indexOf(">");
        String string = null;
        if (n >= 0) {
            string = inputLine.substring(0, n + 1);
            inputLine = inputLine.substring(n + 1);
        } else {
            string = inputLine;
            inputLine = "";
        }
        return string;
    }

    private static Hashtable getAttrs(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = string.indexOf("=\"");
        while (n >= 0) {
            int n2 = n + 2;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            n = string2.indexOf(" ");
            if (n >= 0) {
                string2 = string2.substring(n + 1);
            }
            if ((n = string3.indexOf("\"")) >= 0) {
                string3 = string3.substring(0, n);
            }
            hashtable.put(string2, string3);
            string = string.substring(n2 += string3.length() + 1);
            n = string.indexOf("=\"");
        }
        return hashtable;
    }

    static YahooChatLobby getLobby(String string) {
        return (YahooChatLobby)chatByNetName.get(string);
    }

    public String toString() {
        return new StringBuffer("name=").append(this.name).append(" id=").append(this.id).toString();
    }
}

