/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;
import ymsg.network.DebugInputStream;
import ymsg.network.DebugOutputStream;
import ymsg.network.NetworkConstants;
import ymsg.network.Util;

class HTTPConnection
implements NetworkConstants {
    protected Socket socket;
    protected PushbackInputStream pbis;
    protected DataOutputStream dos;
    private DebugInputStream dbis = null;
    protected String me;
    private boolean eof = false;
    private String lineEnd = "\r\n";

    HTTPConnection(String string, URL uRL, boolean bl) throws IOException {
        String string2;
        String string3;
        int n;
        String string4;
        if (bl) {
            this.lineEnd = "\n";
        }
        if ((string4 = Util.httpProxyHost()) == null || this.doNotProxy(uRL.getHost())) {
            string4 = uRL.getHost();
            n = uRL.getPort();
            if (n <= -1) {
                n = 80;
            }
            string3 = string + " " + uRL.getFile() + " HTTP/1.1";
            string2 = null;
        } else {
            n = Util.httpProxyPort();
            string3 = string + " " + uRL.toString() + " HTTP/1.1";
            string2 = Util.httpProxyAuth();
        }
        this.me = "HTTPConnection to:" + string4 + ":" + n + " for:[" + string3 + "]";
        this.socket = new Socket(string4, n);
        this.openStreams();
        this.println(string3);
        if (string2 != null) {
            this.println("Proxy-Authorization: " + string2);
        }
    }

    HTTPConnection(String string, URL uRL) throws IOException {
        this(string, uRL, false);
    }

    private void openStreams() throws IOException {
        if (Util.debugMode) {
            this.dbis = new DebugInputStream(this.socket.getInputStream());
            this.pbis = new PushbackInputStream(this.dbis);
            this.dos = new DataOutputStream(new DebugOutputStream(this.socket.getOutputStream()));
        } else {
            this.pbis = new PushbackInputStream(this.socket.getInputStream());
            this.dos = new DataOutputStream(this.socket.getOutputStream());
        }
    }

    String readLine() throws IOException {
        String string = "";
        if (this.eof) {
            return null;
        }
        int n = this.pbis.read();
        if (n == 255 || n < 0) {
            this.eof = true;
            return null;
        }
        while (n != 255 && n >= 0 && n != 10 && n != 13) {
            string = string + (char)n;
            n = this.pbis.read();
        }
        if (n == 255 || n < 0) {
            this.eof = true;
        } else {
            int n2 = this.pbis.read();
            if (n == 10 && n2 != 13 || n == 13 && n2 != 10) {
                this.pbis.unread(n2);
            }
        }
        return string;
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        return this.pbis.read(byArray, n, n2);
    }

    int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    void println(String string) throws IOException {
        this.dos.writeBytes(string + this.lineEnd);
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        this.dos.write(byArray, n, n2);
    }

    void write(byte[] byArray) throws IOException {
        this.dos.write(byArray);
    }

    void writeUShort(int n) throws IOException {
        this.dos.writeShort(n & 0xFFFF);
    }

    void writeUInt(long l) throws IOException {
        this.dos.writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    void flush() throws IOException {
        this.dos.flush();
    }

    void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.sectionEnd();
    }

    void sectionEnd() {
        if (this.dbis != null) {
            this.dbis.debugDump();
        }
    }

    private boolean doNotProxy(String string) {
        string = string.toLowerCase();
        String string2 = System.getProperty("http.nonProxyHosts", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!(string2.startsWith("*") ? string.endsWith((string2 = string2.substring(1)).toLowerCase()) : string.equalsIgnoreCase(string2))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.me;
    }
}

