/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import net.sf.jml.Email;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnOwner;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.exception.IncorrectPasswordException;
import net.sf.jml.exception.LoginException;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnOwnerImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingSYN;
import net.sf.jml.protocol.outgoing.OutgoingUSRAuthNS;
import net.sf.jml.protocol.soap.SSO;
import net.sf.jml.util.JmlConstants;
import net.sf.jml.util.StringUtils;

public class IncomingUSR
extends MsnIncomingMessage {
    private static final Pattern passportUrlPattern = Pattern.compile(".*DALogin=([^,]*),.*");
    private static final Pattern ticketPattern = Pattern.compile(".*from-PP='([^']*)'.*");

    public IncomingUSR(MsnProtocol protocol) {
        super(protocol);
    }

    private boolean isLoginSuccess() {
        return "OK".equals(this.getParam(0));
    }

    public String getAuthStr() {
        return this.getParam(2);
    }

    public String getPolicy() {
        return this.getParam(2);
    }

    public String getNonce() {
        return this.getParam(3);
    }

    private boolean isLoginIntoSB() {
        return !this.getParam(this.getParamCount() - 1).equals("0");
    }

    public Email getEmail() {
        return Email.parseStr(this.getParam(1));
    }

    public String getDisplayName() {
        if (this.isLoginIntoSB() || this.protocol.before(MsnProtocol.MSNP10)) {
            return StringUtils.urlDecode(this.getParam(2));
        }
        return this.getEmail().getEmailAddress();
    }

    public boolean isVerified() {
        if (this.isLoginIntoSB()) {
            return true;
        }
        if (this.protocol.before(MsnProtocol.MSNP10)) {
            return "1".equals(this.getParam(3));
        }
        return "1".equals(this.getParam(2));
    }

    protected void messageReceived(final MsnSession session) {
        super.messageReceived(session);
        MsnSwitchboard switchboard = session.getSwitchboard();
        final MsnMessenger messenger = session.getMessenger();
        if (this.isLoginSuccess()) {
            if (this.isLoginIntoSB()) {
                if (switchboard != null) {
                    ((AbstractMessenger)messenger).fireSwitchboardStarted(switchboard);
                }
            } else {
                MsnOwnerImpl owner = (MsnOwnerImpl)messenger.getOwner();
                owner.setVerified(this.isVerified());
                owner.fSetDisplayName(this.getDisplayName());
                ((AbstractMessenger)messenger).fireLoginCompleted();
                if (this.protocol.before(MsnProtocol.MSNP13)) {
                    OutgoingSYN message = new OutgoingSYN(this.protocol);
                    message.setCachedVersion(messenger.getContactList().getVersion());
                    messenger.send(message);
                } else {
                    session.getContactList().dispatch();
                }
            }
        } else {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private String getPassportUrlSlow() throws IOException {
                    HttpURLConnection conn = null;
                    try {
                        conn = (HttpsURLConnection)new URL("https://nexus.passport.com/rdr/pprdr.asp").openConnection();
                        conn.setUseCaches(false);
                        Matcher matcher = passportUrlPattern.matcher(conn.getHeaderField("PassportURLs"));
                        if (matcher.matches()) {
                            String string = "https://" + matcher.group(1);
                            return string;
                        }
                        String string = null;
                        return string;
                    }
                    finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }

                private String getPassportUrl() throws IOException {
                    if (JmlConstants.FAST_SSL_LOGIN) {
                        return "https://login.live.com/login2.srf";
                    }
                    return this.getPassportUrlSlow();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private String getLoginTicket(String visitUrl, String passport, String password, String challengeStr) throws IOException {
                    HttpURLConnection conn = null;
                    try {
                        conn = (HttpsURLConnection)new URL(visitUrl).openConnection();
                        conn.setUseCaches(false);
                        conn.setRequestProperty("Authorization", "Passport1.4 OrgVerb=GET,OrgURL=" + StringUtils.urlEncode(visitUrl) + ",sign-in=" + StringUtils.urlEncode(passport) + ",pwd=" + StringUtils.urlEncode(password) + "," + challengeStr);
                        switch (conn.getResponseCode()) {
                            case 200: {
                                Matcher matcher = ticketPattern.matcher(conn.getHeaderField("Authentication-Info"));
                                if (matcher.matches()) {
                                    String string = matcher.group(1);
                                    return string;
                                }
                                String string = null;
                                return string;
                            }
                            case 302: {
                                visitUrl = conn.getHeaderField("Location");
                                String string = this.getLoginTicket(visitUrl, passport, password, challengeStr);
                                return string;
                            }
                            case 401: {
                                String string = null;
                                return string;
                            }
                        }
                        return null;
                    }
                    finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }

                public void run() {
                    try {
                        if (IncomingUSR.this.protocol.before(MsnProtocol.MSNP13)) {
                            OutgoingUSRAuthNS outgoing = new OutgoingUSRAuthNS(IncomingUSR.this.protocol);
                            String ticket = this.getLoginTicket(this.getPassportUrl(), messenger.getOwner().getEmail().getEmailAddress(), ((MsnOwnerImpl)messenger.getOwner()).getPassword(), IncomingUSR.this.getAuthStr());
                            if (ticket == null) {
                                ((AbstractMessenger)messenger).fireExceptionCaught(new IncorrectPasswordException());
                                return;
                            }
                            outgoing.setTicket(ticket);
                            messenger.send(outgoing);
                        } else {
                            String pass;
                            String nonce = IncomingUSR.this.getNonce();
                            String policy = IncomingUSR.this.getPolicy();
                            if (nonce == null) {
                                ((AbstractMessenger)messenger).fireExceptionCaught(new LoginException("Login Failed, nonce is missing!"));
                                return;
                            }
                            MsnOwner owner = session.getMessenger().getOwner();
                            if (!(owner instanceof MsnOwnerImpl)) {
                                return;
                            }
                            String username = owner.getEmail().getEmailAddress();
                            SSO sso = session.createSSO(username, pass = ((MsnOwnerImpl)owner).getPassword(), policy, nonce);
                            String ticket = sso.getTicket();
                            if (ticket == null) {
                                ((AbstractMessenger)messenger).fireExceptionCaught(new LoginException("Login Failed, error making ticket!"));
                                return;
                            }
                            MsnMessenger messenger2 = session.getMessenger();
                            OutgoingUSRAuthNS outgoing = new OutgoingUSRAuthNS(IncomingUSR.this.protocol);
                            if (ticket == null) {
                                ((AbstractMessenger)messenger2).fireExceptionCaught(new IncorrectPasswordException());
                                return;
                            }
                            outgoing.setTicket(ticket);
                            messenger2.send(outgoing);
                        }
                    }
                    catch (IOException e) {
                        ((AbstractMessenger)messenger).fireExceptionCaught(e);
                    }
                }
            }.start();
        }
    }
}

