/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import net.sf.profiler4j.agent.Agent;
import net.sf.profiler4j.agent.Config;
import net.sf.profiler4j.agent.Log;
import net.sf.profiler4j.agent.Rule;
import net.sf.profiler4j.agent.ThreadProfiler;
import net.sf.profiler4j.agent.asm.ClassAdapter;
import net.sf.profiler4j.agent.asm.ClassReader;
import net.sf.profiler4j.agent.asm.ClassVisitor;
import net.sf.profiler4j.agent.asm.ClassWriter;
import net.sf.profiler4j.agent.asm.MethodVisitor;
import net.sf.profiler4j.agent.asm.Type;
import net.sf.profiler4j.agent.asm.commons.AdviceAdapter;

public class BytecodeTransformer {
    public static final AtomicLong totalTransformTime = new AtomicLong(0L);
    private static Pattern getterRegex = Pattern.compile("^get[A-Z].*$");
    private static Pattern getterBoolRegex = Pattern.compile("^is[A-Z].*$");
    private static Pattern setterRegex = Pattern.compile("^set[A-Z].*$");
    static volatile boolean enabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] transform(String className, ClassLoader loader, byte[] classBytes, Config config) throws IOException {
        if (!enabled) {
            return null;
        }
        long t0 = System.nanoTime();
        try {
            byte[] bytes = BytecodeTransformer.transformMethodAsNeeded(classBytes, config);
            if (bytes != null) {
                Log.print(2, "Probed an CHANGED class " + className);
            } else {
                Log.print(2, "Probed class " + className);
            }
            if (bytes != null) {
                Object object = Agent.modifiedClassNames;
                synchronized (object) {
                    ++Agent.modifiedClassCount;
                    if (Agent.modifiedClassNames.contains(className)) {
                        Log.print(0, "Found duplicated class name " + className + " in loader " + (loader == null ? "BootClassLoader" : loader.toString()));
                    } else {
                        Agent.modifiedClassNames.add(className);
                    }
                }
                object = bytes;
                return object;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            long dt = System.nanoTime() - t0;
            totalTransformTime.addAndGet(dt);
        }
    }

    private static byte[] transformMethodAsNeeded(byte[] classBytes, Config config) {
        ClassReader cr = new ClassReader(classBytes);
        ClassWriter cw = new ClassWriter(1);
        P4JEnterExitClassAdapter ca = new P4JEnterExitClassAdapter(cw, config);
        cr.accept(ca, 0);
        if (ca.changedMethods > 0) {
            return cw.toByteArray();
        }
        return null;
    }

    private static boolean canProfileMethod(Type classType, int access, String name, String desc, String signature, String[] exceptions, Config config, String globalName, String localName) {
        if ((access & 0x400 | access & 0x100 | access & 0x1000) != 0) {
            return false;
        }
        List<Rule> rules = config.getRules();
        if (rules == null) {
            return false;
        }
        Rule selectedRule = null;
        for (Rule rule : rules) {
            if (!rule.matches(globalName)) continue;
            selectedRule = rule;
            break;
        }
        if (selectedRule == null) {
            return false;
        }
        if (selectedRule.getAction() == Rule.Action.ACCEPT) {
            if (selectedRule.isBooleanOptionSet(Rule.Option.BEANPROPS, config) && BytecodeTransformer.isGetterSetter(access, name, desc)) {
                return false;
            }
            boolean packageAccess = (access & 7) == 0;
            boolean protectedAccess = (access & 4) != 0;
            boolean publicAccess = (access & 1) != 0;
            String accessStr = selectedRule.getOption(Rule.Option.ACCESS, config);
            boolean acceptVisiblity = "private".equals(accessStr) || "package".equals(accessStr) && (packageAccess || protectedAccess || publicAccess) || "protected".equals(access) && (protectedAccess || publicAccess) || "public".equals(access) && publicAccess;
            return acceptVisiblity;
        }
        return false;
    }

    private static boolean isGetterSetter(int flag, String name, String methodDescriptor) {
        if ((1 | flag) == 0 || (8 | flag | (0x100 | flag) | (0x400 | flag) | (0x20 | flag)) != 0) {
            return false;
        }
        Type[] pTypes = Type.getArgumentTypes(methodDescriptor);
        Type rType = Type.getReturnType(methodDescriptor);
        if (getterRegex.matcher(name).matches() || getterBoolRegex.matcher(name).matches()) {
            return pTypes.length == 0 && !rType.equals(Type.VOID_TYPE);
        }
        if (setterRegex.matcher(name).matches()) {
            return pTypes.length == 1 && !rType.equals(Type.VOID_TYPE);
        }
        return false;
    }

    private static String[] makeMethodName(Type classType, String methodName, String methodDescriptor) {
        StringBuilder sbName = new StringBuilder();
        StringBuilder sbMethod = new StringBuilder();
        sbName.append(classType.getClassName());
        sbName.append(".");
        sbMethod.append(methodName);
        sbMethod.append("(");
        boolean comma = false;
        for (Type pt : Type.getArgumentTypes(methodDescriptor)) {
            if (comma) {
                sbMethod.append(",");
            }
            comma = true;
            sbMethod.append(pt.getClassName());
        }
        sbMethod.append(")");
        sbName.append((CharSequence)sbMethod);
        return new String[]{sbName.toString(), sbMethod.toString()};
    }

    private static class P4JEnterExitAdviceAdapter
    extends AdviceAdapter {
        private int gmid;

        public P4JEnterExitAdviceAdapter(MethodVisitor mv, int access, String name, String desc, int gmid) {
            super(mv, access, name, desc);
            this.gmid = gmid;
        }

        protected void onMethodEnter() {
            this.mv.visitLdcInsn(new Integer(this.gmid));
            this.mv.visitMethodInsn(184, "net/sf/profiler4j/agent/ThreadProfiler", "enterMethod", "(I)V");
        }

        protected void onMethodExit(int opcode) {
            this.mv.visitLdcInsn(new Integer(this.gmid));
            this.mv.visitMethodInsn(184, "net/sf/profiler4j/agent/ThreadProfiler", "exitMethod", "(I)V");
        }
    }

    private static class P4JEnterExitClassAdapter
    extends ClassAdapter {
        Type classType;
        int changedMethods;
        Config config;

        public P4JEnterExitClassAdapter(ClassVisitor cv, Config config) {
            super(cv);
            this.config = config;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.classType = Type.getType("L" + name + ";");
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String localName;
            String[] names = BytecodeTransformer.makeMethodName(this.classType, name, desc);
            String globalName = names[0];
            if (BytecodeTransformer.canProfileMethod(this.classType, access, name, desc, signature, exceptions, this.config, globalName, localName = names[1])) {
                if (this.changedMethods == 0) {
                    Log.print(1, "Instrumenting class " + this.classType.getClassName());
                }
                int gmid = ThreadProfiler.newMethod(globalName);
                Log.print(3, "    method " + localName);
                MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
                P4JEnterExitAdviceAdapter ma = new P4JEnterExitAdviceAdapter(mv, access, name, desc, gmid);
                ++this.changedMethods;
                return ma;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

