/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCInfo;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.BasicRTCPTerminationStrategy;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCache;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCacheProcessor;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.neomedia.RTPTranslator;

public class ReceiverReporting {
    private final BasicRTCPTerminationStrategy strategy;
    private FeedbackCacheProcessor feedbackCacheProcessor;

    public ReceiverReporting(BasicRTCPTerminationStrategy strategy) {
        this.strategy = strategy;
    }

    public RTCPPacket[] makeReports() {
        RTCPRRPacket bestReceiverFeedback;
        RTCPReportBlock[] reports;
        RTCPTransmitter rtcpTransmitter = this.strategy.getRTCPReportBuilder().getRTCPTransmitter();
        if (rtcpTransmitter == null) {
            throw new IllegalStateException("rtcpTransmitter is not set");
        }
        RTPTranslator t = this.strategy.getRTPTranslator();
        if (t == null || !(t instanceof RTPTranslatorImpl)) {
            return new RTCPPacket[0];
        }
        int localSSRC = (int)((RTPTranslatorImpl)t).getLocalSSRC(null);
        Vector<RTCPRRPacket> packets = new Vector<RTCPRRPacket>();
        long time = System.currentTimeMillis();
        RTCPReportBlock[] firstrep = reports = this.makeReceiverReports(time);
        if (reports.length > 31) {
            firstrep = new RTCPReportBlock[31];
            System.arraycopy(reports, 0, firstrep, 0, 31);
        }
        packets.addElement(new RTCPRRPacket(localSSRC, firstrep));
        if (firstrep != reports) {
            for (int offset = 31; offset < reports.length; offset += 31) {
                if (reports.length - offset < 31) {
                    firstrep = new RTCPReportBlock[reports.length - offset];
                }
                System.arraycopy(reports, offset, firstrep, 0, firstrep.length);
                RTCPRRPacket rrp = new RTCPRRPacket(localSSRC, firstrep);
                packets.addElement(rrp);
            }
        }
        if (this.feedbackCacheProcessor == null) {
            FeedbackCache feedbackCache = this.strategy.getFeedbackCache();
            this.feedbackCacheProcessor = new FeedbackCacheProcessor(feedbackCache);
            this.feedbackCacheProcessor.setPercentile(70);
        }
        if ((bestReceiverFeedback = this.feedbackCacheProcessor.makeReports(localSSRC)) != null && ((RTCPPacket[])bestReceiverFeedback).length != 0) {
            for (RTCPRRPacket packet : bestReceiverFeedback) {
                if (packet.type != 206 || !(packet instanceof RTCPFBPacket) || ((RTCPFBPacket)packet).fmt != 15) continue;
                packets.add(packet);
            }
        }
        Object[] res = new RTCPPacket[packets.size()];
        packets.copyInto(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, RTCPReportBlock> makeReceiverReportsMap(long time) {
        HashMap<Integer, RTCPReportBlock> reports = new HashMap<Integer, RTCPReportBlock>();
        RTCPTransmitter rtcpTransmitter = this.strategy.getRTCPReportBuilder().getRTCPTransmitter();
        if (rtcpTransmitter == null) {
            throw new IllegalStateException("rtcpTransmitter is not set");
        }
        Enumeration elements = rtcpTransmitter.cache.cache.elements();
        while (elements.hasMoreElements()) {
            SSRCInfo info;
            SSRCInfo sSRCInfo = info = (SSRCInfo)elements.nextElement();
            synchronized (sSRCInfo) {
                if (!info.ours) {
                    RTCPReportBlock receiverReport = info.makeReceiverReport(time);
                    reports.put(info.ssrc, receiverReport);
                }
            }
        }
        return reports;
    }

    private RTCPReportBlock[] makeReceiverReports(long time) {
        Collection<RTCPReportBlock> reports = this.makeReceiverReportsMap(time).values();
        return reports.toArray(new RTCPReportBlock[reports.size()]);
    }
}

