/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.portaudio;

import java.awt.Component;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.control.DiagnosticsControl;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.AudioSystem2;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.impl.neomedia.device.PortAudioSystem;
import org.jitsi.impl.neomedia.device.UpdateAvailableDeviceListListener;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.portaudio.DataSource;
import org.jitsi.impl.neomedia.portaudio.Pa;
import org.jitsi.impl.neomedia.portaudio.PortAudioException;
import org.jitsi.service.neomedia.BasicVolumeControl;
import org.jitsi.util.Logger;

public class PortAudioStream
extends AbstractPullBufferStream<DataSource> {
    private static final Logger logger = Logger.getLogger(PortAudioStream.class);
    private static final long NEVER = 0L;
    private final boolean audioQualityImprovement;
    private int bytesPerBuffer;
    private String deviceID;
    private final DiagnosticsControl diagnosticsControl = new DiagnosticsControl(){

        public Component getControlComponent() {
            return null;
        }

        @Override
        public long getMalfunctioningSince() {
            return PortAudioStream.this.readIsMalfunctioningSince;
        }

        @Override
        public String toString() {
            long info;
            int index;
            String id = PortAudioStream.this.deviceID;
            String name = null;
            if (PortAudioStream.this.deviceID != null && (index = Pa.getDeviceIndex(id, 1, 0)) != -1 && (info = Pa.GetDeviceInfo(index)) != 0L) {
                name = Pa.DeviceInfo_getName(info);
            }
            return name;
        }
    };
    private AudioFormat format;
    private int framesPerBuffer;
    private final GainControl gainControl;
    private long inputParameters = 0L;
    private final UpdateAvailableDeviceListListener paUpdateAvailableDeviceListListener = new UpdateAvailableDeviceListListener(){
        private String deviceID = null;
        private boolean start = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void didUpdateAvailableDeviceList() throws Exception {
            PortAudioStream portAudioStream = PortAudioStream.this;
            synchronized (portAudioStream) {
                try {
                    PortAudioStream.this.waitWhileStreamIsBusy();
                    if (PortAudioStream.this.stream == 0L) {
                        PortAudioStream.this.setDeviceID(this.deviceID);
                        if (this.start) {
                            PortAudioStream.this.start();
                        }
                    }
                }
                finally {
                    this.deviceID = null;
                    this.start = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void willUpdateAvailableDeviceList() throws Exception {
            PortAudioStream portAudioStream = PortAudioStream.this;
            synchronized (portAudioStream) {
                PortAudioStream.this.waitWhileStreamIsBusy();
                if (PortAudioStream.this.stream == 0L) {
                    this.deviceID = null;
                    this.start = false;
                } else {
                    this.deviceID = PortAudioStream.this.deviceID;
                    this.start = PortAudioStream.this.started;
                    boolean disconnected = false;
                    try {
                        PortAudioStream.this.setDeviceID(null);
                        disconnected = true;
                    }
                    finally {
                        if (!disconnected) {
                            this.deviceID = null;
                            this.start = false;
                        }
                    }
                }
            }
        }
    };
    private long readIsMalfunctioningSince = 0L;
    private int sequenceNumber = 0;
    private boolean started = false;
    private long stream = 0L;
    private boolean streamIsBusy = false;

    public static void yield() {
        boolean interrupted = false;
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public PortAudioStream(DataSource dataSource, FormatControl formatControl, boolean audioQualityImprovement) {
        super(dataSource, formatControl);
        this.audioQualityImprovement = audioQualityImprovement;
        MediaServiceImpl mediaServiceImpl = NeomediaServiceUtils.getMediaServiceImpl();
        this.gainControl = mediaServiceImpl == null ? null : (GainControl)mediaServiceImpl.getInputVolumeControl();
        AudioSystem2 audioSystem = (AudioSystem2)AudioSystem.getAudioSystem("portaudio");
        if (audioSystem != null) {
            audioSystem.addUpdateAvailableDeviceListListener(this.paUpdateAvailableDeviceListListener);
        }
    }

    private void connect() throws IOException {
        AudioSystem audioSystem;
        int deviceIndex = Pa.getDeviceIndex(this.deviceID, 1, 0);
        if (deviceIndex == -1) {
            throw new IOException("The audio device " + this.deviceID + " appears to be disconnected.");
        }
        AudioFormat format = (AudioFormat)this.getFormat();
        int channels = format.getChannels();
        if (channels == -1) {
            channels = 1;
        }
        int sampleSizeInBits = format.getSampleSizeInBits();
        long sampleFormat = Pa.getPaSampleFormat(sampleSizeInBits);
        double sampleRate = format.getSampleRate();
        int framesPerBuffer = (int)(sampleRate * 20.0 / (double)(channels * 1000));
        try {
            this.inputParameters = Pa.StreamParameters_new(deviceIndex, channels, sampleFormat, Pa.getSuggestedLatency());
            this.stream = Pa.OpenStream(this.inputParameters, 0L, sampleRate, framesPerBuffer, 3L, null);
        }
        catch (PortAudioException paex) {
            logger.error("Failed to open " + this.getClass().getSimpleName(), paex);
            IOException ioex = new IOException(paex.getLocalizedMessage());
            ioex.initCause(paex);
            throw ioex;
        }
        finally {
            if (this.stream == 0L && this.inputParameters != 0L) {
                Pa.StreamParameters_free(this.inputParameters);
                this.inputParameters = 0L;
            }
        }
        if (this.stream == 0L) {
            throw new IOException("Pa_OpenStream");
        }
        this.framesPerBuffer = framesPerBuffer;
        this.bytesPerBuffer = Pa.GetSampleSize(sampleFormat) * channels * framesPerBuffer;
        this.format = new AudioFormat("LINEAR", sampleRate, sampleSizeInBits, channels, 0, 1, -1, -1.0, Format.byteArray);
        boolean denoise = false;
        boolean echoCancel = false;
        long echoCancelFilterLengthInMillis = 100L;
        if (this.audioQualityImprovement && (audioSystem = AudioSystem.getAudioSystem("portaudio")) != null) {
            DeviceConfiguration devCfg;
            MediaServiceImpl mediaServiceImpl;
            denoise = audioSystem.isDenoise();
            echoCancel = audioSystem.isEchoCancel();
            if (echoCancel && (mediaServiceImpl = NeomediaServiceUtils.getMediaServiceImpl()) != null && (devCfg = mediaServiceImpl.getDeviceConfiguration()) != null) {
                echoCancelFilterLengthInMillis = devCfg.getEchoCancelFilterLengthInMillis();
            }
        }
        Pa.setDenoise(this.stream, denoise);
        Pa.setEchoFilterLengthInMillis(this.stream, echoCancel ? echoCancelFilterLengthInMillis : 0L);
        if (this.readIsMalfunctioningSince != 0L) {
            this.setReadIsMalfunctioning(false);
        }
    }

    @Override
    protected Format doGetFormat() {
        return this.format == null ? super.doGetFormat() : this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        String message;
        PortAudioStream portAudioStream = this;
        synchronized (portAudioStream) {
            if (this.stream == 0L) {
                message = this.getClass().getName() + " is disconnected.";
            } else if (!this.started) {
                message = this.getClass().getName() + " is stopped.";
            } else {
                message = null;
                this.streamIsBusy = true;
            }
            if (message != null && this.readIsMalfunctioningSince != 0L) {
                this.setReadIsMalfunctioning(false);
            }
        }
        if (message != null) {
            PortAudioStream.yield();
            throw new IOException(message);
        }
        long errorCode = 0L;
        Pa.HostApiTypeId hostApiType = null;
        try {
            byte[] data = AbstractCodec2.validateByteArraySize(buffer, this.bytesPerBuffer, false);
            try {
                Pa.ReadStream(this.stream, data, this.framesPerBuffer);
            }
            catch (PortAudioException pae) {
                errorCode = pae.getErrorCode();
                hostApiType = pae.getHostApiType();
                logger.error("Failed to read from PortAudio stream.", pae);
                IOException ioe = new IOException(pae.getLocalizedMessage());
                ioe.initCause(pae);
                throw ioe;
            }
            if (this.gainControl != null) {
                BasicVolumeControl.applyGain(this.gainControl, data, 0, this.bytesPerBuffer);
            }
            long bufferTimeStamp = System.nanoTime();
            buffer.setFlags(128);
            if (this.format != null) {
                buffer.setFormat((Format)this.format);
            }
            buffer.setHeader(null);
            buffer.setLength(this.bytesPerBuffer);
            buffer.setOffset(0);
            buffer.setSequenceNumber((long)this.sequenceNumber++);
            buffer.setTimeStamp(bufferTimeStamp);
        }
        finally {
            boolean yield = false;
            PortAudioStream portAudioStream2 = this;
            synchronized (portAudioStream2) {
                this.streamIsBusy = false;
                this.notifyAll();
                if (errorCode == 0L) {
                    if (this.readIsMalfunctioningSince != 0L) {
                        this.setReadIsMalfunctioning(false);
                    }
                } else if (-9987L == errorCode || Pa.HostApiTypeId.paMME.equals((Object)hostApiType) && 6L == errorCode) {
                    if (this.readIsMalfunctioningSince == 0L) {
                        this.setReadIsMalfunctioning(true);
                    }
                    yield = true;
                }
            }
            if (yield) {
                PortAudioStream.yield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setDeviceID(String deviceID) throws IOException {
        if (this.deviceID != null) {
            this.waitWhileStreamIsBusy();
            if (this.stream != 0L) {
                if (this.started) {
                    try {
                        this.stop();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                boolean closed = false;
                try {
                    Pa.CloseStream(this.stream);
                    closed = true;
                }
                catch (PortAudioException pae) {
                    long errorCode = pae.getErrorCode();
                    if (errorCode == -9987L || Pa.HostApiTypeId.paMME.equals((Object)pae.getHostApiType()) && errorCode == 6L) {
                        closed = true;
                    }
                    if (!closed) {
                        logger.error("Failed to close " + this.getClass().getSimpleName(), pae);
                        IOException ioe = new IOException(pae.getLocalizedMessage());
                        ioe.initCause(pae);
                        throw ioe;
                    }
                }
                finally {
                    if (closed) {
                        this.stream = 0L;
                        if (this.inputParameters != 0L) {
                            Pa.StreamParameters_free(this.inputParameters);
                            this.inputParameters = 0L;
                        }
                        this.format = null;
                        if (this.readIsMalfunctioningSince != 0L) {
                            this.setReadIsMalfunctioning(false);
                        }
                    }
                }
            }
        }
        this.deviceID = deviceID;
        this.started = false;
        if (this.deviceID != null) {
            AudioSystem2 audioSystem = (AudioSystem2)AudioSystem.getAudioSystem("portaudio");
            if (audioSystem != null) {
                audioSystem.willOpenStream();
            }
            try {
                this.connect();
            }
            finally {
                if (audioSystem != null) {
                    audioSystem.didOpenStream();
                }
            }
        }
    }

    private void setReadIsMalfunctioning(boolean malfunctioning) {
        if (malfunctioning) {
            if (this.readIsMalfunctioningSince == 0L) {
                this.readIsMalfunctioningSince = System.currentTimeMillis();
                PortAudioSystem.monitorFunctionalHealth(this.diagnosticsControl);
            }
        } else {
            this.readIsMalfunctioningSince = 0L;
        }
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.stream != 0L) {
            this.waitWhileStreamIsBusy();
            try {
                Pa.StartStream(this.stream);
                this.started = true;
            }
            catch (PortAudioException paex) {
                logger.error("Failed to start " + this.getClass().getSimpleName(), paex);
                IOException ioex = new IOException(paex.getLocalizedMessage());
                ioex.initCause(paex);
                throw ioex;
            }
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        if (this.stream != 0L) {
            this.waitWhileStreamIsBusy();
            try {
                Pa.StopStream(this.stream);
                this.started = false;
                if (this.readIsMalfunctioningSince != 0L) {
                    this.setReadIsMalfunctioning(false);
                }
            }
            catch (PortAudioException paex) {
                logger.error("Failed to stop " + this.getClass().getSimpleName(), paex);
                IOException ioex = new IOException(paex.getLocalizedMessage());
                ioex.initCause(paex);
                throw ioex;
            }
        }
    }

    private void waitWhileStreamIsBusy() {
        boolean interrupted = false;
        while (this.stream != 0L && this.streamIsBusy) {
            try {
                this.wait();
            }
            catch (InterruptedException iex) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

