/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.examples;

import java.io.PrintStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import org.jitsi.examples.AVTransmit2;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;

public class AVReceive2 {
    private int localPortBase;
    private MediaStream[] mediaStreams;
    private InetAddress remoteAddr;
    private int remotePortBase;
    private static final String LOCAL_PORT_BASE_ARG_NAME = "--local-port-base=";
    private static final String REMOTE_HOST_ARG_NAME = "--remote-host=";
    private static final String REMOTE_PORT_BASE_ARG_NAME = "--remote-port-base=";
    private static final String[][] ARGS = new String[][]{{"--local-port-base=", "The port on which media is to be received. The specified value will be used as the port to receive the audio RTP on, the next port after it will be used to receive the audio RTCP on. Respectively, the subsequent ports will be used to receive the video RTP and RTCP on."}, {"--remote-host=", "The name of the host from which the media is to be received."}, {"--remote-port-base=", "The port from which media is to be received. The specified vaue will be used as the port to receive the audio RTP from, the next port after it will be used to receive the audio RTCP from. Respectively, the subsequent ports will be used to receive the video RTP and RTCP from."}};

    private AVReceive2(String localPortBase, String remoteHost, String remotePortBase) throws Exception {
        this.localPortBase = localPortBase == null ? -1 : Integer.valueOf(localPortBase);
        this.remoteAddr = InetAddress.getByName(remoteHost);
        this.remotePortBase = Integer.valueOf(remotePortBase);
    }

    private boolean initialize() throws Exception {
        MediaType[] mediaTypes = MediaType.values();
        MediaService mediaService = LibJitsi.getMediaService();
        int localPort = this.localPortBase;
        int remotePort = this.remotePortBase;
        this.mediaStreams = new MediaStream[mediaTypes.length];
        for (MediaType mediaType : mediaTypes) {
            DefaultStreamConnector connector;
            byte dynamicRTPPayloadType;
            double clockRate;
            String encoding;
            MediaDevice device = mediaService.getDefaultDevice(mediaType, MediaUseCase.CALL);
            MediaStream mediaStream = mediaService.createMediaStream(device);
            mediaStream.setDirection(MediaDirection.RECVONLY);
            switch (device.getMediaType()) {
                case AUDIO: {
                    encoding = "PCMU";
                    clockRate = 8000.0;
                    dynamicRTPPayloadType = -1;
                    break;
                }
                case VIDEO: {
                    encoding = "H264";
                    clockRate = -1.0;
                    dynamicRTPPayloadType = 99;
                    break;
                }
                default: {
                    encoding = null;
                    clockRate = -1.0;
                    dynamicRTPPayloadType = -1;
                }
            }
            if (encoding != null) {
                MediaFormat format = mediaService.getFormatFactory().createMediaFormat(encoding, clockRate);
                if (dynamicRTPPayloadType != -1) {
                    mediaStream.addDynamicRTPPayloadType(dynamicRTPPayloadType, format);
                }
                mediaStream.setFormat(format);
            }
            if (this.localPortBase == -1) {
                connector = new DefaultStreamConnector();
            } else {
                int localRTPPort = localPort++;
                int localRTCPPort = localPort++;
                connector = new DefaultStreamConnector(new DatagramSocket(localRTPPort), new DatagramSocket(localRTCPPort));
            }
            mediaStream.setConnector(connector);
            int remoteRTPPort = remotePort++;
            int remoteRTCPPort = remotePort++;
            mediaStream.setTarget(new MediaStreamTarget(new InetSocketAddress(this.remoteAddr, remoteRTPPort), new InetSocketAddress(this.remoteAddr, remoteRTCPPort)));
            mediaStream.setName(mediaType.toString());
            this.mediaStreams[mediaType.ordinal()] = mediaStream;
        }
        for (MediaStream mediaStream : this.mediaStreams) {
            if (mediaStream == null) continue;
            mediaStream.start();
        }
        return true;
    }

    private void close() {
        if (this.mediaStreams != null) {
            for (int i = 0; i < this.mediaStreams.length; ++i) {
                MediaStream mediaStream = this.mediaStreams[i];
                if (mediaStream == null) continue;
                try {
                    mediaStream.stop();
                    continue;
                }
                finally {
                    mediaStream.close();
                    this.mediaStreams[i] = null;
                }
            }
            this.mediaStreams = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block13: {
            if (args.length < 3) {
                AVReceive2.prUsage();
            } else {
                Map<String, String> argMap = AVTransmit2.parseCommandLineArgs(args);
                LibJitsi.start();
                try {
                    AVReceive2 avReceive = new AVReceive2(argMap.get(LOCAL_PORT_BASE_ARG_NAME), argMap.get(REMOTE_HOST_ARG_NAME), argMap.get(REMOTE_PORT_BASE_ARG_NAME));
                    if (avReceive.initialize()) {
                        try {
                            long then = System.currentTimeMillis();
                            long waitingPeriod = 120000L;
                            try {
                                while (System.currentTimeMillis() - then < waitingPeriod) {
                                    Thread.sleep(1000L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        finally {
                            avReceive.close();
                        }
                        System.err.println("Exiting AVReceive2");
                        break block13;
                    }
                    System.err.println("Failed to initialize the sessions.");
                }
                finally {
                    LibJitsi.stop();
                }
            }
        }
    }

    private static void prUsage() {
        PrintStream err = System.err;
        err.println("Usage: " + AVReceive2.class.getName() + " <args>");
        err.println("Valid args:");
        for (String[] arg : ARGS) {
            err.println("  " + arg[0] + " " + arg[1]);
        }
    }
}

