/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramSocketFactory;
import org.ice4j.socket.RtcpDemuxPacketFilter;
import org.ice4j.socket.StunDatagramPacketFilter;
import org.ice4j.stack.StunStack;

public class DelegatingDatagramSocket
extends DatagramSocket {
    private static final Logger logger = Logger.getLogger(DelegatingDatagramSocket.class.getName());
    protected final DatagramSocket delegate;
    private long nbReceivedRtpPackets = 0L;
    private long nbSentRtpPackets = 0L;
    private long nbLostRtpPackets = 0L;
    private long lastRtpSequenceNumber = -1L;
    private long lastLostPacketLogTime = 0L;
    private static DatagramSocketFactory delegateFactory = null;
    private static int defaultReceiveBufferSize = -1;

    public DelegatingDatagramSocket() throws SocketException {
        this(null, new InetSocketAddress(0));
    }

    public DelegatingDatagramSocket(DatagramSocket delegate) throws SocketException {
        this(delegate, null);
    }

    public DelegatingDatagramSocket(int port) throws SocketException {
        this(null, new InetSocketAddress(port));
    }

    public DelegatingDatagramSocket(int port, InetAddress laddr) throws SocketException {
        this(null, new InetSocketAddress(laddr, port));
    }

    public DelegatingDatagramSocket(SocketAddress bindaddr) throws SocketException {
        this(null, bindaddr);
    }

    public DelegatingDatagramSocket(DatagramSocket delegate, SocketAddress address) throws SocketException {
        super((SocketAddress)null);
        if (delegate != null) {
            this.delegate = delegate;
        } else {
            if (delegateFactory != null) {
                this.delegate = delegateFactory.createUnboundDatagramSocket();
            } else {
                this.delegate = null;
                this.initReceiveBufferSize();
            }
            this.bind(address);
        }
    }

    public void bind(SocketAddress addr) throws SocketException {
        if (this.delegate == null) {
            super.bind(addr);
        } else {
            this.delegate.bind(addr);
        }
    }

    public void close() {
        if (this.delegate == null) {
            super.close();
        } else {
            this.delegate.close();
        }
    }

    public void connect(InetAddress address, int port) {
        if (this.delegate == null) {
            super.connect(address, port);
        } else {
            this.delegate.connect(address, port);
        }
    }

    public void connect(SocketAddress addr) throws SocketException {
        if (this.delegate == null) {
            super.connect(addr);
        } else {
            this.delegate.connect(addr);
        }
    }

    public void disconnect() {
        if (this.delegate == null) {
            super.disconnect();
        } else {
            this.delegate.disconnect();
        }
    }

    public boolean getBroadcast() throws SocketException {
        return this.delegate == null ? super.getBroadcast() : this.delegate.getBroadcast();
    }

    public DatagramChannel getChannel() {
        return this.delegate == null ? super.getChannel() : this.delegate.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.delegate == null ? super.getInetAddress() : this.delegate.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.delegate == null ? super.getLocalAddress() : this.delegate.getLocalAddress();
    }

    public int getLocalPort() {
        return this.delegate == null ? super.getLocalPort() : this.delegate.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate == null ? super.getLocalSocketAddress() : this.delegate.getLocalSocketAddress();
    }

    public int getPort() {
        return this.delegate == null ? super.getPort() : this.delegate.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.delegate == null ? super.getReceiveBufferSize() : this.delegate.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.delegate == null ? super.getRemoteSocketAddress() : this.delegate.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.delegate == null ? super.getReuseAddress() : this.delegate.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.delegate == null ? super.getSendBufferSize() : this.delegate.getSendBufferSize();
    }

    public int getSoTimeout() throws SocketException {
        return this.delegate == null ? super.getSoTimeout() : this.delegate.getSoTimeout();
    }

    public int getTrafficClass() throws SocketException {
        return this.delegate == null ? super.getTrafficClass() : this.delegate.getTrafficClass();
    }

    public boolean isBound() {
        return this.delegate == null ? super.isBound() : this.delegate.isBound();
    }

    public boolean isClosed() {
        return this.delegate == null ? super.isClosed() : this.delegate.isClosed();
    }

    public boolean isConnected() {
        return this.delegate == null ? super.isConnected() : this.delegate.isConnected();
    }

    public void receive(DatagramPacket p) throws IOException {
        if (this.delegate == null) {
            byte[] data = p.getData();
            p.setLength(data == null ? 0 : data.length - p.getOffset());
            super.receive(p);
            if (this.isRtpPacket(p)) {
                ++this.nbReceivedRtpPackets;
            }
            DelegatingDatagramSocket.logPacketToPcap(p, this.nbReceivedRtpPackets, false, super.getLocalAddress(), super.getLocalPort());
            this.updateRtpLosses(p);
        } else {
            this.delegate.receive(p);
        }
    }

    public void send(DatagramPacket p) throws IOException {
        if (this.delegate == null) {
            block4: {
                try {
                    super.send(p);
                }
                catch (Exception ex) {
                    InetAddress tmpAddr = p.getAddress();
                    if (!(ex instanceof NoRouteToHostException) && (ex.getMessage() == null || !ex.getMessage().equals("No route to host")) || !(tmpAddr instanceof Inet6Address) || !tmpAddr.isLinkLocalAddress()) break block4;
                    Inet6Address newAddr = Inet6Address.getByAddress("", tmpAddr.getAddress(), ((Inet6Address)super.getLocalAddress()).getScopeId());
                    p.setAddress(newAddr);
                    super.send(p);
                }
            }
            ++this.nbSentRtpPackets;
            DelegatingDatagramSocket.logPacketToPcap(p, this.nbSentRtpPackets, true, super.getLocalAddress(), super.getLocalPort());
        } else {
            this.delegate.send(p);
        }
    }

    public void setBroadcast(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setBroadcast(on);
        } else {
            this.delegate.setBroadcast(on);
        }
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.delegate == null) {
            super.setReceiveBufferSize(size);
        } else {
            this.delegate.setReceiveBufferSize(size);
        }
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setReuseAddress(on);
        } else {
            this.delegate.setReuseAddress(on);
        }
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.delegate == null) {
            super.setSendBufferSize(size);
        } else {
            this.delegate.setSendBufferSize(size);
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.delegate == null) {
            super.setSoTimeout(timeout);
        } else {
            this.delegate.setSoTimeout(timeout);
        }
    }

    public void setTrafficClass(int tc) throws SocketException {
        if (this.delegate == null) {
            super.setTrafficClass(tc);
        } else {
            this.delegate.setTrafficClass(tc);
        }
    }

    public static boolean logRTPPacket(long numOfPacket) {
        return numOfPacket == 1L || numOfPacket == 300L || numOfPacket == 500L || numOfPacket == 1000L || numOfPacket % 5000L == 0L;
    }

    public static void logPacketToPcap(DatagramPacket p, long nbSentOrReceivedRtpPackets, boolean isSent, InetAddress interfaceAddress, int interfacePort) {
        boolean isStunPacket = StunDatagramPacketFilter.isStunPacket(p);
        boolean logThisRtpPacket = false;
        if (!isStunPacket) {
            logThisRtpPacket = DelegatingDatagramSocket.logRTPPacket(nbSentOrReceivedRtpPackets);
        }
        if ((isStunPacket || logThisRtpPacket) && interfaceAddress != null) {
            int toIndex;
            InetAddress[] addr = new InetAddress[]{interfaceAddress, p.getAddress()};
            int[] port = new int[]{interfacePort, p.getPort()};
            int fromIndex = isSent ? 0 : 1;
            int n = toIndex = isSent ? 1 : 0;
            if (StunStack.isPacketLoggerEnabled()) {
                StunStack.getPacketLogger().logPacket(addr[fromIndex].getAddress(), port[fromIndex], addr[toIndex].getAddress(), port[toIndex], p.getData(), isSent);
            }
        }
    }

    public static long getRtpSequenceNumber(DatagramPacket p) {
        byte[] data = p.getData();
        int offset = p.getOffset();
        long seq_high = data[offset + 2] & 0xFF;
        long seq_low = data[offset + 3] & 0xFF;
        return seq_high << 8 | seq_low;
    }

    private void updateRtpLosses(DatagramPacket p) {
        if (this.isRtpPacket(p)) {
            long newSeq = DelegatingDatagramSocket.getRtpSequenceNumber(p);
            if (this.lastRtpSequenceNumber != -1L) {
                this.nbLostRtpPackets += DelegatingDatagramSocket.getNbLost(this.lastRtpSequenceNumber, newSeq);
            }
            this.lastRtpSequenceNumber = newSeq;
            this.lastLostPacketLogTime = DelegatingDatagramSocket.logRtpLosses(this.nbLostRtpPackets, this.nbReceivedRtpPackets, this.lastLostPacketLogTime);
        }
    }

    public static long logRtpLosses(long totalNbLost, long totalNbReceived, long lastLogTime) {
        long currentTime;
        double percentLost = (double)totalNbLost / (double)(totalNbLost + totalNbReceived);
        if (percentLost > 0.05 && (currentTime = System.currentTimeMillis()) - lastLogTime >= 5000L) {
            logger.info("RTP lost > 5%: " + percentLost);
            return currentTime;
        }
        return lastLogTime;
    }

    public static long getNbLost(long lastRtpSequenceNumber, long newSeq) {
        long newNbLost = 0L;
        newNbLost = lastRtpSequenceNumber <= newSeq ? newSeq - lastRtpSequenceNumber : 65535L - lastRtpSequenceNumber + newSeq;
        if (newNbLost > 1L) {
            if (newNbLost < 255L) {
                return newNbLost - 1L;
            }
            return 1L;
        }
        return 0L;
    }

    public static void setDefaultDelegateFactory(DatagramSocketFactory factory) {
        delegateFactory = factory;
    }

    public static void setDefaultReceiveBufferSize(int size) {
        defaultReceiveBufferSize = size;
    }

    private void initReceiveBufferSize() throws SocketException {
        if (this.delegate == null && defaultReceiveBufferSize > 0) {
            super.setReceiveBufferSize(defaultReceiveBufferSize);
        }
    }

    private boolean isRtpPacket(DatagramPacket p) {
        int off;
        byte[] data;
        int len = p.getLength();
        if (len >= 4 && ((data = p.getData())[(off = p.getOffset()) + 0] & 0xC0) >> 6 == 2) {
            return !RtcpDemuxPacketFilter.isRtcpPacket(p);
        }
        return false;
    }
}

