/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.AbstractResponseCollector;
import org.ice4j.BaseStunMessageEvent;
import org.ice4j.StunException;
import org.ice4j.StunResponseEvent;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.ErrorCodeAttribute;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.attribute.MessageIntegrityAttribute;
import org.ice4j.attribute.NonceAttribute;
import org.ice4j.attribute.RealmAttribute;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.attribute.XorMappedAddressAttribute;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.ServerReflexiveCandidate;
import org.ice4j.ice.harvest.StunCandidateHarvester;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.security.LongTermCredential;
import org.ice4j.security.LongTermCredentialSession;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;

public class StunCandidateHarvest
extends AbstractResponseCollector {
    private static final Logger logger = Logger.getLogger(StunCandidateHarvest.class.getName());
    private static final LocalCandidate[] NO_CANDIDATES = new LocalCandidate[0];
    protected static final long SEND_KEEP_ALIVE_MESSAGE_INTERVAL_NOT_SPECIFIED = 0L;
    private final List<LocalCandidate> candidates = new LinkedList<LocalCandidate>();
    private boolean completedResolvingCandidate = false;
    public final StunCandidateHarvester harvester;
    public final HostCandidate hostCandidate;
    private LongTermCredentialSession longTermCredentialSession;
    private final Map<TransactionID, Request> requests = new HashMap<TransactionID, Request>();
    private long sendKeepAliveMessageInterval = 0L;
    private final Object sendKeepAliveMessageSyncRoot = new Object();
    private Thread sendKeepAliveMessageThread;
    private long sendKeepAliveMessageTime = -1L;

    public StunCandidateHarvest(StunCandidateHarvester harvester, HostCandidate hostCandidate) {
        this.harvester = harvester;
        this.hostCandidate = hostCandidate;
    }

    protected boolean addCandidate(LocalCandidate candidate) {
        boolean added = !this.candidates.contains(candidate) && this.hostCandidate.getParentComponent().addLocalCandidate(candidate) ? this.candidates.add(candidate) : false;
        return added;
    }

    protected boolean addShortTermCredentialAttributes(Request request) {
        String shortTermCredentialUsername = this.harvester.getShortTermCredentialUsername();
        if (shortTermCredentialUsername != null) {
            request.putAttribute(AttributeFactory.createUsernameAttribute(shortTermCredentialUsername));
            request.putAttribute(AttributeFactory.createMessageIntegrityAttribute(shortTermCredentialUsername));
            return true;
        }
        return false;
    }

    protected boolean completedResolvingCandidate(Request request, Response response) {
        if (!this.completedResolvingCandidate) {
            this.completedResolvingCandidate = true;
            try {
                if (!(response != null && response.isSuccessResponse() || this.longTermCredentialSession == null)) {
                    this.harvester.getStunStack().getCredentialsManager().unregisterAuthority(this.longTermCredentialSession);
                    this.longTermCredentialSession = null;
                }
            }
            finally {
                this.harvester.completedResolvingCandidate(this);
            }
        }
        return this.completedResolvingCandidate;
    }

    protected boolean containsCandidate(LocalCandidate candidate) {
        LocalCandidate[] candidates;
        if (candidate != null && (candidates = this.getCandidates()) != null && candidates.length != 0) {
            for (LocalCandidate c : candidates) {
                if (!candidate.equals(c)) continue;
                return true;
            }
        }
        return false;
    }

    protected void createCandidates(Response response) {
        this.createServerReflexiveCandidate(response);
    }

    protected Message createKeepAliveMessage(LocalCandidate candidate) throws StunException {
        if (CandidateType.SERVER_REFLEXIVE_CANDIDATE.equals((Object)candidate.getType())) {
            return null;
        }
        throw new StunException(2, "candidate");
    }

    protected Request createRequestToRetry(Request request) {
        switch (request.getMessageType()) {
            case '\u0001': {
                return MessageFactory.createBindingRequest();
            }
        }
        throw new IllegalArgumentException("request.messageType");
    }

    protected Request createRequestToStartResolvingCandidate() {
        return MessageFactory.createBindingRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSendKeepAliveMessageThread() {
        Object object = this.sendKeepAliveMessageSyncRoot;
        synchronized (object) {
            SendKeepAliveMessageThread t = new SendKeepAliveMessageThread(this);
            t.setDaemon(true);
            t.setName(this.getClass().getName() + ".sendKeepAliveMessageThread: " + this.hostCandidate);
            boolean started = false;
            this.sendKeepAliveMessageThread = t;
            try {
                t.start();
                started = true;
            }
            finally {
                if (!started && this.sendKeepAliveMessageThread == t) {
                    this.sendKeepAliveMessageThread = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createServerReflexiveCandidate(Response response) {
        ServerReflexiveCandidate srvrRflxCand;
        TransportAddress addr = this.getMappedAddress(response);
        if (addr != null && (srvrRflxCand = this.createServerReflexiveCandidate(addr)) != null) {
            try {
                this.addCandidate(srvrRflxCand);
            }
            finally {
                block10: {
                    if (!this.containsCandidate(srvrRflxCand)) {
                        try {
                            srvrRflxCand.free();
                        }
                        catch (Exception ex) {
                            if (!logger.isLoggable(Level.FINE)) break block10;
                            logger.log(Level.FINE, "Failed to free ServerReflexiveCandidate: " + srvrRflxCand, ex);
                        }
                    }
                }
            }
        }
    }

    protected ServerReflexiveCandidate createServerReflexiveCandidate(TransportAddress transportAddress) {
        return new ServerReflexiveCandidate(transportAddress, this.hostCandidate, this.harvester.stunServer, CandidateExtendedType.STUN_SERVER_REFLEXIVE_CANDIDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitSendKeepAliveMessageThread() {
        Object object = this.sendKeepAliveMessageSyncRoot;
        synchronized (object) {
            if (this.sendKeepAliveMessageThread == Thread.currentThread()) {
                this.sendKeepAliveMessageThread = null;
            }
            if (this.sendKeepAliveMessageThread == null && this.sendKeepAliveMessageInterval != 0L) {
                this.createSendKeepAliveMessageThread();
            }
        }
    }

    int getCandidateCount() {
        return this.candidates.size();
    }

    LocalCandidate[] getCandidates() {
        return this.candidates.toArray(NO_CANDIDATES);
    }

    protected TransportAddress getMappedAddress(Response response) {
        Attribute attribute = response.getAttribute(' ');
        if (attribute instanceof XorMappedAddressAttribute) {
            return ((XorMappedAddressAttribute)attribute).getAddress(response.getTransactionID());
        }
        attribute = response.getAttribute('\u0001');
        if (attribute instanceof MappedAddressAttribute) {
            return ((MappedAddressAttribute)attribute).getAddress();
        }
        return null;
    }

    private boolean processChallenge(byte[] realm, byte[] nonce, Request request, TransactionID requestTransactionID) throws StunException {
        UsernameAttribute usernameAttribute = (UsernameAttribute)request.getAttribute('\u0006');
        if (usernameAttribute == null) {
            if (this.longTermCredentialSession == null) {
                LongTermCredential longTermCredential = this.harvester.createLongTermCredential(this, realm);
                if (longTermCredential == null) {
                    return false;
                }
                this.longTermCredentialSession = new LongTermCredentialSession(longTermCredential, realm);
                this.harvester.getStunStack().getCredentialsManager().registerAuthority(this.longTermCredentialSession);
            } else if (!this.longTermCredentialSession.realmEquals(realm)) {
                return false;
            }
        } else {
            if (this.longTermCredentialSession == null) {
                return false;
            }
            if (!this.longTermCredentialSession.usernameEquals(usernameAttribute.getUsername())) {
                return false;
            }
            if (!this.longTermCredentialSession.realmEquals(realm)) {
                return false;
            }
        }
        this.longTermCredentialSession.setNonce(nonce);
        Request retryRequest = this.createRequestToRetry(request);
        TransactionID retryRequestTransactionID = null;
        if (retryRequest != null) {
            Object applicationData;
            if (requestTransactionID != null && (applicationData = requestTransactionID.getApplicationData()) != null) {
                byte[] retryRequestTransactionIDAsBytes = retryRequest.getTransactionID();
                retryRequestTransactionID = retryRequestTransactionIDAsBytes == null ? TransactionID.createNewTransactionID() : TransactionID.createTransactionID(this.harvester.getStunStack(), retryRequestTransactionIDAsBytes);
                retryRequestTransactionID.setApplicationData(applicationData);
            }
            retryRequestTransactionID = this.sendRequest(retryRequest, false, retryRequestTransactionID);
        }
        return retryRequestTransactionID != null;
    }

    private boolean processChallenge(Response response, Request request, TransactionID transactionID) throws StunException {
        boolean retried = false;
        if (response.getAttributeCount() > 0) {
            char[] excludedResponseAttributeTypes = new char[]{'\u0006', '\b'};
            boolean challenge = true;
            for (char excludedResponseAttributeType : excludedResponseAttributeTypes) {
                if (!response.containsAttribute(excludedResponseAttributeType)) continue;
                challenge = false;
                break;
            }
            if (challenge) {
                RealmAttribute realmAttribute = (RealmAttribute)response.getAttribute('\u0014');
                if (realmAttribute == null) {
                    challenge = false;
                } else {
                    NonceAttribute nonceAttribute = (NonceAttribute)response.getAttribute('\u0015');
                    if (nonceAttribute == null) {
                        challenge = false;
                    } else {
                        retried = this.processChallenge(realmAttribute.getRealm(), nonceAttribute.getNonce(), request, transactionID);
                    }
                }
            }
        }
        return retried;
    }

    protected boolean processErrorOrFailure(Response response, Request request, TransactionID transactionID) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFailure(BaseStunMessageEvent event) {
        Message message;
        Request request;
        TransactionID transactionID = event.getTransactionID();
        logger.finest("A transaction expired: tranid=" + transactionID);
        logger.finest("localAddr=" + this.hostCandidate);
        Map<TransactionID, Request> map = this.requests;
        synchronized (map) {
            request = this.requests.remove(transactionID);
        }
        if (request == null && (message = event.getMessage()) instanceof Request) {
            request = (Request)message;
        }
        boolean completedResolvingCandidate = true;
        try {
            if (this.processErrorOrFailure(null, request, transactionID)) {
                completedResolvingCandidate = false;
            }
        }
        finally {
            if (completedResolvingCandidate) {
                this.completedResolvingCandidate(request, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(StunResponseEvent event) {
        block23: {
            TransactionID transactionID = event.getTransactionID();
            logger.finest("Received a message: tranid= " + transactionID);
            logger.finest("localCand= " + this.hostCandidate);
            Map<TransactionID, Request> map = this.requests;
            synchronized (map) {
                this.requests.remove(transactionID);
            }
            Response response = event.getResponse();
            Request request = event.getRequest();
            boolean completedResolvingCandidate = true;
            try {
                if (response.isSuccessResponse()) {
                    if (request.containsAttribute('\b')) {
                        MessageIntegrityAttribute messageIntegrityAttribute = (MessageIntegrityAttribute)response.getAttribute('\b');
                        if (messageIntegrityAttribute == null) {
                            return;
                        }
                        UsernameAttribute usernameAttribute = (UsernameAttribute)request.getAttribute('\u0006');
                        if (usernameAttribute == null) {
                            return;
                        }
                        if (!this.harvester.getStunStack().validateMessageIntegrity(messageIntegrityAttribute, LongTermCredential.toString(usernameAttribute.getUsername()), !request.containsAttribute('\u0014') && !request.containsAttribute('\u0015'), event.getRawMessage())) {
                            return;
                        }
                    }
                    this.processSuccess(response, request, transactionID);
                    break block23;
                }
                ErrorCodeAttribute errorCodeAttr = (ErrorCodeAttribute)response.getAttribute('\t');
                if (errorCodeAttr != null && errorCodeAttr.getErrorClass() == 4) {
                    try {
                        switch (errorCodeAttr.getErrorNumber()) {
                            case 1: {
                                if (!this.processUnauthorized(response, request, transactionID)) break;
                                completedResolvingCandidate = false;
                                break;
                            }
                            case 38: {
                                if (!this.processStaleNonce(response, request, transactionID)) break;
                                completedResolvingCandidate = false;
                            }
                        }
                    }
                    catch (StunException sex) {
                        completedResolvingCandidate = true;
                    }
                }
                if (completedResolvingCandidate && this.processErrorOrFailure(response, request, transactionID)) {
                    completedResolvingCandidate = false;
                }
            }
            finally {
                if (completedResolvingCandidate) {
                    this.completedResolvingCandidate(request, response);
                }
            }
        }
    }

    private boolean processStaleNonce(Response response, Request request, TransactionID transactionID) throws StunException {
        boolean challenge;
        if (request.getAttributeCount() > 0) {
            char[] includedRequestAttributeTypes = new char[]{'\u0006', '\u0014', '\u0015', '\b'};
            challenge = true;
            for (char includedRequestAttributeType : includedRequestAttributeTypes) {
                if (request.containsAttribute(includedRequestAttributeType)) continue;
                challenge = false;
                break;
            }
        } else {
            challenge = false;
        }
        return challenge && this.processChallenge(response, request, transactionID);
    }

    protected void processSuccess(Response response, Request request, TransactionID transactionID) {
        if (!this.completedResolvingCandidate) {
            this.createCandidates(response);
        }
    }

    private boolean processUnauthorized(Response response, Request request, TransactionID transactionID) throws StunException {
        boolean challenge = true;
        if (request.getAttributeCount() > 0) {
            char[] excludedRequestAttributeTypes;
            for (char excludedRequestAttributeType : excludedRequestAttributeTypes = new char[]{'\u0006', '\b', '\u0014', '\u0015'}) {
                if (!request.containsAttribute(excludedRequestAttributeType)) continue;
                challenge = false;
                break;
            }
        }
        return challenge && this.processChallenge(response, request, transactionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runInSendKeepAliveMessageThread() {
        Object object = this.sendKeepAliveMessageSyncRoot;
        synchronized (object) {
            if (this.sendKeepAliveMessageThread != Thread.currentThread()) {
                return false;
            }
            if (this.sendKeepAliveMessageInterval == 0L) {
                return false;
            }
            long timeout = this.sendKeepAliveMessageTime == -1L ? this.sendKeepAliveMessageInterval : this.sendKeepAliveMessageTime + this.sendKeepAliveMessageInterval - System.currentTimeMillis();
            if (timeout > 0L) {
                try {
                    this.sendKeepAliveMessageSyncRoot.wait(timeout);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
                return true;
            }
        }
        this.sendKeepAliveMessageTime = System.currentTimeMillis();
        try {
            this.sendKeepAliveMessage();
        }
        catch (StunException sex) {
            logger.log(Level.INFO, "Failed to send STUN keep-alive message.", sex);
        }
        return true;
    }

    protected void sendKeepAliveMessage() throws StunException {
        for (LocalCandidate candidate : this.getCandidates()) {
            if (this.sendKeepAliveMessage(candidate)) break;
        }
    }

    protected boolean sendKeepAliveMessage(LocalCandidate candidate) throws StunException {
        Message keepAliveMessage = this.createKeepAliveMessage(candidate);
        if (keepAliveMessage == null) {
            return false;
        }
        if (keepAliveMessage instanceof Request) {
            return this.sendRequest((Request)keepAliveMessage, false, null) != null;
        }
        throw new StunException(2, "Failed to create keep-alive STUN message for candidate: " + candidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionID sendRequest(Request request, boolean firstRequest, TransactionID transactionID) throws StunException {
        if (!firstRequest && this.longTermCredentialSession != null) {
            this.longTermCredentialSession.addAttributes(request);
        }
        StunStack stunStack = this.harvester.getStunStack();
        TransportAddress stunServer = this.harvester.stunServer;
        TransportAddress hostCandidateTransportAddress = this.hostCandidate.getTransportAddress();
        if (transactionID == null) {
            byte[] transactionIDAsBytes = request.getTransactionID();
            transactionID = transactionIDAsBytes == null ? TransactionID.createNewTransactionID() : TransactionID.createTransactionID(this.harvester.getStunStack(), transactionIDAsBytes);
        }
        Map<TransactionID, Request> map = this.requests;
        synchronized (map) {
            try {
                transactionID = stunStack.sendRequest(request, stunServer, hostCandidateTransportAddress, this, transactionID);
            }
            catch (IllegalArgumentException iaex) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Failed to send " + request + " through " + hostCandidateTransportAddress + " to " + stunServer, iaex);
                }
                throw new StunException(2, iaex.getMessage(), iaex);
            }
            catch (IOException ioex) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Failed to send " + request + " through " + hostCandidateTransportAddress + " to " + stunServer, ioex);
                }
                throw new StunException(4, ioex.getMessage(), ioex);
            }
            this.requests.put(transactionID, request);
        }
        return transactionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSendKeepAliveMessageInterval(long sendKeepAliveMessageInterval) {
        if (sendKeepAliveMessageInterval != 0L && sendKeepAliveMessageInterval < 1L) {
            throw new IllegalArgumentException("sendKeepAliveMessageInterval");
        }
        Object object = this.sendKeepAliveMessageSyncRoot;
        synchronized (object) {
            this.sendKeepAliveMessageInterval = sendKeepAliveMessageInterval;
            if (this.sendKeepAliveMessageThread == null) {
                if (this.sendKeepAliveMessageInterval != 0L) {
                    this.createSendKeepAliveMessageThread();
                }
            } else {
                this.sendKeepAliveMessageSyncRoot.notify();
            }
        }
    }

    boolean startResolvingCandidate() throws Exception {
        Request requestToStartResolvingCandidate;
        if (!this.completedResolvingCandidate && (requestToStartResolvingCandidate = this.createRequestToStartResolvingCandidate()) != null) {
            this.addShortTermCredentialAttributes(requestToStartResolvingCandidate);
            this.sendRequest(requestToStartResolvingCandidate, true, null);
            return true;
        }
        return false;
    }

    public void close() {
        this.setSendKeepAliveMessageInterval(0L);
    }

    private static class SendKeepAliveMessageThread
    extends Thread {
        private final WeakReference<StunCandidateHarvest> harvest;

        public SendKeepAliveMessageThread(StunCandidateHarvest harvest) {
            this.harvest = new WeakReference<StunCandidateHarvest>(harvest);
        }

        public void run() {
            StunCandidateHarvest harvest;
            try {
                while ((harvest = (StunCandidateHarvest)this.harvest.get()) != null) {
                    if (harvest.runInSendKeepAliveMessageThread()) continue;
                    break;
                }
            }
            finally {
                harvest = (StunCandidateHarvest)this.harvest.get();
                if (harvest != null) {
                    harvest.exitSendKeepAliveMessageThread();
                }
            }
        }
    }
}

