/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.StunStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpHostCandidate
extends HostCandidate {
    private final List<IceSocketWrapper> sockets = new LinkedList<IceSocketWrapper>();

    public TcpHostCandidate(TransportAddress transportAddress, Component parentComponent) {
        super(transportAddress, parentComponent);
    }

    public void addSocket(IceSocketWrapper socket) {
        this.sockets.add(socket);
    }

    @Override
    protected void free() {
        StunStack stunStack = this.getStunStack();
        TransportAddress localAddr = this.getTransportAddress();
        for (IceSocketWrapper socket : this.sockets) {
            Socket tcpSocket = socket.getTCPSocket();
            stunStack.removeSocket(localAddr, new TransportAddress(tcpSocket.getInetAddress(), tcpSocket.getPort(), Transport.TCP));
            socket.close();
        }
        super.free();
    }

    public List<IceSocketWrapper> getIceSocketWrappers() {
        return this.sockets;
    }
}

