/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponent;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.as.ejb3.timerservice.ForwardingTimerService;
import org.jboss.as.ejb3.timerservice.SingletonTimedObjectInvokerImpl;
import org.jboss.as.ejb3.timerservice.StatelessTimedObjectInvokerImpl;
import org.jboss.ejb3.timerservice.api.TimerService;
import org.jboss.ejb3.timerservice.spi.MultiTimeoutMethodTimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.ScheduleTimer;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class TimerServiceService
extends ForwardingTimerService
implements Service<javax.ejb.TimerService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"ejb", "timerService"});
    private volatile TimerService timerService;
    private final InjectedValue<TimerServiceFactory> timerServiceFactoryInjectedValue = new InjectedValue();
    private final InjectedValue<EJBComponent> ejbComponentInjectedValue = new InjectedValue();
    private final Map<Method, List<AutoTimer>> autoTimers;
    private final ClassLoader classLoader;

    public TimerServiceService(Map<Method, List<AutoTimer>> autoTimers, ClassLoader classLoader) {
        this.autoTimers = autoTimers;
        this.classLoader = classLoader;
    }

    public synchronized void start(StartContext context) throws StartException {
        MultiTimeoutMethodTimedObjectInvoker invoker;
        TimerServiceFactory timerServiceFactory = (TimerServiceFactory)this.timerServiceFactoryInjectedValue.getValue();
        EJBComponent component = (EJBComponent)((Object)this.ejbComponentInjectedValue.getValue());
        if (component instanceof SingletonComponent) {
            invoker = new SingletonTimedObjectInvokerImpl((SingletonComponent)component, this.classLoader);
        } else if (component instanceof StatelessSessionComponent) {
            invoker = new StatelessTimedObjectInvokerImpl((StatelessSessionComponent)component, this.classLoader);
        } else {
            throw new StartException("TimerService can only be used with singleton and stateless components");
        }
        TimerService timerService = (TimerService)timerServiceFactory.createTimerService((TimedObjectInvoker)invoker);
        ArrayList<ScheduleTimer> timers = new ArrayList<ScheduleTimer>();
        for (Map.Entry<Method, List<AutoTimer>> entry : this.autoTimers.entrySet()) {
            for (AutoTimer timer : entry.getValue()) {
                timers.add(new ScheduleTimer(entry.getKey(), timer.getScheduleExpression(), timer.getTimerConfig()));
            }
        }
        timerServiceFactory.restoreTimerService((javax.ejb.TimerService)timerService, timers);
        this.timerService = timerService;
    }

    public synchronized void stop(StopContext context) {
        ((TimerServiceFactory)this.timerServiceFactoryInjectedValue.getValue()).suspendTimerService((javax.ejb.TimerService)this.timerService);
        this.timerService = null;
    }

    @Override
    protected javax.ejb.TimerService delegate() {
        TimerService timerService = this.timerService;
        if (timerService == null) {
            throw new IllegalStateException("TimerService is not started");
        }
        return timerService;
    }

    public javax.ejb.TimerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<TimerServiceFactory> getTimerServiceFactoryInjectedValue() {
        return this.timerServiceFactoryInjectedValue;
    }

    public InjectedValue<EJBComponent> getEjbComponentInjectedValue() {
        return this.ejbComponentInjectedValue;
    }
}

