/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PoolConfigService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ValueInjectionService;

public class SetDefaultSLSBPool
implements OperationStepHandler {
    public static final SetDefaultSLSBPool INSTANCE = new SetDefaultSLSBPool();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String poolName = operation.require("value").asString();
        ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        model.get("default-slsb-instance-pool").set(poolName);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep((OperationStepHandler)new DefaultSLSBPoolConfigServiceUpdateHandler(poolName), OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    static class DefaultSLSBPoolConfigServiceUpdateHandler
    implements OperationStepHandler {
        private final String poolName;

        DefaultSLSBPoolConfigServiceUpdateHandler(String poolName) {
            this.poolName = poolName;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
            ServiceController existingDefaultSLSBPoolConfigService = serviceRegistry.getService(PoolConfigService.DEFAULT_SLSB_POOL_CONFIG_SERVICE_NAME);
            if (existingDefaultSLSBPoolConfigService != null) {
                context.removeService(existingDefaultSLSBPoolConfigService);
            }
            ValueInjectionService newDefaultSLSBPoolConfigService = new ValueInjectionService();
            context.getServiceTarget().addService(PoolConfigService.DEFAULT_SLSB_POOL_CONFIG_SERVICE_NAME, (Service)newDefaultSLSBPoolConfigService).addDependency(PoolConfigService.EJB_POOL_CONFIG_BASE_SERVICE_NAME.append(new String[]{this.poolName}), PoolConfig.class, newDefaultSLSBPoolConfigService.getInjector()).install();
            context.completeStep();
        }
    }
}

