/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class EJB3Subsystem11Parser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:jboss:domain:ejb3:1.1", false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("lite")) {
            writer.writeAttribute("lite", model.get("lite").asString());
        }
        if (model.hasDefined("default-mdb-instance-pool") || model.hasDefined("default-resource-adapter-name")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.MDB.getLocalName());
            this.writeMDB(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.SESSION_BEAN.getLocalName());
            writer.writeStartElement(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            this.writeDefaultSLSBPool(writer, model);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (model.hasDefined("strict-max-bean-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.POOLS.getLocalName());
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            this.writeBeanInstancePools(writer, model);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("timer-service")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.TIMER_SERVICE.getLocalName());
            ModelNode timerServiceModel = model.get(new String[]{"service", "timer-service"});
            this.writeTimerService(writer, timerServiceModel);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode ejb3SubsystemAddOperation = new ModelNode();
        ejb3SubsystemAddOperation.get("operation").set("add");
        ejb3SubsystemAddOperation.get("address").add("subsystem", "ejb3");
        String liteValue = reader.getAttributeValue(null, "lite");
        if (liteValue != null) {
            ejb3SubsystemAddOperation.get("lite").set(Boolean.parseBoolean(liteValue));
        }
        operations.add(ejb3SubsystemAddOperation);
        EnumSet<EJB3SubsystemXMLElement> encountered = EnumSet.noneOf(EJB3SubsystemXMLElement.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemNamespace.forUri(reader.getNamespaceURI())) {
                case EJB3_1_1: {
                    EJB3SubsystemXMLElement element = EJB3SubsystemXMLElement.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case MDB: {
                            this.parseMDB(reader, operations);
                            continue block9;
                        }
                        case POOLS: {
                            this.parsePools(reader, operations);
                            continue block9;
                        }
                        case SESSION_BEAN: {
                            this.parseSessionBean(reader, operations);
                            continue block9;
                        }
                        case TIMER_SERVICE: {
                            this.parseTimerService(reader, operations);
                            continue block9;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void writeMDB(XMLExtendedStreamWriter writer, ModelNode mdbModelNode) throws XMLStreamException {
        if (mdbModelNode.hasDefined("default-resource-adapter-name")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.RESOURCE_ADAPTER_REF.getLocalName());
            String resourceAdapterName = mdbModelNode.get("default-resource-adapter-name").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName(), resourceAdapterName);
            writer.writeEndElement();
        }
        if (mdbModelNode.hasDefined("default-mdb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOL_REF.getLocalName());
            String poolRefName = mdbModelNode.get("default-mdb-instance-pool").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName(), poolRefName);
            writer.writeEndElement();
        }
    }

    private void writeSessionBean(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            ModelNode statelessBeanModeNode = model.get(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            this.writeDefaultSLSBPool(writer, statelessBeanModeNode);
            writer.writeEndElement();
        }
    }

    private void writeDefaultSLSBPool(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOL_REF.getLocalName());
            String poolRefName = model.get("default-slsb-instance-pool").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName(), poolRefName);
            writer.writeEndElement();
        }
    }

    private void writePools(XMLExtendedStreamWriter writer, ModelNode poolsModelNode) throws XMLStreamException {
        if (poolsModelNode.hasDefined(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName())) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            ModelNode beanInstancePoolsModelNode = poolsModelNode.get(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            this.writeBeanInstancePools(writer, beanInstancePoolsModelNode);
            writer.writeEndElement();
        }
    }

    private void writeBeanInstancePools(XMLExtendedStreamWriter writer, ModelNode beanInstancePoolModelNode) throws XMLStreamException {
        if (beanInstancePoolModelNode.hasDefined("strict-max-bean-instance-pool")) {
            List strictMaxPools = beanInstancePoolModelNode.get("strict-max-bean-instance-pool").asPropertyList();
            for (Property property : strictMaxPools) {
                writer.writeStartElement(EJB3SubsystemXMLElement.STRICT_MAX_POOL.getLocalName());
                ModelNode strictMaxPoolModelNode = property.getValue();
                this.writeStrictMaxPoolConfig(writer, strictMaxPoolModelNode);
                writer.writeEndElement();
            }
        }
    }

    private void writeStrictMaxPoolConfig(XMLExtendedStreamWriter writer, ModelNode strictMaxPoolModelNode) throws XMLStreamException {
        String poolName = strictMaxPoolModelNode.get("name").asString();
        writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), poolName);
        if (strictMaxPoolModelNode.hasDefined("max-pool-size")) {
            ModelNode maxPoolSize = strictMaxPoolModelNode.get("max-pool-size");
            writer.writeAttribute(EJB3SubsystemXMLAttribute.MAX_POOL_SIZE.getLocalName(), maxPoolSize.asString());
        }
        if (strictMaxPoolModelNode.hasDefined("timeout")) {
            ModelNode timeout = strictMaxPoolModelNode.get("timeout");
            writer.writeAttribute(EJB3SubsystemXMLAttribute.INSTANCE_AQUISITION_TIMEOUT.getLocalName(), timeout.asString());
        }
        if (strictMaxPoolModelNode.hasDefined("timeout-unit")) {
            ModelNode unit = strictMaxPoolModelNode.get("timeout-unit");
            writer.writeAttribute(EJB3SubsystemXMLAttribute.INSTANCE_AQUISITION_TIMEOUT_UNIT.getLocalName(), unit.asString());
        }
    }

    private void writeTimerService(XMLExtendedStreamWriter writer, ModelNode timerServiceModel) throws XMLStreamException {
        ModelNode relativeTo;
        ModelNode maxThreads;
        writer.writeStartElement(EJB3SubsystemXMLElement.THREAD_POOL.getLocalName());
        ModelNode coreThreads = timerServiceModel.get("core-threads");
        if (coreThreads.isDefined()) {
            writer.writeAttribute(EJB3SubsystemXMLAttribute.CORE_THREADS.getLocalName(), "" + coreThreads.asInt());
        }
        if ((maxThreads = timerServiceModel.get("max-threads")).isDefined()) {
            writer.writeAttribute(EJB3SubsystemXMLAttribute.MAX_THREADS.getLocalName(), "" + maxThreads.asInt());
        }
        writer.writeEndElement();
        writer.writeStartElement(EJB3SubsystemXMLElement.DATA_STORE.getLocalName());
        ModelNode path = timerServiceModel.get("path");
        if (path.isDefined()) {
            writer.writeAttribute(EJB3SubsystemXMLAttribute.PATH.getLocalName(), path.asString());
        }
        if ((relativeTo = timerServiceModel.get("relative-to")).isDefined()) {
            writer.writeAttribute(EJB3SubsystemXMLAttribute.RELATIVE_TO.getLocalName(), relativeTo.asString());
        }
        writer.writeEndElement();
    }

    private ModelNode parseMDB(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode mdbModelNode = new ModelNode();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    ModelNode setDefaultMDBPoolOperation = this.createSetDefaultMDBPoolOperation(poolName);
                    operations.add(setDefaultMDBPoolOperation);
                    continue block4;
                }
                case RESOURCE_ADAPTER_REF: {
                    String resourceAdapterName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName());
                    ModelNode setDefaultRANameOperation = this.createSetDefaultRAOperation(resourceAdapterName);
                    operations.add(setDefaultRANameOperation);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return mdbModelNode;
    }

    private void parseSessionBean(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STATELESS: {
                    this.parseStatelessBean(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStatelessBean(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    ModelNode setDefaultSLSBPoolOperation = this.createSetDefaultSLSBPoolOperation(poolName);
                    operations.add(setDefaultSLSBPoolOperation);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOLS: {
                    this.parseBeanInstancePools(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBeanInstancePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STRICT_MAX_POOL: {
                    this.parseStrictMaxPool(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStrictMaxPool(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String poolName = null;
        Integer maxPoolSize = null;
        Long timeout = null;
        String unit = null;
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    poolName = value;
                    continue block6;
                }
                case MAX_POOL_SIZE: {
                    if (!this.isPositiveInt(value.trim())) {
                        throw new XMLStreamException("Illegal value: " + value + " for " + EJB3SubsystemXMLAttribute.MAX_POOL_SIZE.getLocalName(), reader.getLocation());
                    }
                    maxPoolSize = new Integer(value.trim());
                    continue block6;
                }
                case INSTANCE_AQUISITION_TIMEOUT: {
                    if (!this.isPositiveInt(value.trim())) {
                        throw new XMLStreamException("Illegal value: " + value + " for " + EJB3SubsystemXMLAttribute.INSTANCE_AQUISITION_TIMEOUT.getLocalName(), reader.getLocation());
                    }
                    timeout = new Long(value.trim());
                    continue block6;
                }
                case INSTANCE_AQUISITION_TIMEOUT_UNIT: {
                    if (!this.isValidTimeoutUnit(value.trim())) {
                        throw new XMLStreamException("Illegal value: " + value + " for " + EJB3SubsystemXMLAttribute.INSTANCE_AQUISITION_TIMEOUT_UNIT.getLocalName(), reader.getLocation());
                    }
                    unit = value.trim().toUpperCase(Locale.ENGLISH);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (poolName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        operations.add(this.createAddStrictMaxBeanInstancePoolOperation(poolName, maxPoolSize, timeout, unit));
    }

    private void parseTimerService(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "ejb3");
        address.add("service", "timer-service");
        ModelNode timerServiceAdd = new ModelNode();
        timerServiceAdd.get("operation").set("add");
        timerServiceAdd.get("address").set(address);
        Integer coreThreads = null;
        Integer maxThreads = null;
        String dataStorePath = null;
        String dataStorePathRelativeTo = null;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case THREAD_POOL: {
                    EJB3SubsystemXMLAttribute attribute;
                    String value;
                    int i;
                    int count = reader.getAttributeCount();
                    block13: for (i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        value = reader.getAttributeValue(i);
                        attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case CORE_THREADS: {
                                if (coreThreads != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                coreThreads = Integer.valueOf(value);
                                continue block13;
                            }
                            case MAX_THREADS: {
                                if (maxThreads != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                maxThreads = Integer.valueOf(value);
                                continue block13;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (coreThreads != null) {
                        timerServiceAdd.get("core-threads").set(coreThreads.intValue());
                    }
                    if (maxThreads != null) {
                        timerServiceAdd.get("max-threads").set(maxThreads.intValue());
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block12;
                }
                case DATA_STORE: {
                    EJB3SubsystemXMLAttribute attribute;
                    String value;
                    int i;
                    int count = reader.getAttributeCount();
                    block14: for (i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        value = reader.getAttributeValue(i);
                        attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case PATH: {
                                if (dataStorePath != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePath = value;
                                continue block14;
                            }
                            case RELATIVE_TO: {
                                if (dataStorePathRelativeTo != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePathRelativeTo = value;
                                continue block14;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (dataStorePath == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.PATH));
                    }
                    timerServiceAdd.get("path").set(dataStorePath);
                    if (dataStorePathRelativeTo != null) {
                        timerServiceAdd.get("relative-to").set(dataStorePathRelativeTo);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(timerServiceAdd);
    }

    private boolean isPositiveInt(String val) {
        if (val == null || val.trim().isEmpty()) {
            return false;
        }
        try {
            Integer value = Integer.parseInt(val);
            if (value <= 0) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private boolean isValidTimeoutUnit(String val) {
        if (val == null || val.trim().isEmpty()) {
            return false;
        }
        String upperCaseUnitValue = val.toUpperCase(Locale.ENGLISH);
        try {
            TimeUnit unit = TimeUnit.valueOf(upperCaseUnitValue);
            if (unit == TimeUnit.SECONDS || unit == TimeUnit.HOURS || unit == TimeUnit.MINUTES || unit == TimeUnit.MILLISECONDS) {
                return true;
            }
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return false;
    }

    private void parseAttributes(XMLExtendedStreamReader reader, ModelNode node, EnumSet<EJB3SubsystemXMLAttribute> expectedAttributes, EnumSet<EJB3SubsystemXMLAttribute> requiredAttributes) throws XMLStreamException {
        EnumSet<EJB3SubsystemXMLAttribute> parsedAttributes = EnumSet.noneOf(EJB3SubsystemXMLAttribute.class);
        if (requiredAttributes == null) {
            requiredAttributes = EnumSet.noneOf(EJB3SubsystemXMLAttribute.class);
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            if (!expectedAttributes.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            if (!parsedAttributes.add(attribute)) {
                throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
            }
            requiredAttributes.remove((Object)attribute);
            node.get(attribute.getLocalName()).set(attrValue);
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
    }

    private ModelNode createSetDefaultSLSBPoolOperation(String poolName) {
        ModelNode setDefaultSLSBPoolOperation = new ModelNode();
        setDefaultSLSBPoolOperation.get("operation").set("write-attribute");
        setDefaultSLSBPoolOperation.get("address").set(this.getEJB3SubsystemAddress().toModelNode());
        setDefaultSLSBPoolOperation.get("name").set("default-slsb-instance-pool");
        setDefaultSLSBPoolOperation.get("value").set(poolName);
        return setDefaultSLSBPoolOperation;
    }

    private ModelNode createSetDefaultMDBPoolOperation(String poolName) {
        ModelNode setDefaultMDBPoolOperation = new ModelNode();
        setDefaultMDBPoolOperation.get("operation").set("write-attribute");
        setDefaultMDBPoolOperation.get("address").set(this.getEJB3SubsystemAddress().toModelNode());
        setDefaultMDBPoolOperation.get("name").set("default-mdb-instance-pool");
        setDefaultMDBPoolOperation.get("value").set(poolName);
        return setDefaultMDBPoolOperation;
    }

    private ModelNode createSetDefaultRAOperation(String resourceAdapterName) {
        ModelNode setDefaultRAName = new ModelNode();
        setDefaultRAName.get("operation").set("write-attribute");
        setDefaultRAName.get("address").set(this.getEJB3SubsystemAddress().toModelNode());
        setDefaultRAName.get("name").set("default-resource-adapter-name");
        setDefaultRAName.get("value").set(resourceAdapterName);
        return setDefaultRAName;
    }

    private ModelNode createAddStrictMaxBeanInstancePoolOperation(String name, Integer maxPoolSize, Long timeout, String timeoutUnit) {
        ModelNode addStrictMaxPoolOperation = new ModelNode();
        addStrictMaxPoolOperation.get("operation").set("add");
        PathAddress address = this.getEJB3SubsystemAddress().append(new PathElement[]{PathElement.pathElement((String)"strict-max-bean-instance-pool", (String)name)});
        addStrictMaxPoolOperation.get("address").set(address.toModelNode());
        if (maxPoolSize != null) {
            addStrictMaxPoolOperation.get("max-pool-size").set(maxPoolSize.intValue());
        }
        if (timeout != null) {
            addStrictMaxPoolOperation.get("timeout").set(timeout.longValue());
        }
        if (timeoutUnit != null) {
            addStrictMaxPoolOperation.get("timeout-unit").set(timeoutUnit);
        }
        return addStrictMaxPoolOperation;
    }

    private PathAddress getEJB3SubsystemAddress() {
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"ejb3")});
        return addr;
    }
}

