/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.io.Serializable;
import javax.ejb.ScheduleExpression;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.MethodResolutionUtils;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.ScheduleMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;
import org.jboss.modules.Module;

public class TimeoutMethodDeploymentDescriptorProcessor
extends AbstractEjbXmlDescriptorProcessor<SessionBeanMetaData> {
    @Override
    protected Class<SessionBeanMetaData> getMetaDataType() {
        return SessionBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(SessionBeanMetaData beanMetaData, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Class componentClass;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        SessionBeanComponentDescription sessionBean = (SessionBeanComponentDescription)moduleDescription.getComponentByName(beanMetaData.getEjbName());
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        if (sessionBean == null) {
            return;
        }
        try {
            componentClass = module.getClassLoader().loadClass(sessionBean.getComponentClassName());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Could not load EJB class " + sessionBean.getComponentClassName());
        }
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        if (beanMetaData.getTimeoutMethod() != null) {
            this.parseTimeoutMethod(beanMetaData, sessionBean, componentClass, deploymentReflectionIndex);
        }
        this.parseScheduleMethods(beanMetaData, sessionBean, componentClass, deploymentReflectionIndex);
    }

    private void parseScheduleMethods(SessionBeanMetaData beanMetaData, SessionBeanComponentDescription sessionBean, Class<?> componentClass, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        SessionBean31MetaData md;
        if (beanMetaData instanceof SessionBean31MetaData && (md = (SessionBean31MetaData)beanMetaData).getTimers() != null) {
            for (TimerMetaData timer : md.getTimers()) {
                AutoTimer autoTimer = new AutoTimer();
                autoTimer.getTimerConfig().setInfo((Serializable)((Object)timer.getInfo()));
                autoTimer.getTimerConfig().setPersistent(timer.isPersistent());
                ScheduleExpression scheduleExpression = autoTimer.getScheduleExpression();
                ScheduleMetaData schedule = timer.getSchedule();
                if (schedule != null) {
                    scheduleExpression.dayOfMonth(schedule.getDayOfMonth());
                    scheduleExpression.dayOfWeek(schedule.getDayOfWeek());
                    scheduleExpression.hour(schedule.getHour());
                    scheduleExpression.minute(schedule.getMinute());
                    scheduleExpression.month(schedule.getMonth());
                    scheduleExpression.second(schedule.getSecond());
                    scheduleExpression.year(schedule.getYear());
                }
                if (timer.getEnd() != null) {
                    scheduleExpression.end(timer.getEnd().getTime());
                }
                if (timer.getStart() != null) {
                    scheduleExpression.start(timer.getStart().getTime());
                }
                scheduleExpression.timezone(timer.getTimezone());
                sessionBean.addScheduleMethod(MethodResolutionUtils.resolveMethod(timer.getTimeoutMethod(), componentClass, deploymentReflectionIndex), autoTimer);
            }
        }
    }

    private void parseTimeoutMethod(SessionBeanMetaData beanMetaData, SessionBeanComponentDescription sessionBean, Class<?> componentClass, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        NamedMethodMetaData methodData = beanMetaData.getTimeoutMethod();
        sessionBean.setTimeoutMethod(MethodResolutionUtils.resolveMethod(methodData, componentClass, deploymentReflectionIndex));
    }
}

