/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class TransactionAttributeAnnotationProcessor
extends AbstractAnnotationEJBProcessor<EJBComponentDescription> {
    private static final DotName TRANSACTION_ATTRIBUTE_ANNOTATION_NAME = DotName.createSimple((String)TransactionAttribute.class.getName());

    @Override
    protected Class<EJBComponentDescription> getComponentDescriptionType() {
        return EJBComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex index, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        this.processViewAnnotations(index, componentDescription);
        this.processClassAnnotations(beanClass, null, index, componentDescription);
    }

    private void processClassAnnotations(ClassInfo beanClass, MethodIntf methodIntf, CompositeIndex index, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map classAnnotations;
        ClassInfo superClass;
        DotName superName = beanClass.superName();
        if (superName != null && (superClass = index.getClassByName(superName)) != null) {
            this.processClassAnnotations(superClass, methodIntf, index, componentDescription);
        }
        if ((classAnnotations = beanClass.annotations()) == null) {
            return;
        }
        List annotations = (List)classAnnotations.get(TRANSACTION_ATTRIBUTE_ANNOTATION_NAME);
        if (annotations == null) {
            return;
        }
        for (AnnotationInstance annotationInstance : annotations) {
            AnnotationTarget target = annotationInstance.target();
            TransactionAttributeType transactionAttributeType = TransactionAttributeType.valueOf((String)annotationInstance.value().asEnum());
            if (target instanceof ClassInfo) {
                String className = target.toString();
                componentDescription.setTransactionAttribute(methodIntf, methodIntf == null ? className : null, transactionAttributeType);
                continue;
            }
            if (!(target instanceof MethodInfo)) continue;
            MethodInfo method = (MethodInfo)target;
            String className = method.declaringClass().toString();
            componentDescription.setTransactionAttribute(methodIntf, transactionAttributeType, className, method.name(), TransactionAttributeAnnotationProcessor.toString(method.args()));
        }
    }

    private void processViewAnnotations(CompositeIndex index, EJBComponentDescription ejbComponentDescription) throws DeploymentUnitProcessingException {
        EJBViewDescription ejbViewDescription = null;
        for (ViewDescription viewDescription : ejbComponentDescription.getViews()) {
            ejbViewDescription = (EJBViewDescription)viewDescription;
            String viewClassName = viewDescription.getViewClassName();
            MethodIntf methodIntf = ejbViewDescription.getMethodIntf();
            ClassInfo viewClass = index.getClassByName(DotName.createSimple((String)viewClassName));
            if (viewClass == null) continue;
            this.processClassAnnotations(viewClass, methodIntf, index, ejbComponentDescription);
        }
    }

    private static String[] toString(Object[] a) {
        String[] result = new String[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i].toString();
        }
        return result;
    }
}

