/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.ejb.Schedule;
import javax.ejb.Schedules;
import javax.ejb.Timeout;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class TimeoutAnnotationProcessor
extends AbstractAnnotationEJBProcessor<SessionBeanComponentDescription> {
    private static final DotName TIMEOUT_ANNOTATION = DotName.createSimple((String)Timeout.class.getName());
    private static final DotName SCHEDULE_ANNOTATION = DotName.createSimple((String)Schedule.class.getName());
    private static final DotName SCHEDULES_ANNOTATION = DotName.createSimple((String)Schedules.class.getName());
    private static final Logger logger = Logger.getLogger(TimeoutAnnotationProcessor.class);
    private final boolean enabled;

    public TimeoutAnnotationProcessor(boolean timerServiceEnabled) {
        this.enabled = timerServiceEnabled;
    }

    @Override
    protected Class<SessionBeanComponentDescription> getComponentDescriptionType() {
        return SessionBeanComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        this.processTimeoutAnnotation(beanClass, compositeIndex, componentDescription);
        this.processScheduleAnnotation(beanClass, compositeIndex, componentDescription);
    }

    private void processTimeoutAnnotation(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo superClass;
        DotName superName;
        List annotations;
        Map classAnnotations = beanClass.annotations();
        if (classAnnotations != null && (annotations = (List)classAnnotations.get(TIMEOUT_ANNOTATION)) != null) {
            for (AnnotationInstance annotationInstance : annotations) {
                AnnotationTarget target = annotationInstance.target();
                if (!(target instanceof MethodInfo)) continue;
                componentDescription.setTimeoutMethodIdentifier(this.getMethodIdentifier(target));
                return;
            }
        }
        if ((superName = beanClass.superName()) != null && (superClass = compositeIndex.getClassByName(superName)) != null) {
            this.processTimeoutAnnotation(superClass, compositeIndex, componentDescription);
        }
    }

    private void processScheduleAnnotation(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo superClass;
        DotName superName;
        Map classAnnotations = beanClass.annotations();
        if (classAnnotations != null) {
            List schedules;
            List annotations = (List)classAnnotations.get(SCHEDULE_ANNOTATION);
            if (annotations != null) {
                for (AnnotationInstance annotationInstance : annotations) {
                    if (this.enabled) {
                        AnnotationTarget target = annotationInstance.target();
                        if (!(target instanceof MethodInfo)) continue;
                        MethodIdentifier identifier = this.getMethodIdentifier(target);
                        AutoTimer timer = new AutoTimer();
                        for (ScheduleValues schedulePart : ScheduleValues.values()) {
                            schedulePart.set(timer, annotationInstance);
                        }
                        componentDescription.addScheduleMethodIdentifier(identifier, timer);
                        continue;
                    }
                    logger.warn((Object)("@Schedule annotation found on " + annotationInstance.target() + " but timer service is not enabled"));
                }
            }
            if ((schedules = (List)classAnnotations.get(SCHEDULES_ANNOTATION)) != null) {
                for (AnnotationInstance annotationInstance : schedules) {
                    AnnotationTarget target = annotationInstance.target();
                    if (this.enabled) {
                        AnnotationInstance[] values;
                        if (!(target instanceof MethodInfo)) continue;
                        MethodIdentifier identifier = this.getMethodIdentifier(target);
                        for (AnnotationInstance schedule : values = annotationInstance.value().asNestedArray()) {
                            AutoTimer timer = new AutoTimer();
                            for (ScheduleValues schedulePart : ScheduleValues.values()) {
                                schedulePart.set(timer, schedule);
                            }
                            componentDescription.addScheduleMethodIdentifier(identifier, timer);
                        }
                        continue;
                    }
                    logger.warn((Object)("@Schedules annotation found on " + annotationInstance.target() + " but timer service is not enabled"));
                }
            }
        }
        if ((superName = beanClass.superName()) != null && (superClass = compositeIndex.getClassByName(superName)) != null) {
            this.processScheduleAnnotation(superClass, compositeIndex, componentDescription);
        }
    }

    private MethodIdentifier getMethodIdentifier(AnnotationTarget target) {
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        String[] args = new String[methodInfo.args().length];
        for (int i = 0; i < methodInfo.args().length; ++i) {
            args[i] = methodInfo.args()[i].name().toString();
        }
        return MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])args);
    }

    static enum ScheduleValues {
        DAY_OF_MONTH("dayOfMonth", "*"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().dayOfMonth(value);
            }
        }
        ,
        DAY_OF_WEEK("dayOfWeek", "*"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().dayOfWeek(value);
            }
        }
        ,
        HOUR("hour", "0"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().hour(value);
            }
        }
        ,
        INFO("info", null){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getTimerConfig().setInfo((Serializable)((Object)value));
            }
        }
        ,
        MINUTE("minute", "0"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().minute(value);
            }
        }
        ,
        MONTH("month", "*"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().month(value);
            }
        }
        ,
        PERSISTENT("persistent", true){

            @Override
            protected void setBoolean(AutoTimer timer, boolean value) {
                timer.getTimerConfig().setPersistent(value);
            }
        }
        ,
        SECOND("second", "0"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().second(value);
            }
        }
        ,
        TIMEZONE("timezone", ""){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().timezone(value);
            }
        }
        ,
        YEAR("year", "*"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().year(value);
            }
        };

        private final String name;
        private final String defaultStringValue;
        private final boolean defaultBooleanValue;
        private final boolean booleanValue;

        private ScheduleValues(String name, String defaultStringValue) {
            this.name = name;
            this.defaultStringValue = defaultStringValue;
            this.defaultBooleanValue = false;
            this.booleanValue = false;
        }

        private ScheduleValues(String name, boolean defaultBooleanValue) {
            this.name = name;
            this.defaultStringValue = null;
            this.defaultBooleanValue = defaultBooleanValue;
            this.booleanValue = true;
        }

        public void set(AutoTimer timer, AnnotationInstance annotationInstance) {
            AnnotationValue value = annotationInstance.value(this.name);
            if (this.booleanValue) {
                if (value == null) {
                    this.setBoolean(timer, this.defaultBooleanValue);
                } else {
                    this.setBoolean(timer, value.asBoolean());
                }
            } else if (value == null) {
                this.setString(timer, this.defaultStringValue);
            } else {
                this.setString(timer, value.asString());
            }
        }

        protected void setString(AutoTimer expression, String value) {
            throw new IllegalStateException("Should be overridden");
        }

        protected void setBoolean(AutoTimer expression, boolean value) {
            throw new IllegalStateException("Should be overridden");
        }
    }
}

