/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.parser.spec.EjbJarMetaDataParser;
import org.jboss.metadata.ejb.spec.EjbJar31MetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.vfs.VirtualFile;

public class EjbJarParsingDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private static Logger logger = Logger.getLogger(EjbJarParsingDeploymentUnitProcessor.class);
    private static final String WAR_FILE_EXTENSION = ".war";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String EJB_JAR_XML_LOCATION_IN_WAR = "WEB-INF/ejb-jar.xml";
    private static final String EJB_JAR_XML_LOCATION_IN_JAR = "META-INF/ejb-jar.xml";

    public void deploy(DeploymentPhaseContext deploymentPhase) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = deploymentPhase.getDeploymentUnit();
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT)).getRoot();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        VirtualFile ejbJarXml = null;
        if (deploymentRoot.getName().toLowerCase().endsWith(WAR_FILE_EXTENSION)) {
            ejbJarXml = deploymentRoot.getChild(EJB_JAR_XML_LOCATION_IN_WAR);
        } else if (deploymentRoot.getName().toLowerCase().endsWith(JAR_FILE_EXTENSION)) {
            ejbJarXml = deploymentRoot.getChild(EJB_JAR_XML_LOCATION_IN_JAR);
        } else {
            return;
        }
        if (ejbJarXml == null || !ejbJarXml.exists()) {
            return;
        }
        EjbDeploymentMarker.mark(deploymentUnit);
        if (!deploymentUnit.hasAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION)) {
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            EjbJarDescription ejbModuleDescription = new EjbJarDescription(moduleDescription, applicationClassesDescription, deploymentUnit.getName().endsWith(WAR_FILE_EXTENSION));
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION, (Object)ejbModuleDescription);
        }
        MetaDataElementParser.DTDInfo dtdInfo = new MetaDataElementParser.DTDInfo();
        InputStream stream = null;
        try {
            EjbJar31MetaData ejbJar31MetaData;
            stream = ejbJarXml.openStream();
            XMLStreamReader reader = this.getXMLStreamReader(stream, ejbJarXml, (XMLResolver)dtdInfo);
            EjbJarMetaData ejbJarMetaData = EjbJarMetaDataParser.parse((XMLStreamReader)reader, (MetaDataElementParser.DTDInfo)dtdInfo);
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA, (Object)ejbJarMetaData);
            if (ejbJarMetaData instanceof EjbJar31MetaData && (ejbJar31MetaData = (EjbJar31MetaData)ejbJarMetaData).getModuleName() != null) {
                eeModuleDescription.setModuleName(ejbJar31MetaData.getModuleName());
            }
        }
        catch (XMLStreamException xmlse) {
            throw new DeploymentUnitProcessingException("Exception while parsing ejb-jar.xml: " + ejbJarXml.getPathName(), (Throwable)xmlse);
        }
        catch (IOException ioe) {
            throw new DeploymentUnitProcessingException("Failed to create reader for ejb-jar.xml: " + ejbJarXml.getPathName(), (Throwable)ioe);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ioe) {
                logger.debug((Object)"Ignoring exception while closing the InputStream ", (Throwable)ioe);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }

    private XMLStreamReader getXMLStreamReader(InputStream stream, VirtualFile ejbJarXml, XMLResolver resolver) throws DeploymentUnitProcessingException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(resolver);
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(stream);
            return xmlReader;
        }
        catch (XMLStreamException xmlse) {
            throw new DeploymentUnitProcessingException("Failed to create reader for ejb-jar.xml: " + ejbJarXml.getPathName(), (Throwable)xmlse);
        }
    }
}

