/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class AccessTimeoutAnnotationProcessor
extends AbstractAnnotationEJBProcessor<SessionBeanComponentDescription> {
    private static final Logger logger = Logger.getLogger(AccessTimeoutAnnotationProcessor.class);
    private static final DotName ACCESS_TIMEOUT_ANNOTATION_DOT_NAME = DotName.createSimple((String)AccessTimeout.class.getName());

    @Override
    protected Class<SessionBeanComponentDescription> getComponentDescriptionType() {
        return SessionBeanComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        this.processAccessTimeoutAnnotations(beanClass, compositeIndex, componentDescription);
    }

    private void processAccessTimeoutAnnotations(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map classAnnotations;
        ClassInfo superClass;
        DotName superName = beanClass.superName();
        if (superName != null && (superClass = compositeIndex.getClassByName(superName)) != null) {
            this.processAccessTimeoutAnnotations(superClass, compositeIndex, componentDescription);
        }
        if ((classAnnotations = beanClass.annotations()) == null) {
            return;
        }
        List annotations = (List)classAnnotations.get(ACCESS_TIMEOUT_ANNOTATION_DOT_NAME);
        if (annotations == null) {
            return;
        }
        for (AnnotationInstance annotationInstance : annotations) {
            AnnotationTarget target = annotationInstance.target();
            AccessTimeout accessTimeout = this.getAccessTimeout(annotationInstance);
            if (target instanceof ClassInfo) {
                componentDescription.setBeanLevelAccessTimeout(((ClassInfo)target).name().toString(), accessTimeout);
                logger.debug((Object)("Bean " + componentDescription.getEJBName() + " marked for access timeout: " + accessTimeout));
                continue;
            }
            if (!(target instanceof MethodInfo)) continue;
            MethodInfo methodInfo = (MethodInfo)target;
            String[] argTypes = new String[methodInfo.args().length];
            int i = 0;
            for (Type argType : methodInfo.args()) {
                argTypes[i++] = argType.name().toString();
            }
            MethodIdentifier identifier = MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])argTypes);
            componentDescription.setAccessTimeout(accessTimeout, identifier);
        }
    }

    private AccessTimeout getAccessTimeout(AnnotationInstance annotationInstance) {
        final long timeout = annotationInstance.value().asLong();
        AnnotationValue unitAnnVal = annotationInstance.value("unit");
        final TimeUnit unit = unitAnnVal != null ? TimeUnit.valueOf(unitAnnVal.asEnum()) : TimeUnit.MILLISECONDS;
        return new AccessTimeout(){

            public long value() {
                return timeout;
            }

            public TimeUnit unit() {
                return unit;
            }

            public Class<? extends Annotation> annotationType() {
                return AccessTimeout.class;
            }
        };
    }
}

