/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class StatefulIdentityInterceptorFactory
implements InterceptorFactory {
    private final Object sessionIdContextKey;

    public StatefulIdentityInterceptorFactory(Object sessionIdContextKey) {
        this.sessionIdContextKey = sessionIdContextKey;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        AtomicReference sessionIdReference = (AtomicReference)context.getContextData().get(this.sessionIdContextKey);
        ComponentView componentView = (ComponentView)context.getContextData().get(ComponentView.class);
        return new StatefulIdentityInterceptor(componentView, sessionIdReference);
    }

    private static class SessionIdHolder {
        private final Serializable sessionId;

        public SessionIdHolder(Serializable sessionId) {
            this.sessionId = sessionId;
        }
    }

    private class StatefulIdentityInterceptor
    implements Interceptor {
        private final ComponentView componentView;
        final AtomicReference<Serializable> sessionIdReference;

        public StatefulIdentityInterceptor(ComponentView componentView, AtomicReference<Serializable> sessionIdReference) {
            this.componentView = componentView;
            this.sessionIdReference = sessionIdReference;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            if (context.getMethod().getName().equals("equals") && context.getParameters().length == 1 && context.getMethod().getParameterTypes()[0] == Object.class) {
                Object other = context.getParameters()[0];
                Class proxyType = this.componentView.getProxyClass();
                if (proxyType.isAssignableFrom(other.getClass())) {
                    return other.equals(new SessionIdHolder(this.sessionIdReference.get()));
                }
                if (other instanceof SessionIdHolder) {
                    return this.sessionIdReference.get().equals(((SessionIdHolder)other).sessionId);
                }
                return false;
            }
            if (context.getMethod().getName().equals("hashCode")) {
                return this.sessionIdReference.get().hashCode();
            }
            return context.proceed();
        }
    }
}

