/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.singleton;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.ComponentTypeIdentityInterceptorFactory;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonBMTInterceptor;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.singleton.SingletonComponentInstanceAssociationInterceptor;
import org.jboss.as.ejb3.concurrency.ContainerManagedConcurrencyInterceptorFactory;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.tx.SingletonLifecycleCMTTxInterceptorFactory;
import org.jboss.as.ejb3.tx.TimerCMTTxInterceptorFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.service.ServiceName;

public class SingletonComponentDescription
extends SessionBeanComponentDescription {
    private boolean initOnStartup;
    private final List<ServiceName> dependsOn = new ArrayList<ServiceName>();

    public SingletonComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnitServiceName);
        this.addConcurrencyManagementInterceptor();
    }

    public ComponentConfiguration createConfiguration(EEApplicationDescription applicationDescription) {
        ComponentConfiguration singletonComponentConfiguration = new ComponentConfiguration((ComponentDescription)this, applicationDescription.getClassConfiguration(this.getComponentClassName()));
        singletonComponentConfiguration.setComponentCreateServiceFactory((ComponentCreateServiceFactory)new SingletonComponentCreateServiceFactory(this.isInitOnStartup(), this.dependsOn));
        if (this.getTransactionManagementType().equals((Object)TransactionManagementType.CONTAINER)) {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    TransactionAttributeType txAttr;
                    if (SingletonComponentDescription.this.getClassDescription().getPostConstructMethod() != null) {
                        txAttr = SingletonComponentDescription.this.getTransactionAttribute(MethodIntf.BEAN, SingletonComponentDescription.this.getClassDescription().getClassName(), SingletonComponentDescription.this.getClassDescription().getPostConstructMethod().getName(), SingletonComponentDescription.this.getClassDescription().getPostConstructMethod().getParameterTypes());
                        configuration.addPostConstructInterceptor((InterceptorFactory)new SingletonLifecycleCMTTxInterceptorFactory(txAttr), 768);
                    }
                    if (SingletonComponentDescription.this.getClassDescription().getPreDestroyMethod() != null) {
                        txAttr = SingletonComponentDescription.this.getTransactionAttribute(MethodIntf.BEAN, SingletonComponentDescription.this.getClassDescription().getClassName(), SingletonComponentDescription.this.getClassDescription().getPreDestroyMethod().getName(), SingletonComponentDescription.this.getClassDescription().getPreDestroyMethod().getParameterTypes());
                        configuration.addPreDestroyInterceptor((InterceptorFactory)new SingletonLifecycleCMTTxInterceptorFactory(txAttr), 768);
                    }
                    configuration.addTimeoutInterceptor((InterceptorFactory)TimerCMTTxInterceptorFactory.INSTANCE, 1040);
                }
            });
        } else {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    ComponentInstanceInterceptorFactory slsbBmtInterceptorFactory = new ComponentInstanceInterceptorFactory(){

                        protected Interceptor create(Component component, InterceptorFactoryContext context) {
                            if (!(component instanceof SingletonComponent)) {
                                throw new IllegalArgumentException("Component " + component + " with component class: " + component.getComponentClass() + " isn't a singleton component");
                            }
                            return new SingletonBMTInterceptor((SingletonComponent)component);
                        }
                    };
                    if (SingletonComponentDescription.this.getClassDescription().getPostConstructMethod() != null) {
                        configuration.addPostConstructInterceptor((InterceptorFactory)slsbBmtInterceptorFactory, 768);
                    }
                    if (SingletonComponentDescription.this.getClassDescription().getPreDestroyMethod() != null) {
                        configuration.addPreDestroyInterceptor((InterceptorFactory)slsbBmtInterceptorFactory, 768);
                    }
                    configuration.addComponentInterceptor((InterceptorFactory)slsbBmtInterceptorFactory, 1024, false);
                    configuration.addTimeoutInterceptor((InterceptorFactory)slsbBmtInterceptorFactory, 1024);
                }
            });
        }
        return singletonComponentConfiguration;
    }

    public boolean isInitOnStartup() {
        return this.initOnStartup;
    }

    public void initOnStartup() {
        this.initOnStartup = true;
    }

    @Override
    public boolean allowsConcurrentAccess() {
        return true;
    }

    @Override
    public SessionBeanComponentDescription.SessionBeanType getSessionBeanType() {
        return SessionBeanComponentDescription.SessionBeanType.SINGLETON;
    }

    @Override
    protected void setupViewInterceptors(ViewDescription view) {
        super.setupViewInterceptors(view);
        view.getConfigurators().addFirst(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                    if ((!method.getName().equals("hashCode") || method.getParameterTypes().length != 0) && (!method.getName().equals("equals") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Object.class)) continue;
                    configuration.addViewInterceptor(method, (InterceptorFactory)ComponentTypeIdentityInterceptorFactory.INSTANCE, 256);
                }
                configuration.addViewInterceptor(SingletonComponentInstanceAssociationInterceptor.FACTORY, 1280);
            }
        });
    }

    private void addConcurrencyManagementInterceptor() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                SingletonComponentDescription singletonComponentDescription = (SingletonComponentDescription)description;
                if (singletonComponentDescription.getConcurrencyManagementType() == ConcurrencyManagementType.BEAN) {
                    return;
                }
                configuration.addComponentInterceptor((InterceptorFactory)ContainerManagedConcurrencyInterceptorFactory.INSTANCE, 1792, true);
                configuration.addTimeoutInterceptor((InterceptorFactory)ContainerManagedConcurrencyInterceptorFactory.INSTANCE, 1792);
            }
        });
    }

    public List<ServiceName> getDependsOn() {
        return this.dependsOn;
    }

    public boolean isTimerServiceApplicable() {
        return true;
    }
}

