/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.nio.AbstractNioChannelThread;
import org.xnio.nio.NioSetter;

final class NioHandle<C extends Channel> {
    private final SelectionKey selectionKey;
    private final AbstractNioChannelThread channelThread;
    private final NioSetter<C> handlerSetter;
    private final C channel;

    NioHandle(SelectionKey selectionKey, AbstractNioChannelThread channelThread, NioSetter<C> handlerSetter, C channel) {
        this.selectionKey = selectionKey;
        this.channelThread = channelThread;
        this.handlerSetter = handlerSetter;
        this.channel = channel;
    }

    SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    AbstractNioChannelThread getChannelThread() {
        return this.channelThread;
    }

    NioSetter<C> getHandlerSetter() {
        return this.handlerSetter;
    }

    void cancelKey() {
        this.channelThread.cancelKey(this.selectionKey);
    }

    void resume(int op) {
        this.channelThread.setOps(this.selectionKey, op);
    }

    void suspend() {
        this.channelThread.setOps(this.selectionKey, 0);
    }

    C getChannel() {
        return this.channel;
    }

    void invoke() {
        ChannelListener<C> listener = this.handlerSetter.get();
        if (listener == null) {
            this.suspend();
        } else {
            ChannelListeners.invokeChannelListener(this.channel, listener);
        }
    }
}

