/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.stack.AckReceiverWindow;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Reliable unicast layer")
@DeprecatedProperty(names={"immediate_ack", "use_gms", "enabled_mbrs_timeout", "eager_lock_release"})
public class UNICAST
extends Protocol
implements AckSenderWindow.RetransmitCommand,
AgeOutCache.Handler<Address> {
    public static final long DEFAULT_FIRST_SEQNO = 1L;
    @Property(description="Whether to loop back messages sent to self. Default is false", deprecatedMessage="might get removed soon as it can destroy ordering. See https://jira.jboss.org/jira/browse/JGRP-1092 for details")
    @Deprecated
    private boolean loopback = false;
    private long[] timeout = new long[]{400L, 800L, 1600L, 3200L};
    @Property(description="Max number of messages to be removed from the AckReceiverWindow. This property might get removed anytime, so don't use it !")
    private int max_msg_batch_size = 50000;
    private long num_msgs_sent = 0L;
    private long num_msgs_received = 0L;
    private long num_bytes_sent = 0L;
    private long num_bytes_received = 0L;
    private long num_acks_sent = 0L;
    private long num_acks_received = 0L;
    private long num_xmits = 0L;
    private final ConcurrentMap<Address, SenderEntry> send_table = Util.createConcurrentMap();
    private final ConcurrentMap<Address, ReceiverEntry> recv_table = Util.createConcurrentMap();
    private final Vector<Address> members = new Vector(11);
    private Address local_addr = null;
    private TimeScheduler timer = null;
    private boolean started = false;
    private volatile boolean disconnected = false;
    private short last_conn_id = 0;
    protected long max_retransmit_time = 60000L;
    private AgeOutCache<Address> cache = null;

    @Deprecated
    @ManagedAttribute
    public static int getUndeliveredMessages() {
        return 0;
    }

    public long[] getTimeout() {
        return this.timeout;
    }

    @Property(name="timeout", converter=PropertyConverters.LongArray.class)
    public void setTimeout(long[] val) {
        if (val != null) {
            this.timeout = val;
        }
    }

    public void setMaxMessageBatchSize(int size) {
        if (size >= 1) {
            this.max_msg_batch_size = size;
        }
    }

    @ManagedAttribute
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getMembers() {
        return this.members != null ? this.members.toString() : "[]";
    }

    @ManagedOperation
    public String printConnections() {
        StringBuilder sb = new StringBuilder();
        if (!this.send_table.isEmpty()) {
            sb.append("\nsend connections:\n");
            for (Map.Entry entry : this.send_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        if (!this.recv_table.isEmpty()) {
            sb.append("\nreceive connections:\n");
            for (Map.Entry entry : this.recv_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    @ManagedAttribute
    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    @ManagedAttribute
    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    @ManagedAttribute
    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    @ManagedAttribute
    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    @ManagedAttribute
    public long getNumAcksSent() {
        return this.num_acks_sent;
    }

    @ManagedAttribute
    public long getNumAcksReceived() {
        return this.num_acks_received;
    }

    @ManagedAttribute
    public long getNumberOfRetransmissions() {
        return this.num_xmits;
    }

    public long getMaxRetransmitTime() {
        return this.max_retransmit_time;
    }

    @Property(description="Max number of milliseconds we try to retransmit a message to any given member. After that, the connection is removed. Any new connection to that member will start with seqno #1 again. 0 disables this")
    public void setMaxRetransmitTime(long max_retransmit_time) {
        this.max_retransmit_time = max_retransmit_time;
        if (this.cache != null && max_retransmit_time > 0L) {
            this.cache.setTimeout(max_retransmit_time);
        }
    }

    @ManagedAttribute
    public int getAgeOutCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    @ManagedOperation
    public String printAgeOutCache() {
        return this.cache != null ? this.cache.toString() : "n/a";
    }

    public AgeOutCache<Address> getAgeOutCache() {
        return this.cache;
    }

    @ManagedAttribute
    public int getNumberOfUnackedMessages() {
        int num = 0;
        for (SenderEntry entry : this.send_table.values()) {
            if (entry.sent_msgs == null) continue;
            num += entry.sent_msgs.size();
        }
        return num;
    }

    @ManagedOperation
    public String printUnackedMessages() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.send_table.entrySet()) {
            sb.append(entry.getKey()).append(": ");
            SenderEntry val = (SenderEntry)entry.getValue();
            if (val.sent_msgs == null) continue;
            sb.append(val.sent_msgs).append("\n");
        }
        return sb.toString();
    }

    @ManagedAttribute
    public int getNumberOfMessagesInReceiveWindows() {
        int num = 0;
        for (ReceiverEntry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            num += entry.received_msgs.size();
        }
        return num;
    }

    @Override
    public void resetStats() {
        this.num_acks_received = 0L;
        this.num_acks_sent = 0L;
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_xmits = 0L;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> m = super.dumpStats();
        m.put("unacked_msgs", this.printUnackedMessages());
        m.put("num_msgs_sent", this.num_msgs_sent);
        m.put("num_msgs_received", this.num_msgs_received);
        m.put("num_bytes_sent", this.num_bytes_sent);
        m.put("num_bytes_received", this.num_bytes_received);
        m.put("num_acks_sent", this.num_acks_sent);
        m.put("num_acks_received", this.num_acks_received);
        m.put("num_xmits", this.num_xmits);
        m.put("num_unacked_msgs", this.getNumberOfUnackedMessages());
        m.put("num_msgs_in_recv_windows", this.getNumberOfMessagesInReceiveWindows());
        return m;
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.max_retransmit_time > 0L) {
            this.cache = new AgeOutCache(this.timer, this.max_retransmit_time, this);
        }
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
        this.removeAllConnections();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress() || msg.isFlagSet((byte)16) || (hdr = (UnicastHeader)msg.getHeader(this.id)) == null) break;
                Address src = msg.getSrc();
                switch (hdr.type) {
                    case 0: {
                        this.handleDataReceived(src, hdr.seqno, hdr.conn_id, hdr.first, msg, evt);
                        return null;
                    }
                    case 1: {
                        this.handleAckReceived(src, hdr.seqno);
                        break;
                    }
                    case 2: {
                        this.handleResendingOfFirstMessage(src);
                        break;
                    }
                    default: {
                        this.log.error("UnicastHeader type " + hdr.type + " not known !");
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress() || msg.isFlagSet((byte)16)) break;
                if (!this.started) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("discarded message as start() has not yet been called, message: " + msg);
                    }
                    return null;
                }
                SenderEntry entry = (SenderEntry)this.send_table.get(dst);
                if (entry == null) {
                    entry = new SenderEntry(this.getNewConnectionId(), this, this.timeout, this.timer, this.local_addr);
                    SenderEntry existing = this.send_table.putIfAbsent(dst, entry);
                    if (existing != null) {
                        entry = existing;
                    } else {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": created connection to " + dst);
                        }
                        if (this.cache != null && !this.members.contains(dst)) {
                            this.cache.add(dst);
                        }
                    }
                }
                long seqno = -2L;
                short send_conn_id = -1;
                entry.lock();
                try {
                    seqno = entry.sent_msgs_seqno;
                    send_conn_id = entry.send_conn_id;
                    hdr = UnicastHeader.createDataHeader(seqno, send_conn_id, seqno == 1L);
                    msg.putHeader(this.id, hdr);
                    entry.sent_msgs.addToMessages(seqno, msg);
                    ++entry.sent_msgs_seqno;
                }
                finally {
                    entry.unlock();
                }
                long sleep_time = 100L;
                for (int i = 1; i <= 10; ++i) {
                    try {
                        entry.sent_msgs.addToRetransmitter(seqno, msg);
                        break;
                    }
                    catch (Throwable t) {
                        this.log.error("failed adding message " + seqno + " to " + dst + " to the retransmitter, retrying... (attempt #" + i + ")");
                        Util.sleep(sleep_time);
                        sleep_time *= 2L;
                        continue;
                    }
                }
                if (this.log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.local_addr).append(" --> DATA(").append(dst).append(": #").append(seqno).append(", conn_id=").append(send_conn_id);
                    if (hdr.first) {
                        sb.append(", first");
                    }
                    sb.append(')');
                    this.log.trace(sb);
                }
                try {
                    this.send(msg, evt);
                }
                catch (Throwable t) {
                    this.log.warn("failed sending the message", t);
                }
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                Vector<Address> new_members = view.getMembers();
                HashSet non_members = new HashSet(this.send_table.keySet());
                non_members.addAll(this.recv_table.keySet());
                Vector<Address> vector = this.members;
                synchronized (vector) {
                    this.members.clear();
                    if (new_members != null) {
                        this.members.addAll(new_members);
                    }
                    non_members.removeAll(this.members);
                    if (this.cache != null) {
                        this.cache.removeAll(this.members);
                    }
                }
                if (non_members.isEmpty()) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("removing non members " + non_members);
                }
                for (Address non_mbr : non_members) {
                    this.removeConnection(non_mbr);
                }
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 2: {
                this.disconnected = false;
                break;
            }
            case 4: {
                this.disconnected = true;
            }
        }
        return this.down_prot.down(evt);
    }

    private void send(Message msg, Event evt) {
        this.down_prot.down(evt);
        ++this.num_msgs_sent;
        this.num_bytes_sent += (long)msg.getLength();
    }

    public void removeConnection(Address mbr) {
        ReceiverEntry entry2;
        SenderEntry entry = (SenderEntry)this.send_table.remove(mbr);
        if (entry != null) {
            entry.reset();
        }
        if ((entry2 = (ReceiverEntry)this.recv_table.remove(mbr)) != null) {
            entry2.reset();
        }
    }

    @ManagedOperation(description="Trashes all connections to other nodes. This is only used for testing")
    public void removeAllConnections() {
        for (SenderEntry entry : this.send_table.values()) {
            entry.reset();
        }
        this.send_table.clear();
        for (ReceiverEntry entry2 : this.recv_table.values()) {
            entry2.reset();
        }
        this.recv_table.clear();
    }

    @Override
    public void retransmit(long seqno, Message msg) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " --> XMIT(" + msg.getDest() + ": #" + seqno + ')');
        }
        this.down_prot.down(new Event(1, msg));
        ++this.num_xmits;
    }

    @Override
    public void expired(Address key) {
        if (key != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("removing connection to " + key + " because it expired");
            }
            this.removeConnection(key);
        }
    }

    private void handleDataReceived(Address sender, long seqno, long conn_id, boolean first, Message msg, Event evt) {
        AtomicBoolean processing;
        ReceiverEntry entry;
        AckReceiverWindow win;
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" <-- DATA(").append(sender).append(": #").append(seqno);
            if (conn_id != 0L) {
                sb.append(", conn_id=").append(conn_id);
            }
            if (first) {
                sb.append(", first");
            }
            sb.append(')');
            this.log.trace(sb);
        }
        AckReceiverWindow ackReceiverWindow = win = (entry = (ReceiverEntry)this.recv_table.get(sender)) != null ? entry.received_msgs : null;
        if (first) {
            if (entry == null) {
                entry = this.getOrCreateReceiverEntry(sender, seqno, conn_id);
                win = entry.received_msgs;
            } else if (conn_id != entry.recv_conn_id) {
                ReceiverEntry entry2;
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": conn_id=" + conn_id + " != " + entry.recv_conn_id + "; resetting receiver window");
                }
                if ((entry2 = (ReceiverEntry)this.recv_table.remove(sender)) != null) {
                    entry2.received_msgs.reset();
                }
                entry = this.getOrCreateReceiverEntry(sender, seqno, conn_id);
                win = entry.received_msgs;
            }
        } else if (win == null || entry.recv_conn_id != conn_id) {
            this.sendRequestForFirstSeqno(sender);
            return;
        }
        byte result = win.add2(seqno, msg);
        boolean added = result > 0;
        ++this.num_msgs_received;
        this.num_bytes_received += (long)msg.getLength();
        if (result == -1) {
            this.sendAck(sender, seqno);
        }
        if (msg.isFlagSet((byte)1) && added) {
            try {
                this.up_prot.up(evt);
            }
            catch (Throwable t) {
                this.log.error("couldn't deliver OOB message " + msg, t);
            }
        }
        if (!(processing = win.getProcessing()).compareAndSet(false, true)) {
            return;
        }
        try {
            block9: while (true) {
                Tuple<List<Message>, Long> tuple;
                if ((tuple = win.removeMany(this.max_msg_batch_size)) == null) {
                    return;
                }
                List<Message> msgs = tuple.getVal1();
                if (msgs.isEmpty()) {
                    return;
                }
                long highest_removed = tuple.getVal2();
                if (highest_removed > 0L) {
                    this.sendAck(sender, highest_removed);
                }
                Iterator<Message> i$ = msgs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block9;
                    Message m = i$.next();
                    if (m.isFlagSet((byte)1)) continue;
                    try {
                        this.up_prot.up(new Event(1, m));
                    }
                    catch (Throwable t) {
                        this.log.error("couldn't deliver message " + m, t);
                    }
                }
                break;
            }
        }
        finally {
            processing.set(false);
        }
    }

    private ReceiverEntry getOrCreateReceiverEntry(Address sender, long seqno, long conn_id) {
        ReceiverEntry entry = new ReceiverEntry(new AckReceiverWindow(seqno), conn_id);
        ReceiverEntry entry2 = this.recv_table.putIfAbsent(sender, entry);
        if (entry2 != null) {
            return entry2;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": created receiver window for " + sender + " at seqno=#" + seqno + " for conn-id=" + conn_id);
        }
        return entry;
    }

    private void handleAckReceived(Address sender, long seqno) {
        SenderEntry entry;
        AckSenderWindow win;
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(" <-- ACK(").append(sender).append(": #").append(seqno).append(')'));
        }
        AckSenderWindow ackSenderWindow = win = (entry = (SenderEntry)this.send_table.get(sender)) != null ? entry.sent_msgs : null;
        if (win != null) {
            win.ack(seqno);
            ++this.num_acks_received;
        }
    }

    private void handleResendingOfFirstMessage(Address sender) {
        SenderEntry entry;
        AckSenderWindow win;
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " <-- SEND_FIRST_SEQNO(" + sender + ")");
        }
        AckSenderWindow ackSenderWindow = win = (entry = (SenderEntry)this.send_table.get(sender)) != null ? entry.sent_msgs : null;
        if (win == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.local_addr + ": sender window for " + sender + " not found");
            }
            return;
        }
        Message rsp = win.getLowestMessage();
        if (rsp == null) {
            return;
        }
        Message copy = rsp.copy();
        UnicastHeader hdr = (UnicastHeader)copy.getHeader(this.id);
        UnicastHeader newhdr = hdr.copy();
        newhdr.first = true;
        copy.putHeader(this.id, newhdr);
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" --> DATA(").append(copy.getDest()).append(": #").append(newhdr.seqno).append(", conn_id=").append(newhdr.conn_id);
            if (newhdr.first) {
                sb.append(", first");
            }
            sb.append(')');
            this.log.trace(sb);
        }
        this.down_prot.down(new Event(1, copy));
    }

    private void sendAck(Address dst, long seqno) {
        if (this.disconnected) {
            return;
        }
        Message ack = new Message(dst);
        ack.putHeader(this.id, UnicastHeader.createAckHeader(seqno));
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(" --> ACK(").append(dst).append(": #").append(seqno).append(')'));
        }
        try {
            this.down_prot.down(new Event(1, ack));
            ++this.num_acks_sent;
        }
        catch (Throwable t) {
            this.log.error("failed sending ACK(" + seqno + ") to " + dst, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getNewConnectionId() {
        UNICAST uNICAST = this;
        synchronized (uNICAST) {
            short retval = this.last_conn_id;
            this.last_conn_id = this.last_conn_id >= Short.MAX_VALUE || this.last_conn_id < 0 ? (short)0 : (short)(this.last_conn_id + 1);
            return retval;
        }
    }

    private void sendRequestForFirstSeqno(Address dest) {
        Message msg = new Message(dest);
        msg.setFlag((byte)1);
        UnicastHeader hdr = UnicastHeader.createSendFirstSeqnoHeader();
        msg.putHeader(this.id, hdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " --> SEND_FIRST_SEQNO(" + dest + ")");
        }
        this.down_prot.down(new Event(1, msg));
    }

    private static final class ReceiverEntry {
        private final AckReceiverWindow received_msgs;
        private final long recv_conn_id;

        public ReceiverEntry(AckReceiverWindow received_msgs, long recv_conn_id) {
            this.received_msgs = received_msgs;
            this.recv_conn_id = recv_conn_id;
        }

        void reset() {
            if (this.received_msgs != null) {
                this.received_msgs.reset();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.received_msgs != null) {
                sb.append(this.received_msgs).append(", ");
            }
            sb.append("recv_conn_id=" + this.recv_conn_id);
            return sb.toString();
        }
    }

    private static final class SenderEntry {
        final AckSenderWindow sent_msgs;
        long sent_msgs_seqno = 1L;
        final short send_conn_id;
        final Lock lock = new ReentrantLock();

        public SenderEntry(short send_conn_id, AckSenderWindow.RetransmitCommand cmd, long[] timeout, TimeScheduler timer, Address local_addr) {
            this.send_conn_id = send_conn_id;
            this.sent_msgs = new AckSenderWindow(cmd, new StaticInterval(timeout), timer, local_addr);
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        void reset() {
            if (this.sent_msgs != null) {
                this.sent_msgs.reset();
            }
            this.sent_msgs_seqno = 1L;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.sent_msgs != null) {
                sb.append(this.sent_msgs).append(", ");
            }
            sb.append("send_conn_id=" + this.send_conn_id);
            return sb.toString();
        }
    }

    public static class UnicastHeader
    extends Header {
        public static final byte DATA = 0;
        public static final byte ACK = 1;
        public static final byte SEND_FIRST_SEQNO = 2;
        byte type;
        long seqno;
        short conn_id;
        boolean first;

        public UnicastHeader() {
        }

        public static UnicastHeader createDataHeader(long seqno, short conn_id, boolean first) {
            return new UnicastHeader(0, seqno, conn_id, first);
        }

        public static UnicastHeader createAckHeader(long seqno) {
            return new UnicastHeader(1, seqno);
        }

        public static UnicastHeader createSendFirstSeqnoHeader() {
            return new UnicastHeader(2, 0L);
        }

        private UnicastHeader(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        private UnicastHeader(byte type, long seqno, short conn_id, boolean first) {
            this.type = type;
            this.seqno = seqno;
            this.conn_id = conn_id;
            this.first = first;
        }

        public long getSeqno() {
            return this.seqno;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(UnicastHeader.type2Str(this.type)).append(", seqno=").append(this.seqno);
            if (this.conn_id != 0) {
                sb.append(", conn_id=").append(this.conn_id);
            }
            if (this.first) {
                sb.append(", first");
            }
            return sb.toString();
        }

        public static String type2Str(byte t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "ACK";
                }
                case 2: {
                    return "SEND_FIRST_SEQNO";
                }
            }
            return "<unknown>";
        }

        @Override
        public final int size() {
            switch (this.type) {
                case 0: {
                    return 12;
                }
                case 1: {
                    return 9;
                }
                case 2: {
                    return 1;
                }
            }
            return 0;
        }

        public UnicastHeader copy() {
            return new UnicastHeader(this.type, this.seqno, this.conn_id, this.first);
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            switch (this.type) {
                case 0: {
                    out.writeLong(this.seqno);
                    out.writeShort(this.conn_id);
                    out.writeBoolean(this.first);
                    break;
                }
                case 1: {
                    out.writeLong(this.seqno);
                    break;
                }
            }
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            switch (this.type) {
                case 0: {
                    this.seqno = in.readLong();
                    this.conn_id = in.readShort();
                    this.first = in.readBoolean();
                    break;
                }
                case 1: {
                    this.seqno = in.readLong();
                    break;
                }
            }
        }
    }
}

