/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.spi.AbstractCapability;
import org.jboss.osgi.resolver.spi.AbstractModule;
import org.osgi.framework.Version;

class AbstractPackageCapability
extends AbstractCapability
implements XPackageCapability {
    private Version version = Version.emptyVersion;

    public AbstractPackageCapability(AbstractModule module, String name, Map<String, String> dirs, Map<String, Object> atts) {
        super(module, name, dirs, atts);
        Object att = this.getAttribute("version");
        if (att != null) {
            this.version = Version.parseVersion((String)att.toString());
        }
    }

    public Version getVersion() {
        return this.version;
    }

    public List<String> getUses() {
        String dir = this.getDirective("uses");
        if (dir == null) {
            return Collections.emptyList();
        }
        String[] split = dir.split(",");
        return Arrays.asList(split);
    }

    public List<String> getMandatory() {
        String dir = this.getDirective("mandatory");
        if (dir == null) {
            return Collections.emptyList();
        }
        String[] split = dir.split(",");
        return Arrays.asList(split);
    }

    public List<String> getInclude() {
        String dir = this.getDirective("include");
        if (dir == null) {
            return Collections.emptyList();
        }
        String[] split = dir.split(",");
        return Arrays.asList(split);
    }

    public List<String> getExclude() {
        String dir = this.getDirective("exclude");
        if (dir == null) {
            return Collections.emptyList();
        }
        String[] split = dir.split(",");
        return Arrays.asList(split);
    }

    public String toString() {
        return "Export-Package[" + this.getName() + ":" + this.version + "]";
    }
}

