/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.connector.subsystems.resourceadapters.Namespace;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.Logger;

class ResourceAdaptersSubsystemProviders {
    static final String[] RESOURCEADAPTER_ATTRIBUTE = new String[]{"archive", "transaction-support", "bootstrapcontext", "config-properties", "beanvalidationgroups", "connection-definitions", "admin-objects"};
    static final NodeAttribute[] CONNECTIONDEFINITIONS_NODEATTRIBUTE = new NodeAttribute[]{new NodeAttribute("class-name", ModelType.STRING, true), new NodeAttribute("jndi-name", ModelType.STRING, true), new NodeAttribute("pool-name", ModelType.STRING, false), new NodeAttribute("use-java-context", ModelType.BOOLEAN, false), new NodeAttribute("enabled", ModelType.BOOLEAN, false), new NodeAttribute("max-pool-size", ModelType.INT, false), new NodeAttribute("min-pool-size", ModelType.INT, false), new NodeAttribute("pool-use-strict-min", ModelType.BOOLEAN, false), new NodeAttribute("flush-strategy", ModelType.STRING, false), new NodeAttribute("security-domain-and-application", ModelType.STRING, false), new NodeAttribute("security-application", ModelType.STRING, false), new NodeAttribute("security-domain", ModelType.STRING, false), new NodeAttribute("allocation-retry", ModelType.BOOLEAN, false), new NodeAttribute("allocation-retry-wait-millis", ModelType.LONG, false), new NodeAttribute("blocking-timeout-wait-millis", ModelType.LONG, false), new NodeAttribute("idle-timeout-minutes", ModelType.INT, false), new NodeAttribute("xa-resource-timeout", ModelType.LONG, false), new NodeAttribute("use-try-lock", ModelType.BOOLEAN, false), new NodeAttribute("background-validation-millis", ModelType.LONG, false), new NodeAttribute("background-validation", ModelType.BOOLEAN, false), new NodeAttribute("use-fast-fail", ModelType.BOOLEAN, false), new NodeAttribute("use-ccm", ModelType.BOOLEAN, false)};
    static final NodeAttribute[] ADMIN_OBJECTS_NODEATTRIBUTE = new NodeAttribute[]{new NodeAttribute("class-name", ModelType.STRING, true), new NodeAttribute("jndi-name", ModelType.STRING, true), new NodeAttribute("pool-name", ModelType.STRING, false), new NodeAttribute("use-java-context", ModelType.BOOLEAN, false), new NodeAttribute("enabled", ModelType.BOOLEAN, false)};
    static final String RESOURCE_NAME = ResourceAdaptersSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("resource-adapters"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.RESOURCEADAPTERS_1_0.getUriString());
            subsystem.get(new String[]{"children", "resource-adapter", "description"}).set(bundle.getString("resource-adapter"));
            subsystem.get(new String[]{"children", "resource-adapter", "required"}).set(false);
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("resource-adapters.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider RESOURCEADAPTER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode resourceAdaptersNode = new ModelNode();
            resourceAdaptersNode.get("head-comment-allowed").set(true);
            resourceAdaptersNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("resource-adapters");
            ModelNode connectionDefinitionsNode = new ModelNode();
            connectionDefinitionsNode.get("head-comment-allowed").set(true);
            connectionDefinitionsNode.get("tail-comment-allowed").set(true);
            connectionDefinitionsNode.get("description").set("connection-definitions");
            for (NodeAttribute attribute : CONNECTIONDEFINITIONS_NODEATTRIBUTE) {
                Logger.getLogger(this.getClass()).debugf("##########################################%s", (Object)attribute.getName());
                connectionDefinitionsNode.get(new String[]{"attributes", attribute.getName(), "description"}).set(bundle.getString(attribute.getName()));
                connectionDefinitionsNode.get(new String[]{"attributes", attribute.getName(), "type"}).set(attribute.getModelType());
                connectionDefinitionsNode.get(new String[]{"attributes", attribute.getName(), "required"}).set(attribute.isRequired());
            }
            resourceAdaptersNode.get("connection-definitions").set(connectionDefinitionsNode);
            ModelNode adminObjectNode = new ModelNode();
            adminObjectNode.get("head-comment-allowed").set(true);
            adminObjectNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("admin-objects");
            for (NodeAttribute attribute : ADMIN_OBJECTS_NODEATTRIBUTE) {
                adminObjectNode.get(new String[]{"attributes", attribute.getName(), "description"}).set(bundle.getString(attribute.getName()));
                adminObjectNode.get(new String[]{"attributes", attribute.getName(), "type"}).set(attribute.getModelType());
                adminObjectNode.get(new String[]{"attributes", attribute.getName(), "required"}).set(attribute.isRequired());
            }
            resourceAdaptersNode.get("admin-objects").set(adminObjectNode);
            resourceAdaptersNode.get(new String[]{"attributes", "archive", "description"}).set(bundle.getString("archive"));
            resourceAdaptersNode.get(new String[]{"attributes", "archive", "type"}).set(ModelType.STRING);
            resourceAdaptersNode.get(new String[]{"attributes", "archive", "required"}).set(true);
            resourceAdaptersNode.get(new String[]{"attributes", "transaction-support", "description"}).set(bundle.getString("transaction-support"));
            resourceAdaptersNode.get(new String[]{"attributes", "transaction-support", "type"}).set(ModelType.STRING);
            resourceAdaptersNode.get(new String[]{"attributes", "transaction-support", "required"}).set(false);
            resourceAdaptersNode.get(new String[]{"attributes", "config-properties", "type"}).set(ModelType.STRING);
            resourceAdaptersNode.get(new String[]{"attributes", "config-properties", "required"}).set(false);
            resourceAdaptersNode.get(new String[]{"attributes", "beanvalidationgroups", "description"}).set(bundle.getString("beanvalidationgroups"));
            resourceAdaptersNode.get(new String[]{"attributes", "beanvalidationgroups", "type"}).set(ModelType.STRING);
            resourceAdaptersNode.get(new String[]{"attributes", "beanvalidationgroups", "required"}).set(false);
            return resourceAdaptersNode;
        }
    };
    static final DescriptionProvider ADD_RESOURCEADAPTER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("resource-adapter.add"));
            ModelNode connectionDefinitionsNode = new ModelNode();
            connectionDefinitionsNode.get("description").set("connection-definitions");
            for (NodeAttribute attribute : CONNECTIONDEFINITIONS_NODEATTRIBUTE) {
                connectionDefinitionsNode.get(new String[]{"request-properties", attribute.getName(), "description"}).set(bundle.getString(attribute.getName()));
                connectionDefinitionsNode.get(new String[]{"request-properties", attribute.getName(), "type"}).set(attribute.getModelType());
                connectionDefinitionsNode.get(new String[]{"request-properties", attribute.getName(), "required"}).set(attribute.isRequired());
            }
            operation.get("connection-definitions").set(connectionDefinitionsNode);
            ModelNode adminObjectNode = new ModelNode();
            adminObjectNode.get("description").set("admin-objects");
            for (NodeAttribute attribute : ADMIN_OBJECTS_NODEATTRIBUTE) {
                adminObjectNode.get(new String[]{"request-properties", attribute.getName(), "description"}).set(bundle.getString(attribute.getName()));
                adminObjectNode.get(new String[]{"request-properties", attribute.getName(), "type"}).set(attribute.getModelType());
                adminObjectNode.get(new String[]{"request-properties", attribute.getName(), "required"}).set(attribute.isRequired());
            }
            operation.get("admin-objects").set(adminObjectNode);
            operation.get(new String[]{"request-properties", "archive", "description"}).set(bundle.getString("archive"));
            operation.get(new String[]{"request-properties", "archive", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "archive", "required"}).set(true);
            operation.get(new String[]{"request-properties", "transaction-support", "description"}).set(bundle.getString("transaction-support"));
            operation.get(new String[]{"request-properties", "transaction-support", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "transaction-support", "required"}).set(true);
            return operation;
        }
    };
    static DescriptionProvider REMOVE_RESOURCEADAPTER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle.getString("resourceadapter.remove"));
            return operation;
        }
    };
    static DescriptionProvider FLUSH_IDLE_CONNECTION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("flush-idle-connection-in-pool");
            operation.get("description").set(bundle.getString("resourceadapter.flush-idle-connection-in-pool"));
            return operation;
        }
    };
    static DescriptionProvider FLUSH_ALL_CONNECTION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("flush-all-connection-in-pool");
            operation.get("description").set(bundle.getString("resourceadapter.flush-all-connection-in-pool"));
            return operation;
        }
    };
    static DescriptionProvider TEST_CONNECTION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("test-connection-in-pool");
            operation.get("description").set(bundle.getString("resourceadapter.test-connection-in-pool"));
            return operation;
        }
    };

    ResourceAdaptersSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    static class NodeAttribute {
        private final String name;
        private final ModelType modelType;
        private final boolean required;

        public NodeAttribute(String name, ModelType modelType, boolean required) {
            this.name = name;
            this.modelType = modelType;
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public ModelType getModelType() {
            return this.modelType;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return "NodeAttribute [name=" + this.name + ", modelType=" + this.modelType + ", required=" + this.required + "]";
        }
    }
}

