/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class ResourceAdaptersService
implements Service<ModifiableResourceAdaptors> {
    private final ModifiableResourceAdaptors value;
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.resourceadapters");

    public ResourceAdaptersService(ModifiableResourceAdaptors value) {
        this.value = value;
    }

    public ModifiableResourceAdaptors getValue() throws IllegalStateException {
        return this.value;
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting ResourceAdapters Service", new Object[0]);
    }

    public void stop(StopContext context) {
    }

    public static final class ModifiableResourceAdaptors
    implements ResourceAdapters {
        private static final long serialVersionUID = 9096011997958619051L;
        private final ArrayList<ResourceAdapter> resourceAdapters;

        public ModifiableResourceAdaptors(List<ResourceAdapter> resourceAdapters) {
            if (resourceAdapters != null) {
                this.resourceAdapters = new ArrayList(resourceAdapters.size());
                this.resourceAdapters.addAll(resourceAdapters);
            } else {
                this.resourceAdapters = new ArrayList(0);
            }
        }

        public List<ResourceAdapter> getResourceAdapters() {
            return Collections.unmodifiableList(this.resourceAdapters);
        }

        public boolean addResourceAdapter(ResourceAdapter ra) {
            return this.resourceAdapters.add(ra);
        }

        public boolean addAllResourceAdapters(Collection<ResourceAdapter> ras) {
            return this.resourceAdapters.addAll(ras);
        }

        public boolean removeAllResourceAdapters(Collection<ResourceAdapter> ras) {
            return this.resourceAdapters.removeAll(ras);
        }
    }
}

