/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.connector.subsystems.jca.Attribute;
import org.jboss.as.connector.subsystems.jca.Element;
import org.jboss.as.connector.subsystems.jca.JcaSubSystemRemove;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemAdd;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemProviders;
import org.jboss.as.connector.subsystems.jca.Namespace;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.threads.BoundedQueueThreadPoolAdd;
import org.jboss.as.threads.BoundedQueueThreadPoolRemove;
import org.jboss.as.threads.ThreadsDescriptionUtil;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JcaExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.connector");
    private static String SUBSYSTEM_NAME = "jca";

    public void initialize(ExtensionContext context) {
        log.debugf("Initializing Connector Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem("jca");
        registration.registerXMLElementWriter((XMLElementWriter)NewConnectorSubsystemParser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel(JcaSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationStepHandler)JcaSubsystemAdd.INSTANCE, JcaSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("remove", JcaSubSystemRemove.INSTANCE, JcaSubsystemProviders.SUBSYSTEM_REMOVE_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationStepHandler)ConnectorSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)ConnectorSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration threadPools = subsystem.registerSubModel(PathElement.pathElement((String)"thread-pool"), ThreadsSubsystemProviders.BOUNDED_QUEUE_THREAD_POOL_DESC);
        threadPools.registerOperationHandler("add", (OperationStepHandler)BoundedQueueThreadPoolAdd.INSTANCE, (DescriptionProvider)BoundedQueueThreadPoolAdd.INSTANCE, false);
        threadPools.registerOperationHandler("remove", (OperationStepHandler)BoundedQueueThreadPoolRemove.INSTANCE, (DescriptionProvider)BoundedQueueThreadPoolRemove.INSTANCE, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)NewConnectorSubsystemParser.INSTANCE);
    }

    private static ModelNode createEmptyAddOperation() {
        ModelNode address = new ModelNode();
        address.add("subsystem", "jca");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        return subsystem;
    }

    private static class ConnectorSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final ConnectorSubsystemDescribeHandler INSTANCE = new ConnectorSubsystemDescribeHandler();

        private ConnectorSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode add = JcaExtension.createEmptyAddOperation();
            ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
            if (model.hasDefined("bean-validation-enabled")) {
                add.get("bean-validation-enabled").set(model.get("bean-validation-enabled"));
            }
            if (model.hasDefined("archive-validation-enabled")) {
                add.get("archive-validation-enabled").set(model.get("archive-validation-enabled"));
            }
            if (model.hasDefined("archive-validation-fail-on-error")) {
                add.get("archive-validation-fail-on-error").set(model.get("archive-validation-fail-on-error"));
            }
            if (model.hasDefined("archive-validation-fail-on-warn")) {
                add.get("archive-validation-fail-on-warn").set(model.get("archive-validation-fail-on-warn"));
            }
            if (model.hasDefined("cached-connection-manager-debug")) {
                add.get("cached-connection-manager-debug").set(model.get("cached-connection-manager-debug"));
            }
            if (model.hasDefined("cached-connection-manager-error")) {
                add.get("cached-connection-manager-error").set(model.get("cached-connection-manager-error"));
            }
            ModelNode result = context.getResult();
            result.add(add);
            if (model.hasDefined("thread-pool")) {
                ModelNode pools = model.get("thread-pool");
                for (Property poolProp : pools.asPropertyList()) {
                    if (poolProp.getName().equals("jca-long-running-threads")) {
                        ThreadsDescriptionUtil.addBoundedQueueThreadPool((ModelNode)result, (ModelNode)poolProp.getValue(), (PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME), PathElement.pathElement((String)"thread-pool", (String)"jca-long-running-threads")});
                        continue;
                    }
                    if (!poolProp.getName().equals("jca-short-running-threads")) continue;
                    ThreadsDescriptionUtil.addBoundedQueueThreadPool((ModelNode)result, (ModelNode)poolProp.getValue(), (PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME), PathElement.pathElement((String)"thread-pool", (String)"jca-short-running-threads")});
                }
            }
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static final class NewConnectorSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final NewConnectorSubsystemParser INSTANCE = new NewConnectorSubsystemParser();

        NewConnectorSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            this.writeArchiveValidation(writer, node);
            this.writeBeanValidation(writer, node);
            this.writeDefaultWorkManager(writer, node);
            this.writeCachedConnectionManager(writer, node);
            writer.writeEndElement();
        }

        private void writeArchiveValidation(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            if (this.hasAnyOf(node, "archive-validation-enabled", "archive-validation-fail-on-error", "archive-validation-fail-on-warn")) {
                writer.writeEmptyElement(Element.ARCHIVE_VALIDATION.getLocalName());
                if (this.has(node, "archive-validation-enabled")) {
                    this.writeAttribute(writer, Attribute.ENABLED, node.require("archive-validation-enabled"));
                }
                if (this.has(node, "archive-validation-fail-on-error")) {
                    this.writeAttribute(writer, Attribute.FAIL_ON_ERROR, node.require("archive-validation-fail-on-error"));
                }
                if (this.has(node, "archive-validation-fail-on-warn")) {
                    this.writeAttribute(writer, Attribute.FAIL_ON_WARN, node.require("archive-validation-fail-on-warn"));
                }
            }
        }

        private void writeBeanValidation(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            if (this.has(node, "bean-validation-enabled")) {
                writer.writeEmptyElement(Element.BEAN_VALIDATION.getLocalName());
                this.writeAttribute(writer, Attribute.ENABLED, node.require("bean-validation-enabled"));
            }
        }

        private void writeCachedConnectionManager(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            if (this.has(node, "cached-connection-manager-debug") || this.has(node, "cached-connection-manager-error")) {
                writer.writeEmptyElement(Element.CACHED_CONNECTION_MANAGER.getLocalName());
                if (this.has(node, "cached-connection-manager-debug")) {
                    this.writeAttribute(writer, Attribute.DEBUG, node.require("cached-connection-manager-debug"));
                }
                if (this.has(node, "cached-connection-manager-error")) {
                    this.writeAttribute(writer, Attribute.ERROR, node.require("cached-connection-manager-error"));
                }
            }
        }

        private void writeDefaultWorkManager(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            if (node.hasDefined("thread-pool")) {
                writer.writeStartElement(Element.DEFAULT_WORKMANAGER.getLocalName());
                for (Property prop : node.get("thread-pool").asPropertyList()) {
                    if ("jca-long-running-threads".equals(prop.getName())) {
                        ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue(), Element.LONG_RUNNING_THREADS.getLocalName(), false);
                    }
                    if (!"jca-short-running-threads".equals(prop.getName())) continue;
                    ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue(), Element.SHORT_RUNNING_THREADS.getLocalName(), false);
                }
                writer.writeEndElement();
            }
        }

        private boolean hasAnyOf(ModelNode node, String ... names) {
            for (String current : names) {
                if (!this.has(node, current)) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
            writer.writeAttribute(attr.getLocalName(), value.asString());
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", "jca");
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            EnumSet<Element> requiredElement = EnumSet.of(Element.DEFAULT_WORKMANAGER);
            block9: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case JCA_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (!visited.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case ARCHIVE_VALIDATION: {
                                this.parseArchiveValidation(reader, subsystem);
                                continue block9;
                            }
                            case BEAN_VALIDATION: {
                                this.parseBeanValidation(reader, subsystem);
                                continue block9;
                            }
                            case DEFAULT_WORKMANAGER: {
                                this.parseDefaultWorkManager(reader, address, list, subsystem);
                                requiredElement.remove((Object)Element.DEFAULT_WORKMANAGER);
                                continue block9;
                            }
                            case CACHED_CONNECTION_MANAGER: {
                                this.parseCcm(reader, subsystem);
                                continue block9;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!requiredElement.isEmpty()) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, requiredElement);
            }
        }

        private void parseArchiveValidation(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
            int cnt = reader.getAttributeCount();
            block5: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ENABLED: {
                        node.get("archive-validation-enabled").set(Boolean.parseBoolean(reader.getAttributeValue(i)));
                        continue block5;
                    }
                    case FAIL_ON_ERROR: {
                        node.get("archive-validation-fail-on-error").set(Boolean.parseBoolean(reader.getAttributeValue(i)));
                        continue block5;
                    }
                    case FAIL_ON_WARN: {
                        node.get("archive-validation-fail-on-warn").set(Boolean.parseBoolean(reader.getAttributeValue(i)));
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        private void parseDefaultWorkManager(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, ModelNode node) throws XMLStreamException {
            block4: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case LONG_RUNNING_THREADS: {
                        ThreadsParser.getInstance().parseBoundedQueueThreadPool(reader, parentAddress, list, "thread-pool", "jca-long-running-threads");
                        continue block4;
                    }
                    case SHORT_RUNNING_THREADS: {
                        ThreadsParser.getInstance().parseBoundedQueueThreadPool(reader, parentAddress, list, "thread-pool", "jca-short-running-threads");
                        continue block4;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            for (ModelNode op : list) {
                if (!op.hasDefined("blocking")) continue;
                op.get("blocking").set(Boolean.TRUE.booleanValue());
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        private void parseBeanValidation(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.ENABLED.getLocalName());
            boolean value = reader.getAttributeValue(0) != null ? Boolean.parseBoolean(reader.getAttributeValue(0)) : true;
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            node.get("bean-validation-enabled").set(value);
        }

        private void parseCcm(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
            boolean debug = Boolean.parseBoolean(reader.getAttributeValue("", Attribute.DEBUG.getLocalName()));
            boolean error = Boolean.parseBoolean(reader.getAttributeValue("", Attribute.ERROR.getLocalName()));
            node.get("cached-connection-manager-debug").set(debug);
            node.get("cached-connection-manager-error").set(error);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }
}

