/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.registry.DriverRegistry;
import org.jboss.as.connector.registry.InstalledDriver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class InstalledDriversListOperationHandler
implements OperationStepHandler {
    public static final InstalledDriversListOperationHandler INSTANCE = new InstalledDriversListOperationHandler();

    private InstalledDriversListOperationHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController sc = context.getServiceRegistry(false).getRequiredService(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE);
                    DriverRegistry driverRegistry = (DriverRegistry)DriverRegistry.class.cast(sc.getValue());
                    ModelNode result = context.getResult();
                    for (InstalledDriver driver : driverRegistry.getInstalledDrivers()) {
                        ModelNode driverNode = new ModelNode();
                        driverNode.get("driver-name").set(driver.getDriverName());
                        if (driver.isFromDeployment()) {
                            driverNode.get("deployment-name").set(driver.getDriverName());
                            driverNode.get("driver-module-name");
                            driverNode.get("module-slot");
                            driverNode.get("driver-datasource-class-name");
                            driverNode.get("driver-xa-datasource-class-name");
                        } else {
                            driverNode.get("deployment-name");
                            driverNode.get("driver-module-name").set(driver.getModuleName().getName());
                            driverNode.get("module-slot").set(driver.getModuleName() != null ? driver.getModuleName().getSlot() : "");
                            driverNode.get("driver-datasource-class-name").set(driver.getDataSourceClassName() != null ? driver.getDataSourceClassName() : "");
                            driverNode.get("driver-xa-datasource-class-name").set(driver.getXaDataSourceClassName() != null ? driver.getXaDataSourceClassName() : "");
                        }
                        driverNode.get("driver-class-name").set(driver.getDriverClassName());
                        driverNode.get("driver-major-version").set(driver.getMajorVersion());
                        driverNode.get("driver-minor-version").set(driver.getMinorVersion());
                        driverNode.get("jdbc-compliant").set(driver.isJdbcCompliant());
                        result.add(driverNode);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        } else {
            context.getResult().set("no metrics available");
        }
        context.completeStep();
    }
}

