/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public final class InterfaceCriteriaWriteHandler
implements OperationStepHandler {
    public static final OperationStepHandler INSTANCE = new InterfaceCriteriaWriteHandler();

    private InterfaceCriteriaWriteHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode value = operation.require("value");
        ParsedInterfaceCriteria criteria = ParsedInterfaceCriteria.parse(value, false);
        if (criteria.getFailureMessage() != null) {
            context.getFailureDescription().set(criteria.getFailureMessage());
        } else {
            ModelNode subModel = resource.getModel();
            subModel.get("criteria").set(value);
            if (context.getType() == OperationContext.Type.SERVER) {
                context.reloadRequired();
            }
        }
        context.completeStep();
    }
}

